/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ischub.triggerhandle.HubCallApiHandler;
import kd.isc.iscb.platform.core.connector.ischub.triggerhandle.HubDataCopyHandler;
import kd.isc.iscb.platform.core.connector.ischub.triggerhandle.HubEntityPublishHandler;
import kd.isc.iscb.platform.core.connector.ischub.triggerhandle.HubServiceFlowHandler;
import kd.isc.iscb.platform.core.connector.ischub.triggerhandle.HubServiceFlowWaitingHandler;
import kd.isc.iscb.platform.core.connector.ischub.triggerhandle.HubTriggerHandler;

public class HubEventHandler {
    private static Map<String, HubTriggerHandler> eventHandlers = new HashMap<String, HubTriggerHandler>();

    public static void handle(String triggerType, long triggerId, Map<String, Object> data, Map<String, Object> extendProps) {
        HubTriggerHandler triggerHandler = eventHandlers.get(triggerType);
        if (triggerHandler == null) {
            throw new UnsupportedOperationException("TODO-trigger_type=" + triggerType);
        }
        triggerHandler.handle(triggerId, Collections.singletonList(data), extendProps);
    }

    static {
        eventHandlers.put("isc_data_copy_trigger", new HubDataCopyHandler());
        eventHandlers.put("isc_mq_bill_data_pub", new HubEntityPublishHandler());
        eventHandlers.put("isc_service_flow", new HubServiceFlowHandler());
        eventHandlers.put("isc_call_api_by_evt", new HubCallApiHandler());
        eventHandlers.put("isc_sf_waiting_event", new HubServiceFlowWaitingHandler());
    }
}

