/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.retriever;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.ResourceType;
import kd.isc.iscb.platform.core.connector.ischub.retriever.Const;
import kd.isc.iscb.platform.core.connector.ischub.retriever.MetaRetriever;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public abstract class IscMetaRetriever
implements MetaRetriever,
Const {
    protected ResourceType type;

    protected IscMetaRetriever(ResourceType type) {
        this.type = type;
    }

    protected abstract List<Map<String, Object>> getEvents(DynamicObject var1);

    protected abstract List<Map<String, Object>> getProperties(DynamicObject var1);

    protected List<Map<String, Object>> appendMetaInfo(DynamicObject obj) {
        return Collections.emptyList();
    }

    @Override
    public Map<String, MetaType> getMetaList() {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)this.type.name(), (String)"number", null);
        HashMap<String, MetaType> metas = new HashMap<String, MetaType>(objs.size());
        for (DynamicObject obj : objs) {
            metas.put(this.type.name() + "/" + obj.getString("number"), MetaType.EVT_RSC);
        }
        return metas;
    }

    @Override
    public List<Map<String, Object>> getMetaInfo(DynamicObject obj) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> entityMap = new HashMap<String, Object>(8);
        entityMap.put("type", MetaType.EVT_RSC.name());
        entityMap.put("table_name", null);
        entityMap.put("events", this.getEvents(obj));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.type.name());
        String fullname = this.type.name() + "/" + obj.getString("number");
        entityMap.put("full_name", fullname);
        entityMap.put("name", Hash.mur32((Object[])new Object[]{fullname}));
        entityMap.put("title", this.getTitle(entityType, obj));
        entityMap.put("properties", this.getProperties(obj));
        list.add(entityMap);
        list.add(this.getStructBaseInfo());
        list.addAll(this.appendMetaInfo(obj));
        return list;
    }

    protected String getTitle(MainEntityType entityType, DynamicObject obj) {
        if (obj != null) {
            String title = entityType.getDisplayName() + "/" + obj.get("name");
            return StringUtil.trim((String)title, (int)150);
        }
        return String.format(ResManager.loadKDString((String)"%s/\u5168\u90e8", (String)"IscMetaRetriever_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityType.getDisplayName());
    }

    protected void addStructProperty(List<Map<String, Object>> props, int index, String propName, String propTitle) {
        this.addProperty(props, index, propName, propTitle, "STRUCT", "BASE_STRUCT_INFO");
    }

    protected void addTimeProperty(List<Map<String, Object>> props, int index, String propName, String propTitle) {
        this.addProperty(props, index, propName, propTitle, "datetime", null);
    }

    protected void addProperty(List<Map<String, Object>> props, int index, String propName, String propTitle, String propType, String propSchema) {
        this.addProperty(props, index, propName, propTitle, propType, propSchema, null);
    }

    protected void addProperty(List<Map<String, Object>> props, int index, String propName, String propTitle, String propType, String propSchema, String remark) {
        HashMap<String, Object> item = new HashMap<String, Object>(8);
        item.put("name", propName);
        if (StringUtil.isEmpty((String)propTitle)) {
            propTitle = propName;
        }
        item.put("label", propTitle);
        item.put("data_type", propType);
        item.put("data_schema", propSchema);
        item.put("is_primary_key", Boolean.FALSE);
        item.put("is_nullable", Boolean.TRUE);
        item.put("index", index);
        item.put("remark", remark);
        props.add(item);
    }

    protected void addEvent(List<Map<String, Object>> events, int index, String eventName, String eventType, String eventLabel, String eventDesc) {
        HashMap<String, Object> item = new HashMap<String, Object>(4);
        item.put("name", eventName);
        if (StringUtil.isEmpty((String)eventLabel)) {
            eventLabel = eventName;
        }
        item.put("label", eventLabel);
        item.put("type", eventType);
        item.put("index", index);
        item.put("remark", eventDesc);
        events.add(item);
    }

    private Map<String, Object> getStructBaseInfo() {
        LinkedHashMap<String, Object> struct = new LinkedHashMap<String, Object>();
        struct.put("full_name", "BASE_STRUCT_INFO");
        struct.put("name", "BASE_STRUCT_INFO");
        struct.put("type", MetaType.ENTITY.name());
        struct.put("title", ResManager.loadKDString((String)"\u57fa\u672c\u7ed3\u6784\u4fe1\u606f", (String)"IscMetaRetriever_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        ArrayList<Map<String, Object>> props = new ArrayList<Map<String, Object>>(5);
        this.addProperty(props, 1, "id", "ID", "long", null);
        this.addProperty(props, 2, "number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"IscMetaRetriever_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "string", null);
        this.addProperty(props, 3, "name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"IscMetaRetriever_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "ml_string", null);
        struct.put("properties", props);
        return struct;
    }

    private String getTableName(MainEntityType entityType) {
        String tableName = entityType.getAlias();
        String dbRouteKey = D.s((Object)entityType.getDBRouteKey());
        if (dbRouteKey != null) {
            tableName = tableName + "@" + dbRouteKey;
        }
        return tableName.toUpperCase();
    }
}

