/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.topology.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.topology.Const;
import kd.isc.iscb.platform.core.connector.ischub.topology.TopologyUtil;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.AbstractIscTopology;

public class IscTopologyDataCopy
extends AbstractIscTopology
implements Const {
    public IscTopologyDataCopy(long id) {
        super(id);
    }

    @Override
    public List<String> getUpStreamList() {
        ArrayList<String> upList = new ArrayList<String>();
        this.queryUpTrigger(upList);
        TopologyUtil.addFlowIDList(upList, "isc_data_copy", this.id);
        TopologyUtil.addScriptApiIDList(upList, "isc_data_copy", this.id);
        this.queryUpApi(upList);
        return upList;
    }

    private void queryUpApi(List<String> upList) {
        QFilter qFilter = new QFilter("schema.id", "=", (Object)this.id);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"isc_apic_by_dc_schema", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject api : collection) {
            upList.add(TopologyUtil.combination("isc_apic_by_dc_schema", api.getLong("id"), api.get("enable")));
        }
    }

    private void queryUpTrigger(List<String> upList) {
        QFilter qFilter = new QFilter("data_copy.id", "=", (Object)this.id);
        DynamicObjectCollection triggers = QueryServiceHelper.query((String)"isc_data_copy_trigger", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject trigger : triggers) {
            upList.add(TopologyUtil.combination("isc_data_copy_trigger", trigger.getLong("id"), TopologyUtil.formatEnable(trigger)));
        }
    }

    @Override
    public List<String> getDownStreamList() {
        ArrayList<String> downList = new ArrayList<String>();
        this.addMeta(downList);
        this.addConverRule(downList);
        return downList;
    }

    private void addConverRule(List<String> downList) {
        DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_data_copy");
        DynamicObjectCollection mapping_entries = dataCopy.getDynamicObjectCollection("mapping_entries");
        for (DynamicObject obj : mapping_entries) {
            DynamicObject rule = (DynamicObject)obj.get("value_conver_rule");
            if (rule == null) continue;
            downList.add(TopologyUtil.combination("isc_value_conver_rule", rule.getLong("id"), 1));
        }
    }

    private void addMeta(List<String> downList) {
        QFilter qFilter = new QFilter("id", "=", (Object)this.id);
        DynamicObject dataCopy = QueryServiceHelper.queryOne((String)"isc_data_copy", (String)"source_schema,target_schema", (QFilter[])new QFilter[]{qFilter});
        downList.add(TopologyUtil.combination("isc_metadata_schema", dataCopy.getLong("source_schema"), 1));
        downList.add(TopologyUtil.combination("isc_metadata_schema", dataCopy.getLong("target_schema"), 1));
    }
}

