/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.topology.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.topology.Const;
import kd.isc.iscb.platform.core.connector.ischub.topology.TopologyUtil;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.AbstractIscTopology;

public class IscTopologyDataSource
extends AbstractIscTopology
implements Const {
    public IscTopologyDataSource(long id) {
        super(id);
    }

    @Override
    public List<String> getUpStreamList() {
        ArrayList<String> upList = new ArrayList<String>();
        TopologyUtil.addFlowIDList(upList, "isc_data_source", this.id);
        TopologyUtil.addScriptApiIDList(upList, "isc_data_source", this.id);
        this.addRedirectTrigger(upList);
        return upList;
    }

    private void addRedirectTrigger(List<String> upList) {
        QFilter qFilter = new QFilter("new_source_system.id", "=", (Object)this.id);
        qFilter.or(new QFilter("new_target_system.id", "=", (Object)this.id));
        DynamicObjectCollection triggers = QueryServiceHelper.query((String)"isc_data_copy_trigger", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject trigger : triggers) {
            upList.add(TopologyUtil.combination("isc_data_copy_trigger", trigger.getLong("id"), TopologyUtil.formatEnable(trigger)));
        }
    }

    @Override
    public List<String> getDownStreamList() {
        return TopologyUtil.getEvcMeta("isc_data_source", this.id);
    }
}

