/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.topology.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.topology.Const;
import kd.isc.iscb.platform.core.connector.ischub.topology.TopologyUtil;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.AbstractIscTopology;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.util.dt.D;

public class IscTopologyServiceFlow
extends AbstractIscTopology
implements Const {
    private Set<String> RESOURCESS = new HashSet<String>(Arrays.asList("isc_data_source", "isc_data_copy_trigger", "isc_custom_function", "isc_apic_for_external_api", "isc_apic_script", "isc_apic_mservice", "isc_service_flow", "isc_data_copy", "isc_metadata_schema", "isc_value_conver_rule"));

    public IscTopologyServiceFlow(long id) {
        super(id);
    }

    @Override
    public List<String> getUpStreamList() {
        ArrayList<String> upList = new ArrayList<String>();
        TopologyUtil.addFlowIDList(upList, "isc_service_flow", this.id);
        TopologyUtil.addScriptApiIDList(upList, "isc_service_flow", this.id);
        this.queryFlowApi(upList);
        DynamicObject flow = QueryServiceHelper.queryOne((String)"isc_service_flow", (String)"init_mode,is_released", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.id)});
        if (flow.getBoolean("is_released") && "EVENT".equals(flow.getString("init_mode"))) {
            this.queryMeta(upList);
        }
        return upList;
    }

    private void queryFlowApi(List<String> upList) {
        QFilter qFilter = new QFilter("service_flow_id", "=", (Object)this.id);
        DynamicObjectCollection apis = QueryServiceHelper.query((String)"isc_apic_by_sf", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject api : apis) {
            upList.add(TopologyUtil.combination("isc_apic_by_sf", api.getLong("id"), TopologyUtil.formatEnable(api)));
        }
    }

    private void queryMeta(List<String> upList) {
        long releasedId = ServiceFlowParser.findReleasedFlowId(this.id);
        Map<String, Object> diagram = ServiceFlowReleaser.getDiagramJson(releasedId);
        Map nodes = (Map)diagram.get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map detail = (Map)node.getValue();
            if (!"EventStarter".equalsIgnoreCase(D.s(detail.get("type")))) continue;
            long metaId = D.l(detail.get("data_schema"));
            upList.add(TopologyUtil.combination("isc_metadata_schema", metaId, 1));
        }
    }

    @Override
    public List<String> getDownStreamList() {
        List<String> downList = TopologyUtil.getEvcMeta("isc_service_flow", this.id);
        this.getResourceList(downList);
        return downList;
    }

    private void getResourceList(List<String> downList) {
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject resource : resources) {
            long resourceId;
            String resourceType = resource.getString("res_category");
            if ("isc_data_source".equals(resourceType)) {
                resourceId = resource.getDynamicObject("res_ref").getLong("id");
                downList.add(TopologyUtil.combination("isc_data_source", resourceId, TopologyUtil.getLinkState(resourceId)));
                continue;
            }
            if (!this.RESOURCESS.contains(resourceType)) continue;
            resourceId = resource.getDynamicObject("res_ref").getLong("id");
            DynamicObject objEnable = QueryServiceHelper.queryOne((String)resourceType, (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)resourceId)});
            downList.add(TopologyUtil.combination(resourceType, resourceId, TopologyUtil.formatEnable(objEnable)));
        }
    }
}

