/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ischub.topology.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.topology.Const;
import kd.isc.iscb.platform.core.connector.ischub.topology.TopologyUtil;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.AbstractIscTopology;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class IscTopologyTrigger
extends AbstractIscTopology
implements Const {
    public IscTopologyTrigger(long id) {
        super(id);
    }

    @Override
    public List<String> getUpStreamList() {
        ArrayList<String> upList = new ArrayList<String>();
        this.queryUpMeta(upList);
        TopologyUtil.addFlowIDList(upList, "isc_data_copy_trigger", this.id);
        this.queryUpApi(upList);
        this.queryUpTrigger(upList);
        this.queryUpConvertRule(upList);
        return upList;
    }

    private void queryUpConvertRule(List<String> upList) {
        QFilter qFilter = new QFilter("data_copy_trigger.id", "=", (Object)this.id);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"isc_value_conver_rule", (String)"id", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject rule : collection) {
            upList.add(TopologyUtil.combination("isc_value_conver_rule", rule.getLong("id"), 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryUpTrigger(List<String> upList) {
        String sql = "select a.fid,b.fenable from T_ISCB_NEXT_TASKS a LEFT JOIN T_ISC_DATA_COPY_TRIGGER b on a.fid = b.fid where a.fnext_task = " + this.id;
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            try {
                DataRow data = (DataRow)reader.read();
                while (data != null) {
                    upList.add(TopologyUtil.combination("isc_data_copy_trigger", D.l((Object)data.get((Object)"fid")), data.get((Object)"fenable")));
                    data = (DataRow)reader.read();
                }
            }
            finally {
                DbUtil.close((ObjectReader)reader);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void queryUpApi(List<String> upList) {
        QFilter qFilter = new QFilter("trigger.id", "=", (Object)this.id);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"isc_apic_by_dc_trigger", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject api : collection) {
            upList.add(TopologyUtil.combination("isc_apic_by_dc_trigger", api.getLong("id"), TopologyUtil.formatEnable(api)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryUpMeta(List<String> upList) {
        String sql = "SELECT b.fsource_schema FROM T_ISC_DATA_COPY_TRIGGER a LEFT JOIN T_ISCB_DATA_COPY b on a.fdata_copy = b.fid WHERE a.fid= " + this.id + "and a.ftrigger_type = 'event'";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            try {
                DataRow data = (DataRow)reader.read();
                while (data != null) {
                    upList.add(TopologyUtil.combination("isc_metadata_schema", D.l((Object)data.get((Object)"fsource_schema")), 1));
                    data = (DataRow)reader.read();
                }
            }
            finally {
                DbUtil.close((ObjectReader)reader);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    @Override
    public List<String> getDownStreamList() {
        List<String> downList = TopologyUtil.getEvcMeta("isc_data_copy_trigger", this.id);
        this.addSchema(downList);
        this.addDownTrigger(downList);
        this.addRedirectSource(downList);
        return downList;
    }

    private void addRedirectSource(List<String> downList) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_data_copy_trigger", (String)"new_source_system_id,new_target_system_id");
        long new_source_system_id = obj.getLong("new_source_system_id");
        long new_target_system_id = obj.getLong("new_target_system_id");
        if (new_source_system_id > 0L) {
            downList.add(TopologyUtil.combination("isc_data_source", new_source_system_id, TopologyUtil.getLinkState(new_source_system_id)));
        }
        if (new_target_system_id > 0L) {
            downList.add(TopologyUtil.combination("isc_data_source", new_target_system_id, TopologyUtil.getLinkState(new_target_system_id)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownTrigger(List<String> downList) {
        String sql = "select a.fnext_task,b.fenable from T_ISCB_NEXT_TASKS a LEFT JOIN T_ISC_DATA_COPY_TRIGGER b on a.fnext_task = b.fid where a.fid = " + this.id;
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            try {
                DataRow data = (DataRow)reader.read();
                while (data != null) {
                    downList.add(TopologyUtil.combination("isc_data_copy_trigger", D.l((Object)data.get((Object)"fnext_task")), data.get((Object)"fenable")));
                    data = (DataRow)reader.read();
                }
            }
            finally {
                DbUtil.close((ObjectReader)reader);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void addSchema(List<String> downList) {
        QFilter qFilter = new QFilter("id", "=", (Object)this.id);
        DynamicObject trigger = QueryServiceHelper.queryOne((String)"isc_data_copy_trigger", (String)"data_copy", (QFilter[])new QFilter[]{qFilter});
        downList.add(TopologyUtil.combination("isc_data_copy", trigger.getLong("data_copy"), 1));
    }
}

