/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.JDBCConnectionProxy;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;

public class JDBCConnectionPool
implements Task {
    private DataSource ds;
    private String testSQL;
    private int validationQueryTimeOut;
    private boolean alwaysCheckBeforeReuseConnection;
    private DynamicObject cfg;
    private JdbcConnectionFactory factory;
    private LinkedList<Pair<Connection, Long>> notUsedConnections;
    private String id;

    JDBCConnectionPool(String key, DataSource ds, String testSQL, DynamicObject cfg, JdbcConnectionFactory factory) {
        this.ds = ds;
        this.id = key;
        this.validationQueryTimeOut = D.i((Object)System.getProperty("isc_validate_cn_query_timeout", "5"));
        String prop = D.s((Object)System.getProperty("isc_always_check_before_reused_cn"));
        this.alwaysCheckBeforeReuseConnection = prop == null || "true".equalsIgnoreCase(prop);
        this.testSQL = testSQL;
        this.notUsedConnections = new LinkedList();
        this.cfg = cfg;
        this.factory = factory;
    }

    private boolean checkConnectionValid(Connection conn) {
        boolean valid = true;
        try (Statement st = conn.createStatement();){
            st.setQueryTimeout(this.validationQueryTimeOut);
            st.execute(this.testSQL);
        }
        catch (Throwable ex) {
            valid = false;
            DbUtil.close((Connection)conn, (boolean)false);
        }
        return valid;
    }

    public Connection getConnection() throws SQLException {
        Pair<Connection, Long> pair;
        while ((pair = this.getPooledConnection()) != null) {
            if (!this.alwaysCheckBeforeReuseConnection && this.isRecycledJustNow(pair)) {
                return new JDBCConnectionProxy((Connection)pair.getA(), this);
            }
            boolean isValid = this.checkConnectionValid((Connection)pair.getA());
            if (!isValid) continue;
            return new JDBCConnectionProxy((Connection)pair.getA(), this);
        }
        Connection connection = this.ds.getConnection();
        this.factory.afterCreateHandle(connection, this.cfg);
        return new JDBCConnectionProxy(connection, this);
    }

    private boolean isRecycledJustNow(Pair<Connection, Long> pair) {
        return System.currentTimeMillis() - (Long)pair.getB() < 5000L;
    }

    private synchronized Pair<Connection, Long> getPooledConnection() {
        if (this.notUsedConnections.isEmpty()) {
            return null;
        }
        return this.notUsedConnections.removeFirst();
    }

    public synchronized void recycle(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u56de\u6536\u7684\u8fde\u63a5\u4e3a\u7a7a", (String)"JDBCConnectionPool_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        Pair pair = new Pair((Object)connection, (Object)System.currentTimeMillis());
        this.notUsedConnections.addLast((Pair<Connection, Long>)pair);
    }

    private synchronized Connection takeTimeoutConnection() {
        if (this.notUsedConnections.isEmpty()) {
            return null;
        }
        Pair<Connection, Long> p = this.notUsedConnections.getFirst();
        if (System.currentTimeMillis() - (Long)p.getValue() > 60000L) {
            return (Connection)this.notUsedConnections.removeFirst().getKey();
        }
        return null;
    }

    @Override
    public void run() {
        Connection cn;
        while ((cn = this.takeTimeoutConnection()) != null) {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        ScheduleManager.submit((Task)this, 30);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

