/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.OracleDbType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import oracle.jdbc.pool.OracleDataSource;

public final class OracleConnectionFactory
extends AbstractConnectionFactory {
    protected String getSchema(ConnectionWrapper cn) {
        String schema = D.s((Object)cn.getConfig().get("user"));
        return schema.toUpperCase();
    }

    @Override
    protected DataSource createDataSource(String url, String user, String password, DynamicObject cfg) throws SQLException {
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(url);
        ods.setUser(user);
        ods.setPassword(password);
        ods.setLoginTimeout(30);
        Properties properties = new Properties();
        properties.put("oracle.jdbc.ReadTimeout", this.getReadTimeout(cfg));
        properties.put("oracle.net.CONNECT_TIMEOUT", this.getConnectTimeout(cfg));
        properties.put("remarksReporting", "true");
        ods.setConnectionProperties(properties);
        return ods;
    }

    @Override
    public void afterCreateHandle(Connection connection, DynamicObject cfg) {
        String schema = D.s((Object)cfg.get("attr3"));
        if (schema != null) {
            if (!CommonUtil.isIllegalString(schema)) {
                DbUtil.executeUpdate((Connection)connection, (String)("ALTER SESSION SET CURRENT_SCHEMA=" + schema));
            } else {
                String tips = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e[%1$s]\u7684\u6a21\u5f0f\u540d\u5b57\u6bb5[%2$s]\u4e0d\u5408\u6cd5", (String)"OracleConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.getString("number"), schema);
                throw new IscBizException(tips);
            }
        }
    }

    private String getReadTimeout(DynamicObject cfg) {
        String readTimeout = D.s((Object)cfg.get("attr1"));
        if (readTimeout == null) {
            return this.getDefaultReadTimeout();
        }
        return readTimeout;
    }

    private String getDefaultReadTimeout() {
        return System.getProperty("isc_oracle_read_timeout", "900000");
    }

    private String getConnectTimeout(DynamicObject cfg) {
        String connectTimeout = D.s((Object)cfg.get("attr2"));
        if (connectTimeout != null) {
            return connectTimeout;
        }
        return this.getDefaultConnectTimeout();
    }

    private String getDefaultConnectTimeout() {
        return System.getProperty("isc_oracle_connect_timeout", "360000");
    }

    @Override
    protected String getCacheKey(String url, String user, String password, DynamicObject cfg) {
        return url + ";" + user + ";" + password + ";" + cfg.get("attr1") + ";" + cfg.get("attr2") + ";" + cfg.get("attr3");
    }

    @Override
    protected String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        String service = cfg.getString("oracle_service");
        if (service.startsWith("/")) {
            return "jdbc:oracle:thin:@//" + server + ":" + port + "/" + service.substring(1);
        }
        return "jdbc:oracle:thin:@" + server + ":" + port + ":" + service;
    }

    @Override
    protected String getTestSQL() {
        return "select 1 from dual";
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT*FROM (" + sql + ")X WHERE ROWNUM<=" + topN;
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case VIEW: {
                return true;
            }
            case TABLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DbType getDatabaseType() {
        return new OracleDbType();
    }

    @Override
    public String getUpsertSql(Table table, List<Column> fields) {
        StringBuilder selectClause = new StringBuilder();
        StringBuilder insertFields = new StringBuilder();
        StringBuilder valuesClause = new StringBuilder();
        this.initSelectClause(fields, selectClause, insertFields, valuesClause);
        StringBuilder sql = new StringBuilder();
        sql.append("MERGE INTO ").append(table.getQuotedName()).append(" t ");
        sql.append("USING (SELECT ");
        sql.append((CharSequence)selectClause);
        sql.append(" FROM DUAL) s ON (");
        sql.append((CharSequence)this.initOnClause(table));
        sql.append(") WHEN MATCHED THEN UPDATE SET ");
        sql.append((CharSequence)this.initUpdateClause(fields));
        sql.append(" WHEN NOT MATCHED THEN INSERT (");
        sql.append((CharSequence)insertFields);
        sql.append(')');
        sql.append(" VALUES (");
        sql.append((CharSequence)valuesClause);
        sql.append(')');
        return sql.toString();
    }

    private StringBuilder initOnClause(Table table) {
        StringBuilder onClause = new StringBuilder();
        List primaryKeys = table.getPrimaryKeys();
        for (int i = 0; i < primaryKeys.size(); ++i) {
            if (i > 0) {
                onClause.append(" AND ");
            }
            Column primaryKey = (Column)primaryKeys.get(i);
            onClause.append(this.getSrcToTarBinding(primaryKey));
        }
        return onClause;
    }

    private StringBuilder initUpdateClause(List<Column> fields) {
        StringBuilder updateClause = new StringBuilder();
        for (Column field : fields) {
            if (field.isPrimaryKey()) continue;
            if (updateClause.length() > 0) {
                updateClause.append(',');
            }
            updateClause.append(this.getSrcToTarBinding(field));
        }
        return updateClause;
    }

    private void initSelectClause(List<Column> fields, StringBuilder selectClause, StringBuilder insertFields, StringBuilder valuesClause) {
        boolean first = true;
        for (Column field : fields) {
            if (first) {
                first = false;
            } else {
                selectClause.append(',');
                insertFields.append(',');
                valuesClause.append(',');
            }
            selectClause.append("? ").append(field.getBinding());
            insertFields.append(field.getBinding());
            valuesClause.append("s.").append(field.getBinding());
        }
    }

    private String getSrcToTarBinding(Column c) {
        return "t." + c.getBinding() + "=s." + c.getBinding();
    }
}

