/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.postgresql.PostgreUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.PostgreSqlDbType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Hash;
import org.postgresql.ds.PGSimpleDataSource;

@Deprecated
public final class PgSqlConnectionFactory
extends AbstractConnectionFactory {
    @Override
    protected DataSource createDataSource(String url, String user, String password) throws SQLException {
        PGSimpleDataSource ods = new PGSimpleDataSource();
        ods.setUrl(url);
        ods.setUser(user);
        ods.setPassword(password);
        ods.setLoginTimeout(30);
        return ods;
    }

    @Override
    protected String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        String database = cfg.getString("sql_database");
        String url = "jdbc:postgresql://" + server + ":" + port + "/" + database;
        String charset = D.s((Object)cfg.getString("charset"));
        if (charset != null) {
            url = url + "?characterEncoding=" + charset;
        }
        return url;
    }

    @Override
    public char getQuot() {
        return '\"';
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        Map<String, MetaType> metaList = super.getMetaList(cn);
        for (Map.Entry<String, MetaType> entry : metaList.entrySet()) {
            entry.setValue(MetaType.ENTITY);
        }
        return metaList;
    }

    @Override
    protected String getTestSQL() {
        return "select 1";
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT * FROM (" + sql + ")X LIMIT " + topN + " OFFSET 0";
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        return MetaType.valueOf((String)type) == MetaType.ENTITY;
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper connectionWrapper, String table_name) {
        JdbcConnectionWrapper cn = (JdbcConnectionWrapper)connectionWrapper;
        Map<String, Object> map = super.getTableInfo(cn, table_name);
        map.put("type", MetaType.ENTITY.name());
        map.put("full_name", table_name);
        map.put("title", table_name.toUpperCase());
        map.put("name", Hash.mur32((Object[])new Object[]{table_name}));
        map.put("actions", this.buildActionList());
        return Collections.singletonList(map);
    }

    private List<Map<String, Object>> buildActionList() {
        ArrayList<Map<String, Object>> actionList = new ArrayList<Map<String, Object>>();
        actionList.add(this.buildActionMap("_SAVE", 1, ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u4fdd\u5b58\uff09", (String)"PgSqlConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "save"));
        actionList.add(this.buildActionMap("_INSERT", 2, ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u65b0\u589e\uff09", (String)"PgSqlConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "insert"));
        actionList.add(this.buildActionMap("_UPDATE", 3, ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u4fee\u6539\uff09", (String)"PgSqlConnectionFactory_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "update"));
        actionList.add(this.buildActionMap("_DELETE", 4, ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u5220\u9664\uff09", (String)"PgSqlConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "delete"));
        return actionList;
    }

    private Map<String, Object> buildActionMap(String name, int index, String label, String type) {
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("name", name);
        action.put("index", index);
        action.put("label", label);
        action.put("type", type);
        return action;
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filterList, List<Map<String, String>> sortList) {
        if (CollectionUtils.isEmpty(requires)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u4e3a\u7a7a", (String)"PgSqlConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        cn.ensureFluidControl();
        return PostgreUtil.get(cn, entity, requires, filterList, sortList);
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        cn.ensureFluidControl();
        try {
            JdbcConnectionWrapper jc = (JdbcConnectionWrapper)cn;
            return TableUtil.doAction((Connection)jc, data, (Table)cn.getTable(entity), Collections.emptyMap(), judgeFields, actions);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public List<Response> doBatchBizAction(ConnectionWrapper cn, String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, String action, String proxy_user) {
        cn.ensureFluidControl();
        ArrayList<Map<String, Object>> for_insert = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> for_update = new ArrayList<Map<String, Object>>();
        Table table = cn.getTable(entity);
        List<String> judgeFieldList = judgeFields.get("$");
        if (judgeFieldList.size() == 1) {
            PostgreUtil.handleOneKey(cn, table, judgeFieldList.get(0), for_insert, for_update, batch);
        } else {
            PostgreUtil.handleMultiKey(cn, table, judgeFieldList, for_insert, for_update, batch);
        }
        return PostgreUtil.doBatchAction(cn, table, action, for_insert, for_update, entity, judgeFieldList);
    }

    @Override
    public boolean supportsBizBatchAction(ConnectionWrapper cn) {
        return true;
    }

    @Override
    public DbType getDatabaseType() {
        return new PostgreSqlDbType();
    }
}

