/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.SqlServerDbType;
import kd.isc.iscb.util.dt.D;

public final class SqlServerConnectionFactory
extends AbstractConnectionFactory {
    private static Method setSocketTimeoutMethod;

    @Override
    protected String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        String database = cfg.getString("sql_database");
        String url = "jdbc:sqlserver://" + server + ":" + port + "; DatabaseName=" + database;
        return url;
    }

    @Override
    protected DataSource createDataSource(String url, String user, String password, DynamicObject cfg) throws SQLException {
        SQLServerDataSource ods = new SQLServerDataSource();
        ods.setURL(url);
        ods.setUser(user);
        ods.setPassword(password);
        ods.setLoginTimeout(30);
        ods.setEncrypt("true".equals(cfg.get("attr1")));
        ods.setTrustServerCertificate(true);
        if (setSocketTimeoutMethod != null) {
            try {
                setSocketTimeoutMethod.invoke((Object)ods, this.getSocketTimeout(cfg));
            }
            catch (Exception e) {
                throw D.e((Throwable)e);
            }
        }
        return ods;
    }

    private int getSocketTimeout(DynamicObject cfg) {
        String socketTimeout = D.s((Object)cfg.get("attr2"));
        if (socketTimeout != null) {
            return D.i((Object)socketTimeout);
        }
        return 360000;
    }

    @Override
    protected String getCacheKey(String url, String user, String password, DynamicObject cfg) {
        return url + ";" + user + ";" + password + ";" + cfg.get("attr1") + ";" + cfg.get("attr2");
    }

    @Override
    protected String getTestSQL() {
        return "select 1";
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT TOP " + topN + " " + sql.substring("SELECT".length());
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case VIEW: {
                return true;
            }
            case TABLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public DbType getDatabaseType() {
        return new SqlServerDbType();
    }

    @Override
    public String getUpsertSql(Table table, List<Column> fields) {
        StringBuilder selectClause = new StringBuilder();
        StringBuilder insertFields = new StringBuilder();
        StringBuilder valuesClause = new StringBuilder();
        this.initSelectClause(fields, selectClause, insertFields, valuesClause);
        StringBuilder sql = new StringBuilder();
        sql.append("MERGE INTO ").append(table.getQuotedName()).append(" AS T ");
        sql.append("USING (SELECT ").append((CharSequence)selectClause).append(") AS S ");
        sql.append("ON (").append((CharSequence)this.initOnClause(table));
        sql.append(") WHEN MATCHED THEN UPDATE SET ").append((CharSequence)this.initUpdateClause(fields));
        sql.append(" WHEN NOT MATCHED THEN INSERT (").append((CharSequence)insertFields).append(") VALUES (").append((CharSequence)valuesClause).append(");");
        return sql.toString();
    }

    private StringBuilder initOnClause(Table table) {
        StringBuilder onClause = new StringBuilder();
        List primaryKeys = table.getPrimaryKeys();
        for (int i = 0; i < primaryKeys.size(); ++i) {
            if (i > 0) {
                onClause.append(" AND ");
            }
            Column primaryKey = (Column)primaryKeys.get(i);
            onClause.append(this.getSrcToTarBinding(primaryKey));
        }
        return onClause;
    }

    private StringBuilder initUpdateClause(List<Column> fields) {
        StringBuilder updateClause = new StringBuilder();
        for (Column field : fields) {
            if (field.isPrimaryKey()) continue;
            if (updateClause.length() > 0) {
                updateClause.append(',');
            }
            updateClause.append(this.getSrcToTarBinding(field));
        }
        return updateClause;
    }

    private void initSelectClause(List<Column> fields, StringBuilder selectClause, StringBuilder insertFields, StringBuilder valuesClause) {
        boolean first = true;
        for (Column field : fields) {
            if (first) {
                first = false;
            } else {
                selectClause.append(',');
                insertFields.append(',');
                valuesClause.append(',');
            }
            selectClause.append("? AS ").append(field.getBinding());
            insertFields.append(field.getBinding());
            valuesClause.append("s.").append(field.getBinding());
        }
    }

    private String getSrcToTarBinding(Column c) {
        return "t." + c.getBinding() + "=s." + c.getBinding();
    }

    static {
        try {
            setSocketTimeoutMethod = SQLServerDataSource.class.getMethod("setSocketTimeout", Integer.TYPE);
        }
        catch (Throwable e) {
            setSocketTimeoutMethod = null;
        }
    }
}

