/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc.newpgsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.newpgsql.PgConnectionWrapper;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.PostgreSqlDbType;
import kd.isc.iscb.util.dt.D;
import org.postgresql.ds.PGSimpleDataSource;

public class NewPgSqlConnectionFactory
extends AbstractConnectionFactory {
    @Override
    protected JdbcConnectionWrapper contructConnectionWrapper(Connection cn, DynamicObject cfg) {
        return new PgConnectionWrapper(cn, this, cfg);
    }

    @Override
    protected DataSource createDataSource(String url, String user, String password, DynamicObject cfg) throws SQLException {
        PGSimpleDataSource ods = new PGSimpleDataSource();
        ods.setUrl(url);
        ods.setUser(user);
        ods.setPassword(password);
        ods.setLoginTimeout(30);
        ods.setConnectTimeout(this.getConnectTimeout(cfg));
        ods.setSocketTimeout(this.getSocketTimeOut(cfg));
        return ods;
    }

    @Override
    protected String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        String database = cfg.getString("sql_database");
        String url = "jdbc:postgresql://" + server + ":" + port + "/" + database;
        String charset = D.s((Object)cfg.getString("charset"));
        if (charset != null) {
            url = url + "?characterEncoding=" + charset;
        }
        return url;
    }

    @Override
    public char getQuot() {
        return '\"';
    }

    @Override
    protected String getCacheKey(String url, String user, String password, DynamicObject cfg) {
        return url + ";" + user + ";" + password + ";" + cfg.get("attr1") + ";" + cfg.get("attr2");
    }

    private int getSocketTimeOut(DynamicObject cfg) {
        String readTimeout = D.s((Object)cfg.get("attr1"));
        if (readTimeout != null) {
            return D.i((Object)readTimeout);
        }
        return 900;
    }

    private int getConnectTimeout(DynamicObject cfg) {
        String connectTimeout = D.s((Object)cfg.get("attr2"));
        if (connectTimeout != null) {
            return D.i((Object)connectTimeout);
        }
        return 360;
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case VIEW: {
                return true;
            }
            case TABLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getTestSQL() {
        return "select 1";
    }

    @Override
    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT * FROM (" + sql + ")X LIMIT " + topN + " OFFSET 0";
        }
        throw new IllegalArgumentException(sql);
    }

    @Override
    public String getUpsertSql(Table table, List<Column> fields) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(table.getQuotedName());
        sql.append('(');
        StringBuilder values = new StringBuilder();
        StringBuilder updateClause = new StringBuilder();
        this.appendEachField(fields, sql, values, updateClause);
        sql.append(")VALUES(").append((CharSequence)values).append(')');
        sql.append(" ON CONFLICT (");
        sql.append(this.getPrimaryString(table.getPrimaryKeys()));
        sql.append(") DO UPDATE SET ");
        sql.append((CharSequence)updateClause);
        return sql.toString();
    }

    private void appendEachField(List<Column> fields, StringBuilder sql, StringBuilder values, StringBuilder updateClause) {
        boolean first = true;
        for (Column field : fields) {
            boolean needUpdate;
            boolean bl = needUpdate = !field.isPrimaryKey();
            if (first) {
                first = false;
            } else {
                sql.append(',');
                values.append(',');
                if (needUpdate && updateClause.length() > 0) {
                    updateClause.append(',');
                }
            }
            sql.append(field.getBinding());
            values.append('?');
            if (!needUpdate) continue;
            this.appendUpdateClause(updateClause, field);
        }
    }

    private void appendUpdateClause(StringBuilder updateClause, Column c) {
        updateClause.append(c.getBinding());
        updateClause.append("=EXCLUDED.");
        updateClause.append(c.getBinding());
    }

    private String getPrimaryString(List<Column> primaryKeys) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Column primaryKey : primaryKeys) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(primaryKey.getBinding());
        }
        return sb.toString();
    }

    @Override
    public DbType getDatabaseType() {
        return new PostgreSqlDbType();
    }
}

