/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc.newpgsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.newpgsql.PgConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.newpgsql.PgStatement;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;

class PgUtil {
    private static final Log logger = LogFactory.getLog(PgUtil.class);

    PgUtil() {
    }

    public static ObjectReader<DataRow> executeQuery(PgConnectionWrapper wrapper, String sql, List<Object> values, List<Integer> types, int fetchSize) {
        Pair<ResultSet, Statement> pair = PgUtil.executeQuery2(wrapper, sql, values, types, fetchSize);
        return DbUtil.asObjectReader((ResultSet)((ResultSet)pair.getA()), (Statement)((Statement)pair.getB()));
    }

    public static Pair<ResultSet, Statement> executeQuery2(PgConnectionWrapper wrapper, String sql, List<Object> values, List<Integer> types, int fetchSize) {
        Connection cn = PgUtil.acquireConnectionWithTransaction(wrapper);
        PreparedStatement smt = null;
        ResultSet rs = null;
        try {
            smt = PgUtil.newPreparedStatement(sql, cn);
            PgUtil.setStatementParam(values, types, fetchSize, smt);
            rs = smt.executeQuery();
            return new Pair((Object)rs, (Object)new PgStatement(cn, smt));
        }
        catch (Throwable e) {
            DbUtil.close((Statement)smt, rs);
            PgUtil.resetAutoCommitAndClose(cn);
            throw DatabaseError.SQL_QUERY_FAILURE.wrap(e);
        }
    }

    private static void setStatementParam(List<Object> values, List<Integer> types, int fetchSize, PreparedStatement smt) throws SQLException {
        PgUtil.setFetchSize(smt, fetchSize);
        DbUtil.setParameters((PreparedStatement)smt, values, types);
    }

    private static PreparedStatement newPreparedStatement(String sql, Connection newConnection) {
        try {
            return newConnection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw DatabaseError.PREPARED_STATEMENT_FAILURE.create((Throwable)e, new String[]{sql});
        }
    }

    private static void setFetchSize(PreparedStatement smt, int fetchSize) throws SQLException {
        if (fetchSize > 0) {
            smt.setFetchSize(fetchSize);
        }
    }

    public static void closePgStatementAndConnection(Statement smt, Connection cn) {
        DbUtil.close((Statement)smt);
        PgUtil.resetAutoCommitAndClose(cn);
    }

    public static void resetAutoCommitAndClose(Connection cn) {
        PgUtil.resetAutoCommit(cn);
        DbUtil.close((Connection)cn);
    }

    public static void resetAutoCommit(Connection cn) {
        try {
            if (cn != null) {
                cn.setAutoCommit(true);
            }
        }
        catch (Throwable t) {
            logger.error("reset autocommit in pg connection error:", t);
        }
    }

    private static Connection acquireConnectionWithTransaction(PgConnectionWrapper wrapper) {
        JdbcConnectionWrapper newConnection = wrapper.getJdbcConnectionFactory().create(wrapper.getConfig());
        try {
            newConnection.setAutoCommit(false);
            return newConnection;
        }
        catch (Exception e) {
            DbUtil.close((Connection)newConnection);
            throw e;
        }
    }
}

