/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc.postgresql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.postgresql.PostgreUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;
import org.postgresql.ds.PGSimpleDataSource;

public class PostgreObjectReader
implements ObjectReader<Map<String, Object>> {
    private String entity;
    private int totalCount;
    private Map<String, Object> requires;
    private Schema table;
    private String filter;
    private String orderBy;
    private ObjectReader<DataRow> reader;
    private Connection impl;
    private List<Map<String, Object>> qFilters;

    PostgreObjectReader(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> qFilters, List<Map<String, String>> orderBys) {
        this.entity = entity;
        this.table = cn.getTable(entity);
        this.qFilters = qFilters;
        this.requires = requires;
        this.impl = this.getConnection(cn.getConfig());
        this.totalCount = this.count(entity, qFilters, orderBys);
    }

    private Connection getConnection(DynamicObject cfg) {
        String user = cfg.getString("user");
        String password = cfg.getString("password");
        int port = cfg.getInt("server_port");
        String server = cfg.getString("server_ip");
        String database = cfg.getString("sql_database");
        String url = "jdbc:postgresql://" + server + ":" + port + "/" + database;
        PGSimpleDataSource ods = new PGSimpleDataSource();
        ods.setUrl(url);
        ods.setUser(user);
        ods.setLoginTimeout(30);
        ods.setPassword(password);
        Connection connection = null;
        try {
            connection = ods.getConnection();
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!", (String)"PostgreObjectReader_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
        return connection;
    }

    private int count(String entity, List<Map<String, Object>> filterList, List<Map<String, String>> sortList) {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        String select = "count(*)";
        this.filter = PostgreUtil.createFilter(this.table, types, values, filterList);
        this.orderBy = PostgreUtil.createOrderBy(this.table, sortList);
        String sql = this.getSqlStr(select, this.filter, entity);
        long totalCount = DbUtil.executeCount((Connection)this.impl, (String)sql, values, types);
        if (totalCount > Integer.MAX_VALUE) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u884c\u6570\u592a\u591a\uff08%s\uff09\uff0c\u4e0d\u652f\u6301\u6570\u636e\u96c6\u6210\uff01", (String)"PostgreObjectReader_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), totalCount));
        }
        if (totalCount > 0L) {
            return (int)totalCount;
        }
        return 0;
    }

    private String getSqlStr(String select, String filter, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(select);
        sb.append(" from ").append(tableName);
        if (filter.length() > 0) {
            sb.append(" where ");
            sb.append(filter);
        }
        return sb.toString();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public Map<String, Object> read() {
        if (this.reader == null) {
            this.getReader();
        }
        return (Map)this.reader.read();
    }

    private void getReader() {
        String sql = this.getReadSql();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        PostgreUtil.createFilter(this.table, types, values, this.qFilters);
        this.reader = DbUtil.executeQuery((Connection)this.impl, (String)sql, values, types, (int)100);
    }

    private String getReadSql() {
        StringJoiner joiner = new StringJoiner(",");
        for (String field : this.requires.keySet()) {
            joiner.add(this.table.getField(field).getBinding());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(joiner);
        sb.append(" FROM ");
        sb.append(this.entity);
        if (!StringUtil.isEmpty((String)this.filter)) {
            sb.append(" where ");
            sb.append(this.filter);
        }
        if (!StringUtil.isEmpty((String)this.orderBy)) {
            sb.append(" ORDER BY ").append(this.orderBy);
        }
        return sb.toString();
    }

    public void close() {
        DbUtil.close(this.reader);
        DbUtil.close((Connection)this.impl);
    }
}

