/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.jdbc.postgresql;

import com.alibaba.fastjson.JSON;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.postgresql.PostgreObjectReader;
import kd.isc.iscb.platform.core.sf.runtime.n.DataRetrieverApplication;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class PostgreUtil {
    private static final String FIELD_FILTER_COMPARE = "filter_compare";
    private static final String PARAM_ACTION = "$action";

    public static PostgreObjectReader get(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        return new PostgreObjectReader(cn, entity, requires, filter, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleOneKey(ConnectionWrapper cn, Table tar_table, String key_field, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update, List<Map<String, Object>> batch) {
        Column key_column = tar_table.getField(key_field);
        Map<Object, Map<String, Object>> id_mapping = PostgreUtil.constructKeyMapping(key_field, key_column, batch);
        try (ObjectReader<DataRow> reader = PostgreUtil.queryExistsKeys(cn, id_mapping, tar_table, key_column);){
            DataRow item = (DataRow)reader.read();
            while (item != null) {
                Map<String, Object> data = id_mapping.remove(item.getValue(0));
                if (data != null) {
                    for_update.add(data);
                }
                item = (DataRow)reader.read();
            }
            for_insert.addAll(id_mapping.values());
        }
    }

    private static Map<Object, Map<String, Object>> constructKeyMapping(String key_field, Column key_column, List<Map<String, Object>> batch) {
        HashMap<Object, Map<String, Object>> id_mapping = new HashMap<Object, Map<String, Object>>(batch.size());
        for (Map<String, Object> data : batch) {
            Object value = data.get(key_field);
            Map<String, Object> dup = id_mapping.put(key_column.narrow(value), data);
            if (dup == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b57\u6bb5\uff08%s\uff09\u5bf9\u76ee\u6807\u6570\u636e\u8fdb\u884c\u552f\u4e00\u6027\u68c0\u67e5\uff0c\u53d1\u73b0\u5176\u4e2d\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u4e2d\u9009\u62e9\u7684\u5019\u9009\u952e\u5b57\u6bb5\u3002", (String)"PostgreUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key_field));
        }
        return id_mapping;
    }

    private static ObjectReader<DataRow> queryExistsKeys(ConnectionWrapper cn, Map<Object, Map<String, Object>> id_mapping, Table tar_table, Column key_column) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>(id_mapping.keySet());
        String sql = PostgreUtil.generateJudgeSQL(tar_table, key_column, id_mapping, types);
        return cn.executeQuery(sql, values, types);
    }

    private static String generateJudgeSQL(Table tar_table, Column key_column, Map<Object, Map<String, Object>> id_mapping, List<Integer> types) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(key_column.getBinding());
        sb.append(" from ");
        sb.append(tar_table.getQuotedName());
        sb.append(" where ");
        sb.append(key_column.getBinding());
        sb.append(" in ( ");
        for (int i = 0; i < id_mapping.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            types.add(key_column.getSqlType());
            sb.append(" ? ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static void handleMultiKey(ConnectionWrapper connectionWrapper, Table table, List<String> judgeFieldList, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update, List<Map<String, Object>> batch) {
        List<Column> fields = PostgreUtil.getJudgeFields(table, judgeFieldList);
        JdbcConnectionWrapper cn = (JdbcConnectionWrapper)connectionWrapper;
        PostgreUtil.classify(cn, table, batch, fields, for_insert, for_update);
    }

    public static void classify(Connection cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Integer> types = new ArrayList<Integer>(judgeFields.size());
        sb.append("select 1");
        sb.append(" from ");
        sb.append(table.getQuotedName());
        sb.append(" where ");
        for (int i = 0; i < judgeFields.size(); ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            types.add(judgeFields.get(i).getSqlType());
            sb.append(judgeFields.get(i).getBinding()).append(" =? ");
        }
        String sql = sb.toString();
        for (Map<String, Object> data : rows) {
            ArrayList<Object> values = new ArrayList<Object>(judgeFields.size());
            for (Column f : judgeFields) {
                Object outerValue = data.get(f.getName());
                values.add(f.narrow(outerValue));
            }
            Object result = DbUtil.executeScalar((Connection)cn, (String)sql, values, types);
            if (result == null) {
                for_insert.add(data);
                continue;
            }
            for_update.add(data);
        }
    }

    private static List<Column> getJudgeFields(Table table, List<String> judgeFieldList) {
        ArrayList<Column> fields = new ArrayList<Column>();
        for (String name : judgeFieldList) {
            Column field = table.getField(name);
            if (field != null) {
                fields.add(field);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5\uff08%1$s\uff09\u5728\u5b9e\u4f53\uff08%2$s\uff09\u4e2d\u4e0d\u5b58\u5728\uff01", (String)"PostgreUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, table));
        }
        return fields;
    }

    public static List<Response> doBatchAction(ConnectionWrapper cn, Table table, String action, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update, String entityName, List<String> judgeFieldList) {
        ArrayList<Response> responseList = new ArrayList<Response>();
        TableAction tableAction = TableAction.valueOf((String)action);
        switch (tableAction) {
            case _SAVE: {
                PostgreUtil.batchInsert(cn, table, for_insert, responseList, entityName, judgeFieldList);
                PostgreUtil.batchUpdate(cn, table, for_update, responseList, entityName, judgeFieldList);
                break;
            }
            case _INSERT: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b%1$s\u4e0d\u652f\u6301\uff0c\u4ec5\u652f\u6301%2$s", (String)"PostgreUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), TableAction._INSERT, TableAction._SAVE));
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a%s", (String)"PostgreUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tableAction));
            }
        }
        return responseList;
    }

    private static void batchInsert(ConnectionWrapper cn, Table tar_table, List<Map<String, Object>> for_insert, List<Response> responseList, String entityName, List<String> judgeFieldList) {
        if (for_insert.size() == 0) {
            return;
        }
        String sql = TableUtil.prepareInsertSQL((Table)tar_table);
        ArrayList<Column> params = new ArrayList<Column>(tar_table.getFieldCount());
        ArrayList<Integer> types = new ArrayList<Integer>(tar_table.getFieldCount());
        for (int i = 0; i < tar_table.getFieldCount(); ++i) {
            Column f = tar_table.getField(i);
            params.add(f);
            types.add(f.getSqlType());
        }
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>(for_insert.size());
        for (Map<String, Object> data : for_insert) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            for (Column f : params) {
                Object value = TableUtil.getValue(data, (Column)f);
                row.add(value);
            }
            batch.add(row);
        }
        cn.executeBatch(sql, batch, types);
        for (Map<String, Object> data : for_insert) {
            data.put(PARAM_ACTION, SaveDataType.INSERT);
            responseList.add(new Response(null, SaveDataType.INSERT, null));
        }
    }

    private static void batchUpdate(ConnectionWrapper cn, Table tar_table, List<Map<String, Object>> for_update, List<Response> responseList, String entityName, List<String> judgeFieldList) {
        if (for_update.size() == 0) {
            return;
        }
        Set columns = for_update.stream().findFirst().map(Map::keySet).orElseGet(HashSet::new);
        columns.remove(PARAM_ACTION);
        columns.removeAll(judgeFieldList);
        PostgreUtil.removePrimaryKeys(columns, tar_table);
        if (columns.size() == 0) {
            for (Map<String, Object> data : for_update) {
                data.put(PARAM_ACTION, SaveDataType.NOP);
            }
            return;
        }
        List<Column> judgeFields = PostgreUtil.getJudgeFields(tar_table, judgeFieldList);
        Column judgeField = tar_table.findField(judgeFieldList.get(0));
        String[] fields = columns.toArray(new String[0]);
        String sql = PostgreUtil.prepareUpdateSQL(judgeFields, judgeField, fields, tar_table);
        ArrayList<Column> params = new ArrayList<Column>(fields.length + judgeFields.size());
        for (String string : fields) {
            Column f = tar_table.getField(string);
            params.add(f);
        }
        if (judgeField != null) {
            params.add(judgeField);
        } else {
            params.addAll(judgeFields);
        }
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>(for_update.size());
        for (Map<String, Object> data : for_update) {
            ArrayList<Object> arrayList = new ArrayList<Object>(params.size());
            for (Column f : params) {
                Object value = TableUtil.getValue(data, (Column)f);
                arrayList.add(value);
            }
            batch.add(arrayList);
        }
        ArrayList<Integer> types = new ArrayList<Integer>(params.size());
        for (Column column : params) {
            types.add(column.getSqlType());
        }
        cn.executeBatch(sql, batch, types);
        for (Map map : for_update) {
            map.put(PARAM_ACTION, SaveDataType.UPDATE);
            responseList.add(new Response(null, SaveDataType.UPDATE, null));
        }
    }

    private static String prepareUpdateSQL(List<Column> judgeFields, Column judgeField, String[] fields, Table tar_table) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tar_table.getQuotedName()).append(" SET ");
        for (i = 0; i < fields.length; ++i) {
            String name = fields[i];
            Column c = tar_table.getField(name);
            if (c == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\uff08%1$s\uff09\u4e0d\u5b58\u5728\u5b57\u6bb5\uff08%2$s\uff09\u3002", (String)"PostgreUtil_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tar_table, name));
            }
            if (i > 0) {
                sql.append(',');
            }
            sql.append(c.getBinding()).append("=?");
        }
        sql.append(" WHERE ");
        if (judgeField != null) {
            sql.append(judgeField.getBinding()).append("=?");
        } else {
            for (i = 0; i < judgeFields.size(); ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(judgeFields.get(i).getBinding()).append("=?");
            }
        }
        return sql.toString();
    }

    private static void removePrimaryKeys(Set<String> columns, Table table) {
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Column c = table.getField(i);
            if (!c.isPrimaryKey()) continue;
            columns.remove(c.getName());
        }
    }

    static String createFilter(Schema table, List<Integer> types, List<Object> values, List<Map<String, Object>> filterList) {
        if (filterList == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        for (int i = 0; i < filterList.size(); ++i) {
            Map<String, Object> obj = filterList.get(i);
            Object filterLeftBracket = obj.get("filter_left_bracket");
            filter.append(filterLeftBracket == null ? "" : filterLeftBracket);
            Object value = obj.get("filter_value");
            if (DataRetrieverApplication.isIgnoredFilterItem(value)) {
                filter.append(" 1=1 ");
            } else {
                PostgreUtil.appendCondition(table, types, values, filter, obj, value);
            }
            Object filterRightBracket = obj.get("filter_right_bracket");
            filter.append(filterRightBracket == null ? "" : filterRightBracket);
            if (i >= filterList.size() - 1) continue;
            filter.append("OR".equals(obj.get("filter_link")) ? " OR " : " AND ");
        }
        return filter.toString().trim();
    }

    private static void appendCondition(Schema table, List<Integer> types, List<Object> values, StringBuilder filter, Map<String, Object> obj, Object value) {
        Column field = DataRetrieverApplication.getFilterField(table, D.s((Object)obj.get("filter_column")));
        filter.append(field.getBinding());
        if (value instanceof List) {
            DataRetrieverApplication.handleListTypeParam(filter, values, field, (List)value, types, D.s((Object)obj.get(FIELD_FILTER_COMPARE)));
        } else if (DataRetrieverApplication.isArray(value)) {
            List list = (List)JSON.parseObject((String)value.toString(), List.class);
            DataRetrieverApplication.handleListTypeParam(filter, values, field, list, types, D.s((Object)obj.get(FIELD_FILTER_COMPARE)));
        } else {
            DataRetrieverApplication.handleBaseTypeParam(filter, values, D.s((Object)obj.get(FIELD_FILTER_COMPARE)), field, value, types);
        }
    }

    static String createOrderBy(Schema table, List<Map<String, String>> sortList) {
        if (sortList == null) {
            return "";
        }
        StringBuilder sort = new StringBuilder();
        for (int i = 0; i < sortList.size(); ++i) {
            if (i > 0) {
                sort.append(", ");
            }
            Map<String, String> map = sortList.get(i);
            String sort_field = D.s((Object)map.get("sort_field"));
            Column field = table.getField(sort_field);
            sort.append(field.getBinding());
            sort.append(' ');
            String filter_mode = D.s((Object)map.get("sort_mode"));
            sort.append(filter_mode);
        }
        return sort.toString();
    }
}

