/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyConnectFactory;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudMLStringSetter;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.trace.TraceManager;

public class K3ApiCookieCache {
    private static final Log log = LogFactory.getLog(K3ApiCookieCache.class);
    private static final Map<Pair<String, Long>, Pair<Object, Long>> cookies = new ReadLockFreeMap();

    public static Object get(DynamicObject cfg, Script loginScript) {
        Long connectionId;
        String accountId = RequestContext.get().getAccountId();
        Pair key = new Pair((Object)accountId, (Object)(connectionId = Long.valueOf(D.l((Object)cfg.get("id")))));
        Pair<Object, Long> cookie = cookies.get(key);
        if (!K3ApiCookieCache.isValid(cookie)) {
            cookie = K3ApiCookieCache.doLogin(cfg, (Pair<String, Long>)key, loginScript);
        }
        return cookie.getKey();
    }

    private static synchronized Pair<Object, Long> doLogin(DynamicObject cfg, Pair<String, Long> key, Script loginScript) {
        Pair<Object, Long> cookie = cookies.get(key);
        if (K3ApiCookieCache.isValid(cookie)) {
            return cookie;
        }
        return K3ApiCookieCache.createCookie(cfg, key, loginScript);
    }

    private static Pair<Object, Long> createCookie(DynamicObject cfg, Pair<String, Long> key, Script loginScript) {
        Object sessionId = K3ApiCookieCache.eval(cfg, loginScript);
        Pair cookie = new Pair(sessionId, (Object)System.currentTimeMillis());
        cookies.put(key, (Pair<Object, Long>)cookie);
        K3ApiCookieCache.refresherCookie(key, sessionId);
        return cookie;
    }

    static Object eval(DynamicObject cfg, Script script) {
        Map<String, Object> ctx = K3ApiCookieCache.createContext(cfg, null);
        return script.eval(ctx);
    }

    private static boolean isValid(Pair<Object, Long> cookie) {
        if (cookie == null) {
            return false;
        }
        Long loginTime = (Long)cookie.getValue();
        return System.currentTimeMillis() < loginTime + 960000L;
    }

    private static void refresherCookie(Pair<String, Long> key, Object sessionId) {
        refresherCookie task = new refresherCookie(key, sessionId);
        ScheduleManager.submit((Task)task, 900);
    }

    public static Map<String, Object> createContext(DynamicObject cfg, Object session) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(9);
        ctx.put("$protocal", cfg.get("http_protocal"));
        ctx.put("$ip", cfg.get("server_ip"));
        ctx.put("$port", cfg.get("server_port"));
        ctx.put("$user", cfg.get("user"));
        ctx.put("$password", cfg.get("password"));
        ctx.put("$lang", K3CloudMLStringSetter.getMLkay(cfg.get("icid")));
        ctx.put("$data_center", cfg.get("data_center"));
        ctx.put("$session", session);
        ctx.put("$web_app", cfg.get("web_app"));
        return ctx;
    }

    private static final class refresherCookie
    implements LightTask {
        private Pair<String, Long> key;
        private Object sessionId;

        private refresherCookie(Pair<String, Long> key, Object sessionId) {
            this.key = key;
            this.sessionId = sessionId;
        }

        @Override
        public void run() {
            try {
                TraceManager.disableTrace();
                Pair<Object, Long> cookieValue = this.getCookieValue(this.key, this.sessionId);
                cookies.put(this.key, cookieValue);
                ScheduleManager.submit((Task)this, 900);
            }
            catch (Exception e) {
                log.warn("\u5237\u65b0\u4f1a\u8bdd(" + this.key.getValue() + ")\u5931\u8d25\uff01", (Throwable)e);
            }
        }

        private Pair<Object, Long> getCookieValue(Pair<String, Long> key, Object sessionId) {
            ConnectionWrapper cn = ConnectionManager.getConnection((Long)key.getB());
            K3CloudProxyConnectFactory factory = (K3CloudProxyConnectFactory)cn.getFactory();
            Map<String, Object> ctx = K3ApiCookieCache.createContext(cn.getConfig(), sessionId);
            Object session = factory.getRefreshScript().eval(ctx);
            return new Pair(session, (Object)System.currentTimeMillis());
        }

        @Override
        public String getId() {
            return null;
        }
    }
}

