/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.attachment;

import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.attachment.K3CloudAttachmentUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.AbstractInputStream;

public class K3CloudAttachmentInputStream
extends AbstractInputStream {
    private K3CloudProxyContext ctx;
    private String attachmentId;
    private byte[] data;
    private boolean last;
    private int startIndex;
    private int pos;
    private int length;
    private Map<String, Object> result;

    public K3CloudAttachmentInputStream() {
    }

    public K3CloudAttachmentInputStream(K3CloudProxyContext ctx, Map<String, Object> fileInfo) {
        this.ctx = ctx;
        this.attachmentId = D.s((Object)fileInfo.get("srcAttachId"));
        this.startIndex = 0;
        this.loadAttachmentChunk();
    }

    public void markError() {
    }

    public int read() throws IOException {
        return this.readByte();
    }

    private int readByte() throws IOException {
        if (this.data != null) {
            return this.innerReadByte();
        }
        if (this.last) {
            return -1;
        }
        this.loadAttachmentChunk();
        return this.readByte();
    }

    public int innerReadByte() throws IOException {
        if (this.pos < this.length) {
            return this.data[this.pos++] & 0xFF;
        }
        this.data = null;
        return this.readByte();
    }

    private void loadAttachmentChunk() {
        this.result = K3CloudAttachmentUtil.retrieveAttachment(this.ctx, this.attachmentId, this.startIndex);
        this.initParams();
    }

    public void initParams() {
        this.last = D.x((Object)this.result.get("IsLast"));
        this.startIndex = D.i((Object)this.result.get("StartIndex"));
        String dataStr = D.s((Object)this.result.get("FilePart"));
        if (dataStr != null) {
            this.data = Base64.getDecoder().decode(dataStr);
            this.length = this.data.length;
        }
        this.pos = 0;
    }
}

