/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.cookie;

import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieReader;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.Pair;

public class CookieCache {
    private static final Log log = LogFactory.getLog(CookieCache.class);
    private static final LocalMemoryCache cookies;

    public static void remove(DynamicObject cfg) {
        cookies.remove(new String[]{CookieCache.getCookiesKey(cfg)});
    }

    public static CookieSetter get(DynamicObject cfg) {
        String key = CookieCache.getCookiesKey(cfg);
        Pair<String, Long> cookie = (Pair<String, Long>)cookies.get(key);
        if (!CookieCache.isValid(cookie)) {
            cookie = CookieCache.doLogin(cfg, key);
        }
        return new CookieSetter((String)cookie.getKey());
    }

    public static void connectCloud(K3CloudProxyContext ctx) {
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser.common.kdsvc";
        Object param = K3CloudUtil.getParas(ctx.getConfig());
        CookieReader reader = new CookieReader();
        Object login = NetUtil.httpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(param), (String)"UTF-8", (NetUtil.ConnectionDecorator)reader);
        if (login instanceof Map) {
            Map loginResult = (Map)login;
            int loginResultType = D.i(loginResult.get("LoginResultType"));
            if (loginResultType != 1) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7aWEBAPI\u767b\u5f55\u63a5\u53e3\u5931\u8d25\uff0c\u767b\u5f55\u5730\u5740\uff1a%1$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"CookieCache_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), url, login));
            }
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7aWEBAPI\u767b\u5f55\u63a5\u53e3\u5931\u8d25\uff0c\u767b\u5f55\u5730\u5740\uff1a%1$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"CookieCache_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), url, login));
        }
        String cookieVal = reader.getCookieVal();
        cookies.put(CookieCache.getCookiesKey(ctx.getConfig()), (Object)new Pair((Object)cookieVal, (Object)System.currentTimeMillis()));
    }

    private static String getCookiesKey(DynamicObject cfg) {
        String accountId = RequestContext.get().getAccountId();
        Object connectionId = cfg.get("id");
        return accountId + "@" + connectionId;
    }

    private static Pair<String, Long> doLogin(DynamicObject cfg, String key) {
        Pair cookie = (Pair)cookies.get(key);
        if (CookieCache.isValid((Pair<String, Long>)cookie)) {
            return cookie;
        }
        return CookieCache.createCookie(cfg, key);
    }

    private static Pair<String, Long> createCookie(DynamicObject cfg, String key) {
        CookieCache.connectCloud(new K3CloudProxyContext(cfg));
        CookieCache.refresherCookie(key, cfg);
        return (Pair)cookies.get(CookieCache.getCookiesKey(cfg));
    }

    private static boolean isValid(Pair<String, Long> cookie) {
        if (cookie == null) {
            return false;
        }
        Long loginTime = (Long)cookie.getValue();
        return System.currentTimeMillis() < loginTime + 960000L;
    }

    private static void refresherCookie(String key, DynamicObject cfg) {
        refresherCookie task = new refresherCookie(key, cfg);
        ScheduleManager.submit((Task)task, 900);
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(600000);
        info.setMaxMemSize(512);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cookies = commonCacheFactory.$getOrCreateLocalMemoryCache("ISC_XK_COOKIES", "bd", info);
    }

    private static final class refresherCookie
    implements LightTask {
        private String key;
        private DynamicObject cfg;

        private refresherCookie(String key, DynamicObject cfg) {
            this.key = key;
            this.cfg = cfg;
        }

        @Override
        public void run() {
            try {
                CookieCache.connectCloud(new K3CloudProxyContext(this.cfg));
                ScheduleManager.submit((Task)this, 900);
            }
            catch (Exception e) {
                log.warn("\u5237\u65b0\u4f1a\u8bdd(" + this.key + ")\u5931\u8d25\uff01", (Throwable)e);
            }
        }

        @Override
        public String getId() {
            return null;
        }
    }
}

