/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.EnumInfo;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class EntityInfo {
    private static Log log = LogFactory.getLog(EntityInfo.class);
    private static final String DATA_TYPE_DECIMAL = "decimal";
    private static final String DATA_TYPE_DATETIME = "datetime";
    private static final String DATA_TYPE_STRING = "string";
    private static final String FIELD_VALUE = "Value";
    private static final String TYPE_HEAD_ENTITY = "HeadEntity";
    private static final String TYPE_SUB_ENTRY_ENTITY = "SubEntryEntity";
    private static final String TYPE_ENTRY_ENTITY = "EntryEntity";
    private static final String PARAM_ENTITY_TYPE = "EntityType";
    private static final String FIELD_ENTRYS = "Entrys";
    private static final String OP_TYPE_UPDATE = "update";
    private static final String OP_TYPE_SAVE = "save";
    private static final String OP_TYPE_INSERT = "insert";
    private static final Map<String, String> operationTypeMap = new HashMap<String, String>(19);

    public static List<Map<String, Object>> getEntityInfo(K3CloudProxyContext ctx, String fullName) {
        String entityName = null;
        String entryName = null;
        int i = fullName.indexOf(46);
        if (i < 0) {
            entityName = fullName;
        } else {
            entityName = fullName.substring(0, i);
            entryName = fullName.substring(i + 1);
        }
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("FormId", entityName);
        List params = Collections.singletonList(param);
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.QueryBusinessInfo.common.kdsvc";
        Map result = (Map)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        List<Map<String, Object>> entity = null;
        entity = null == entryName ? EntityInfo.getEntityInfoList(result) : EntityInfo.getEntryList(result, entryName);
        return entity;
    }

    public static List<Map<String, Object>> getEntryList(Map<String, Object> result, String entryName) {
        result = (Map)result.get("Result");
        Map needReturnData = (Map)result.get("NeedReturnData");
        ArrayList<Map<String, Object>> entryInfoList = new ArrayList<Map<String, Object>>(12);
        if (null == needReturnData) {
            return entryInfoList;
        }
        List<Map<String, Object>> ationsAndEvents = EntityInfo.getActionsAndEvents(needReturnData);
        List entrys = (List)needReturnData.get(FIELD_ENTRYS);
        for (Map entry : entrys) {
            if (!entryName.equals(entry.get("Key"))) continue;
            EntityInfo.getSingleEntry(entryInfoList, needReturnData, ationsAndEvents, entry);
        }
        return entryInfoList;
    }

    private static void getSingleEntry(List<Map<String, Object>> entryInfoList, Map<String, Object> needReturnData, List<Map<String, Object>> ationsAndEvents, Map<String, Object> entry) {
        Object fullName = EntityInfo.getFullName(needReturnData, entry);
        Object tableName = EntityInfo.getTableName(entry);
        Object title = EntityInfo.getTitle(needReturnData, entry);
        HashMap<String, Object> entryInfo = new HashMap<String, Object>(8);
        entryInfo.put("title", title);
        EntityInfo.setBaseInfo(entryInfo, fullName, tableName);
        entryInfo.put("properties", EntityInfo.getProperties(needReturnData, entry, false));
        entryInfo.put("actions", ationsAndEvents);
        entryInfoList.add(entryInfo);
        EntityInfo.getEnum(entryInfoList, needReturnData, entry);
    }

    public static List<Map<String, Object>> getEntityInfoList(Map<String, Object> result) {
        result = (Map)result.get("Result");
        ArrayList<Map<String, Object>> entityInfoList = new ArrayList<Map<String, Object>>(12);
        Map needReturnData = (Map)result.get("NeedReturnData");
        if (null == needReturnData) {
            return entityInfoList;
        }
        List<Map<String, Object>> ationsAndEvents = EntityInfo.getActionsAndEvents(needReturnData);
        List entrys = (List)needReturnData.get(FIELD_ENTRYS);
        if (entrys.size() < 1) {
            EntityInfo.entityAndEntryIsEmpty(entityInfoList, needReturnData, ationsAndEvents);
        } else {
            EntityInfo.entityAndEntryIsNotEmpty(entityInfoList, needReturnData, ationsAndEvents, entrys);
        }
        return entityInfoList;
    }

    private static void entityAndEntryIsNotEmpty(List<Map<String, Object>> entityInfoList, Map<String, Object> needReturnData, List<Map<String, Object>> ationsAndEvents, List<Map<String, Object>> entrys) {
        int size = entrys.size();
        ArrayList<String> entryTypes = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> entry = entrys.get(i);
            String entityType = D.s((Object)entry.get(PARAM_ENTITY_TYPE));
            entryTypes.add(entityType);
            if (i == 0 && entityType != null && entityType.equalsIgnoreCase(TYPE_HEAD_ENTITY)) {
                EntityInfo.getEntity(entityInfoList, needReturnData, ationsAndEvents, entry);
            } else {
                EntityInfo.getEntry(entityInfoList, needReturnData, ationsAndEvents, entry);
            }
            EntityInfo.getEnum(entityInfoList, needReturnData, entry);
        }
        if (!entryTypes.contains(TYPE_HEAD_ENTITY)) {
            EntityInfo.entityAndEntryIsEmpty(entityInfoList, needReturnData, ationsAndEvents);
        }
    }

    private static void getEnum(List<Map<String, Object>> entityInfoList, Map<String, Object> needReturnData, Map<String, Object> entry) {
        List fields = (List)entry.get("Fields");
        for (Map field : fields) {
            Object extend = field.get("Extends");
            if (ObjectUtils.isEmpty(extend)) continue;
            if (extend instanceof List) {
                HashMap<String, Object> enumInfo = new HashMap<String, Object>(6);
                List name = (List)field.get("Name");
                Object title = ((Map)name.get(0)).get(FIELD_VALUE);
                String enumName = needReturnData.get("Id") + "." + entry.get("Key") + "." + field.get("Key");
                enumInfo.put("full_name", enumName);
                enumInfo.put("name", Hash.mur32((Object[])new Object[]{enumName}));
                enumInfo.put("type", "ENUM");
                enumInfo.put("title", title);
                enumInfo.put("table_name", null);
                enumInfo.put("consts", EnumInfo.getEnumConstsByEnumId((List)extend));
                entityInfoList.add(enumInfo);
                continue;
            }
            String fromId = D.s((Object)needReturnData.get("Id"));
            String fieldName = D.s(field.get("FieldName"));
            String elementType = D.s(field.get("ElementType"));
            log.info("\u5143\u6570\u636e\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff1a\u5355\u636e:{}\uff0c\u5c5e\u6027\u5217\uff1a{}\uff0cElementType\uff1a{}\uff0c\u672a\u77e5\u7c7b\u578b\u5c5e\u6027\u6682\u4e0d\u89e3\u6790\u3002", new Object[]{fromId, fieldName, elementType});
        }
    }

    private static void getEntry(List<Map<String, Object>> entityInfoList, Map<String, Object> needReturnData, List<Map<String, Object>> ationsAndEvents, Map<String, Object> entry) {
        HashMap<String, Object> entryInfo = new HashMap<String, Object>(8);
        entityInfoList.add(entryInfo);
        Object fullName = EntityInfo.getFullName(needReturnData, entry);
        Object tableName = EntityInfo.getTableName(entry);
        Object title = EntityInfo.getTitle(needReturnData, entry);
        List<Map<String, Object>> properties = EntityInfo.getProperties(needReturnData, entry, false);
        EntityInfo.setBaseInfo(entryInfo, fullName, tableName);
        entryInfo.put("properties", properties);
        entryInfo.put("actions", ationsAndEvents);
        entryInfo.put("title", title);
    }

    private static void getEntity(List<Map<String, Object>> entityInfoList, Map<String, Object> needReturnData, List<Map<String, Object>> ationsAndEvents, Map<String, Object> entry) {
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfoList.add(entityInfo);
        Object fullName = EntityInfo.getFullName(needReturnData, entry);
        Object tableName = EntityInfo.getTableName(entry);
        Object title = EntityInfo.getTitle(needReturnData, entry);
        List<Map<String, Object>> properties = EntityInfo.getProperties(needReturnData, entry, true);
        EntityInfo.setBaseInfo(entityInfo, fullName, tableName);
        entityInfo.put("properties", properties);
        entityInfo.put("actions", ationsAndEvents);
        entityInfo.put("title", title);
    }

    private static void setBaseInfo(Map<String, Object> entityInfo, Object fullName, Object tableName) {
        entityInfo.put("full_name", fullName);
        if (fullName != null && D.s((Object)fullName).indexOf(46) < 1) {
            entityInfo.put("name", fullName);
        } else {
            entityInfo.put("name", Hash.mur32((Object[])new Object[]{fullName}));
        }
        entityInfo.put("table_name", tableName);
        entityInfo.put("type", "ENTITY");
    }

    private static void entityAndEntryIsEmpty(List<Map<String, Object>> entityInfoList, Map<String, Object> needReturnData, List<Map<String, Object>> ationsAndEvents) {
        HashMap<String, Object> entityInfo = new HashMap<String, Object>(8);
        entityInfoList.add(entityInfo);
        Object title = EntityInfo.getTitle(needReturnData, null);
        Object fullName = EntityInfo.getFullName(needReturnData, null);
        Object tableName = EntityInfo.getTableName(null);
        EntityInfo.setBaseInfo(entityInfo, fullName, tableName);
        entityInfo.put("title", title);
        entityInfo.put("properties", null);
        entityInfo.put("actions", ationsAndEvents);
    }

    private static List<Map<String, Object>> getProperties(Map<String, Object> needReturnData, Map<String, Object> entry, boolean isSyncEntity) {
        List fields = (List)entry.get("Fields");
        Object mainEntityName = needReturnData.get("Id");
        Object MasterId = needReturnData.get("MasterPKFieldName");
        Object seqFieldKey = entry.get("SeqFieldKey");
        Object entrysId = entry.get("Key");
        ArrayList<Map<String, Object>> propertiesList = new ArrayList<Map<String, Object>>(0);
        int index = 0;
        String pkFieldType = D.s((Object)needReturnData.get("PkFieldType"));
        String type = null;
        if (pkFieldType != null) {
            if (pkFieldType.contains("System.Int64")) {
                type = "long";
            } else if (pkFieldType.contains("System.Int32")) {
                type = "integer";
            } else if (pkFieldType.contains("System.String")) {
                type = DATA_TYPE_STRING;
            }
        }
        if (null != entry.get("EntryPkFieldName")) {
            propertiesList.add(EntityInfo.getCustomField(entry.get("EntryPkFieldName"), true, false, "Id", index++, type));
        }
        if (null != MasterId && isSyncEntity) {
            propertiesList.add(EntityInfo.getCustomField(MasterId, false, true, "msterID", index++, type));
        }
        if (null != seqFieldKey) {
            propertiesList.add(EntityInfo.getCustomField(seqFieldKey, false, true, "Seq", index++, "integer"));
        }
        for (Map field : fields) {
            Object fieldName = EntityInfo.getProperLabel(field);
            int fieldType = D.i(field.get("FieldType"));
            int elementType = D.i(field.get("ElementType"));
            String data_type = EntityInfo.getDataType(elementType, fieldType);
            if (data_type.equalsIgnoreCase("ENUM")) {
                propertiesList.add(EntityInfo.fieldIsEnum(mainEntityName, entrysId, field, index++));
                continue;
            }
            propertiesList.add(EntityInfo.fieldIsOther(index++, field, fieldName, elementType, data_type));
        }
        if (isSyncEntity) {
            EntityInfo.fieldIsEntry(propertiesList, needReturnData);
        } else {
            EntityInfo.addChildrenEntry(propertiesList, needReturnData, entry);
        }
        return propertiesList;
    }

    private static Map<String, Object> getCustomField(Object name, boolean isPK, boolean isNull, String remark, int index, String type) {
        HashMap<String, Object> pkField = new HashMap<String, Object>(8);
        pkField.put("name", name);
        pkField.put("label", name);
        pkField.put("data_type", type != null ? type : "long");
        pkField.put("data_schema", null);
        pkField.put("is_primary_key", isPK);
        pkField.put("is_nullable", isNull);
        pkField.put("index", index);
        pkField.put("remark", remark);
        return pkField;
    }

    private static void fieldIsEntry(List<Map<String, Object>> propertiesList, Map<String, Object> needReturnData) {
        List entrys = (List)needReturnData.get(FIELD_ENTRYS);
        int index = propertiesList.size();
        for (Map en : entrys) {
            if (en == null || EntityInfo.isEntity(en) || TYPE_SUB_ENTRY_ENTITY.equals(D.s(en.get(PARAM_ENTITY_TYPE)))) continue;
            Object fullName = EntityInfo.getFullName(needReturnData, en);
            Object title = EntityInfo.getTitle(needReturnData, en);
            HashMap<String, Object> entryFieldMap = new HashMap<String, Object>(9);
            entryFieldMap.put("name", en.get("Key"));
            entryFieldMap.put("label", title);
            entryFieldMap.put("is_primary_key", Boolean.FALSE);
            entryFieldMap.put("is_nullable", Boolean.FALSE);
            entryFieldMap.put("index", index++);
            entryFieldMap.put("data_type", EntityInfo.getEntityType(en));
            entryFieldMap.put("data_schema", Hash.mur32((Object[])new Object[]{fullName}));
            entryFieldMap.put("remark", en.get("EntryName"));
            entryFieldMap.put("title", title);
            propertiesList.add(entryFieldMap);
        }
    }

    private static void addChildrenEntry(List<Map<String, Object>> propertiesList, Map<String, Object> needReturnData, Map<String, Object> entry) {
        List entrys = (List)needReturnData.get(FIELD_ENTRYS);
        int index = propertiesList.size();
        for (Map en : entrys) {
            if (en == null || D.s(en.get("ParentKey")) == null || !D.s(en.get("ParentKey")).equals(entry.get("Key"))) continue;
            Object fullName = EntityInfo.getFullName(needReturnData, en);
            Object title = EntityInfo.getTitle(needReturnData, en);
            HashMap<String, Object> entryFieldMap = new HashMap<String, Object>(9);
            entryFieldMap.put("name", en.get("Key"));
            entryFieldMap.put("label", title);
            entryFieldMap.put("is_primary_key", Boolean.FALSE);
            entryFieldMap.put("is_nullable", Boolean.FALSE);
            entryFieldMap.put("index", index++);
            entryFieldMap.put("data_type", EntityInfo.getEntityType(en));
            entryFieldMap.put("data_schema", Hash.mur32((Object[])new Object[]{fullName}));
            entryFieldMap.put("remark", en.get("EntryName"));
            entryFieldMap.put("title", title);
            propertiesList.add(entryFieldMap);
        }
    }

    private static Object getEntityType(Map<String, Object> en) {
        Object entityType = en.get(PARAM_ENTITY_TYPE);
        if (entityType.equals(TYPE_ENTRY_ENTITY) || entityType.equals(TYPE_SUB_ENTRY_ENTITY)) {
            return "ENTRIES";
        }
        return entityType;
    }

    private static Map<String, Object> fieldIsOther(int index, Map<String, Object> field, Object fieldName, int elementType, String data_type) {
        HashMap<String, Object> item = new HashMap<String, Object>(8);
        String lookUpObjectFormId = D.s((Object)field.get("LookUpObjectFormId"));
        String groupFieldTableName = D.s((Object)field.get("GroupFieldTableName"));
        item.put("name", field.get("Key"));
        if (data_type.equalsIgnoreCase("MultiREF")) {
            String controlFieldKey = D.s((Object)field.get("ControlFieldKey"));
            item.put("data_type", data_type + '?' + controlFieldKey);
        } else {
            item.put("data_type", data_type);
        }
        item.put("label", fieldName);
        if (elementType == 33) {
            item.put("data_schema", groupFieldTableName);
        } else {
            item.put("data_schema", lookUpObjectFormId);
        }
        item.put("is_primary_key", Boolean.FALSE);
        item.put("is_nullable", EntityInfo.getProperIsNull(field));
        item.put("index", index);
        item.put("remark", field.get("PropertyName"));
        return item;
    }

    private static Map<String, Object> fieldIsEnum(Object mainEntityName, Object entrysId, Map<String, Object> field, int index) {
        List name = (List)field.get("Name");
        String value = (String)((Map)name.get(0)).get(FIELD_VALUE);
        HashMap<String, Object> enumField = new HashMap<String, Object>(6);
        Object enumObjectId = field.get("EnumObjectId");
        if (null != field.get("Extends")) {
            String dataSchema = Hash.mur32((Object[])new Object[]{mainEntityName + "." + entrysId + "." + field.get("Key")});
            EntityInfo.setEnumField(enumField, field, dataSchema, value, index);
        } else if (null != enumObjectId) {
            String dataSchema = Hash.mur32((Object[])new Object[]{enumObjectId});
            EntityInfo.setEnumField(enumField, field, dataSchema, value, index);
        } else {
            EntityInfo.setEnumField(enumField, field, ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"EntityInfo_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value, index);
        }
        return enumField;
    }

    private static void setEnumField(Map<String, Object> enumField, Map<String, Object> field, Object dataSchema, String value, int index) {
        enumField.put("data_type", "ENUM");
        enumField.put("data_schema", dataSchema);
        enumField.put("consts", null);
        enumField.put("is_nullable", EntityInfo.getProperIsNull(field));
        enumField.put("label", value);
        enumField.put("index", index);
        enumField.put("name", field.get("Key"));
        enumField.put("remark", field.get("PropertyName"));
    }

    private static boolean getProperIsNull(Map<String, Object> field) {
        boolean is_nullable = false;
        if (field.get("MustInput").equals(0)) {
            is_nullable = true;
        }
        return is_nullable;
    }

    private static Object getProperLabel(Map<String, Object> field) {
        List name = (List)field.get("Name");
        return ((Map)name.get(0)).get(FIELD_VALUE);
    }

    private static Object getFullName(Map<String, Object> needReturnData, Map<String, Object> entryMap) {
        if (entryMap == null || EntityInfo.isEntity(entryMap)) {
            return needReturnData.get("Id");
        }
        return needReturnData.get("Id") + "." + entryMap.get("Key");
    }

    private static Object getTableName(Map<String, Object> entry) {
        if (entry == null || entry.isEmpty()) {
            return ResManager.loadKDString((String)"\u8868\u5934\u65e0\u6570\u636e\uff0c\u4e0d\u53ef\u4f7f\u7528", (String)"EntityInfo_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return entry.get("TableName");
    }

    private static Object getTitle(Map<String, Object> needReturnData, Map<String, Object> entry) {
        List resultName = (List)needReturnData.get("Name");
        Object entityName = ((Map)resultName.get(0)).get(FIELD_VALUE);
        if (entry == null || EntityInfo.isEntity(entry)) {
            return entityName;
        }
        if (TYPE_SUB_ENTRY_ENTITY.equals(D.s((Object)entry.get(PARAM_ENTITY_TYPE)))) {
            List entrys = (List)needReturnData.get(FIELD_ENTRYS);
            for (Map map : entrys) {
                if (D.s((Object)entry.get("ParentKey")) == null || !D.s((Object)entry.get("ParentKey")).equals(map.get("Key"))) continue;
                List parentEntrysName = (List)map.get("Name");
                Object name = ((Map)parentEntrysName.get(0)).get(FIELD_VALUE);
                entityName = entityName + "." + name;
                break;
            }
        }
        List entrysName = (List)entry.get("Name");
        Object entryName = ((Map)entrysName.get(0)).get(FIELD_VALUE);
        return entityName + "." + entryName;
    }

    private static boolean isEntity(Map<String, Object> entryMap) {
        boolean b = false;
        String entityType = D.s((Object)entryMap.get(PARAM_ENTITY_TYPE));
        if (StringUtil.isEmpty((String)entityType)) {
            b = false;
        } else if (entityType.equalsIgnoreCase(TYPE_HEAD_ENTITY)) {
            b = true;
        }
        return b;
    }

    private static List<Map<String, Object>> getActionsAndEvents(Map<String, Object> needReturnData) {
        List opreations = (List)needReturnData.get("Operations");
        if (opreations.size() < 1) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> actionsList = new ArrayList<Map<String, Object>>(0);
        int index = 0;
        for (Map operetion : opreations) {
            HashMap<String, Object> actionsmap = new HashMap<String, Object>(0);
            String name = D.s(operetion.get("OperationNumber"));
            if (!operationTypeMap.containsKey(name)) continue;
            List operationName = (List)operetion.get("OperationName");
            Map operationNameOne = (Map)operationName.get(0);
            String label = D.s(operationNameOne.get(FIELD_VALUE));
            actionsmap.put("index", index++);
            actionsmap.put("name", name);
            actionsmap.put("label", label);
            actionsmap.put("type", operationTypeMap.get(name));
            actionsList.add(actionsmap);
        }
        return actionsList;
    }

    public static String getDataType(int elementType, int fieldType) {
        switch (elementType) {
            case 1: {
                return DATA_TYPE_STRING;
            }
            case 2: {
                return DATA_TYPE_DECIMAL;
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "date";
            }
            case 5: {
                return DATA_TYPE_DATETIME;
            }
            case 6: {
                return DATA_TYPE_STRING;
            }
            case 7: {
                return "REF";
            }
            case 8: {
                return "boolean";
            }
            case 9: {
                return "ENUM";
            }
            case 12: {
                return DATA_TYPE_STRING;
            }
            case 13: {
                return "REF";
            }
            case 14: {
                return "variant";
            }
            case 16: {
                return "MultiREF";
            }
            case 17: {
                return "REF";
            }
            case 18: {
                return "REF";
            }
            case 19: {
                return "REF";
            }
            case 20: {
                return DATA_TYPE_DECIMAL;
            }
            case 21: {
                return DATA_TYPE_DECIMAL;
            }
            case 22: {
                return DATA_TYPE_DECIMAL;
            }
            case 26: {
                return DATA_TYPE_DATETIME;
            }
            case 27: {
                return "REF";
            }
            case 28: {
                return DATA_TYPE_DATETIME;
            }
            case 36: {
                return "ml_string_k3c";
            }
            case 40: {
                return "ENUM";
            }
            case 44: {
                return "BILLTYPE";
            }
            case 46: {
                return "UNIT";
            }
            case 47: {
                return DATA_TYPE_DECIMAL;
            }
            case 51: {
                return DATA_TYPE_STRING;
            }
            case 56: {
                return "REF";
            }
            case 32: {
                return "RADIOGROUP";
            }
            case 25: {
                return "RADIO";
            }
            case 2011: {
                return "ENUM";
            }
        }
        switch (fieldType) {
            case 61: {
                return DATA_TYPE_DATETIME;
            }
        }
        return "unknown(" + elementType + "," + fieldType + ")";
    }

    static {
        operationTypeMap.put("Delete", "delete");
        operationTypeMap.put("Draft", OP_TYPE_INSERT);
        operationTypeMap.put("Save", OP_TYPE_SAVE);
        operationTypeMap.put("Submit", OP_TYPE_SAVE);
        operationTypeMap.put("Audit", OP_TYPE_UPDATE);
        operationTypeMap.put("UnAudit", OP_TYPE_UPDATE);
        operationTypeMap.put("Forbid", OP_TYPE_UPDATE);
        operationTypeMap.put("Enable", OP_TYPE_UPDATE);
        operationTypeMap.put("CancelAssign", OP_TYPE_UPDATE);
        operationTypeMap.put("Allocate", OP_TYPE_UPDATE);
        operationTypeMap.put("ValidateUser", OP_TYPE_UPDATE);
        operationTypeMap.put("BatchSave", OP_TYPE_INSERT);
        operationTypeMap.put("SSBatchEdit", OP_TYPE_UPDATE);
        operationTypeMap.put("SSExportData", OP_TYPE_UPDATE);
        operationTypeMap.put("SSImportData", OP_TYPE_INSERT);
        operationTypeMap.put("ConfirmFinish", OP_TYPE_UPDATE);
        operationTypeMap.put("CancelFinish", OP_TYPE_UPDATE);
        operationTypeMap.put("Cancel", OP_TYPE_UPDATE);
        operationTypeMap.put("Push", OP_TYPE_UPDATE);
    }
}

