/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class EnumInfo {
    public static Map<String, Object> getEnumInfo(K3CloudProxyContext ctx, String name) {
        String[] split = name.split("\\.");
        Map<String, Object> enumInfo = null;
        if (split.length == 2) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u53ef\u80fd\u662f\u975e\u6cd5\u7684\u661f\u7a7a\u4f01\u4e1a\u7248\u679a\u4e3e\u7c7b\u96c6\u6210\u5bf9\u8c61\u5168\u540d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EnumInfo_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
        }
        enumInfo = split.length < 2 ? EnumInfo.getEnumByEnumId(ctx, name) : EnumInfo.getEnumByEntityId(ctx, split[0], split[1], split[2]);
        return enumInfo;
    }

    private static Map<String, Object> getEnumByEnumId(K3CloudProxyContext ctx, Object enumId) {
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        String fiedValue = "fid, fname, fvalue, FCaption";
        String filterValue = "fid = '" + enumId + "'";
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("FormId", "BOS_EnumBill");
        param.put("FieldKeys", fiedValue);
        param.put("FilterString", filterValue);
        List params = Collections.singletonList(param);
        List result = (List)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        try {
            return EnumInfo.getEnum(result);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u661f\u7a7a\u4f01\u4e1a\u7248\u679a\u4e3e\u7c7b\u5143\u6570\u636e\u51fa\u9519,\u53c2\u6570\u4e3a\u3010%1$s\u3011,\u539f\u59cb\u8fd4\u56de\u7ed3\u679c\u4e3a\u3010%2$s\u3011\u3002\u9519\u8bef\uff1a%3$s", (String)"EnumInfo_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Json.toString(param), result, StringUtil.getCascadeMessage((Throwable)e)));
        }
    }

    public static Map<String, Object> getEnum(List<List<Object>> result) {
        HashMap<String, Object> enumMap = new HashMap<String, Object>(result.size());
        if (result.size() < 1) {
            throw new IscBizException("EnumList is null");
        }
        List<Object> enumlis = result.get(0);
        enumMap.put("full_name", enumlis.get(0));
        enumMap.put("name", enumlis.get(0));
        enumMap.put("type", "ENUM");
        enumMap.put("title", enumlis.get(1));
        enumMap.put("table_name", null);
        enumMap.put("consts", EnumInfo.getEnumConsts(result));
        return enumMap;
    }

    private static List<Map<String, Object>> getEnumConsts(List<List<Object>> result) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(result.size());
        int indexx = 1;
        for (List<Object> lis : result) {
            if (lis.size() < 1) {
                throw new IscBizException("Enum is null");
            }
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("index", indexx++);
            map.put("name", lis.get(2));
            map.put("label", lis.get(3));
            mapList.add(map);
        }
        return mapList;
    }

    private static Map<String, Object> getEnumByEntityId(K3CloudProxyContext ctx, String entityId, String entyrsId, String enumId) {
        String url = ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.QueryBusinessInfo.common.kdsvc";
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("FormId", entityId);
        List params = Collections.singletonList(param);
        Map result = (Map)NetUtil.asyncHttpInvoke((String)url, (Object)K3CloudUtil.getRequestParams(params), (NetUtil.ConnectionDecorator)CookieCache.get(ctx.getConfig()));
        return EnumInfo.getEnumByEnumId(result, entityId, entyrsId, enumId, ctx);
    }

    public static Map<String, Object> getEnumByEnumId(Map<String, Object> result, String entityId, String entyrsId, String enumId, K3CloudProxyContext ctx) {
        result = (Map)result.get("Result");
        HashMap<String, Object> enumMap = null;
        Map returnData = (Map)result.get("NeedReturnData");
        List entrys = (List)returnData.get("Entrys");
        block0: for (Map entry : entrys) {
            Object entryKey = entry.get("Key");
            if (!entyrsId.equals(entryKey)) continue;
            List fields = (List)entry.get("Fields");
            for (Map field : fields) {
                Object fieldKey = field.get("Key");
                if (!enumId.equals(fieldKey)) continue;
                enumMap = new HashMap<String, Object>(6);
                List name = (List)field.get("Name");
                Object title = ((Map)name.get(0)).get("Value");
                Object anExtends = field.get("Extends");
                Object enumObjectId = field.get("EnumObjectId");
                int count = 0;
                if (!ObjectUtils.isEmpty(anExtends)) {
                    ++count;
                    List extens = (List)anExtends;
                    String full_name = entityId + "." + entyrsId + "." + fieldKey;
                    enumMap.put("full_name", full_name);
                    enumMap.put("name", Hash.mur32((Object[])new Object[]{full_name}));
                    enumMap.put("type", "ENUM");
                    enumMap.put("title", title);
                    enumMap.put("table_name", null);
                    enumMap.put("consts", EnumInfo.getEnumConstsByEnumId(extens));
                } else if (!ObjectUtils.isEmpty(enumObjectId)) {
                    ++count;
                    return EnumInfo.getEnumByEnumId(ctx, enumObjectId);
                }
                if (count != 1) continue;
                continue block0;
            }
        }
        return enumMap;
    }

    public static List<Map<String, Object>> getEnumConstsByEnumId(List<Map<String, Object>> extens) {
        ArrayList<Map<String, Object>> enumConst = new ArrayList<Map<String, Object>>(extens.size());
        int indexx = 1;
        for (Map<String, Object> enten : extens) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("index", indexx++);
            map.put("name", enten.get("Value"));
            map.put("label", enten.get("Caption"));
            enumConst.add(map);
        }
        return enumConst;
    }
}

