/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloud.setter;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyContext;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudBaseSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudBooleanSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudDateSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudDateTimeSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudDecimalSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudDoubleSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudEntriesSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudEnumSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudF7Setter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudFloatSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudIntegerSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudLongSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudMLStringSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudMultiREFSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudStringSetter;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudSubHeadEntitySetter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class K3CloudDataTypeParser {
    private static final Set<String> f7TypeSet = new HashSet<String>(4);

    public static K3CloudSetter getSetter(K3CloudProxyContext ctx, Map<String, Object> data, Map<Object, List<Object>> dataTypeMap, Map<String, List<String>> judgeFields, String cloudDataKey, Boolean isInsert) {
        String type = null;
        try {
            type = D.s((Object)dataTypeMap.get(cloudDataKey).get(0));
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u661f\u7a7a\u7cfb\u7edf\u96c6\u6210\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\u5b57\u6bb5\uff1a%s,\u8bf7\u786e\u8ba4\u96c6\u6210\u5bf9\u8c61\u6570\u636e\u6216\u4e1a\u52a1\u7684\u6b63\u786e\u6027:", (String)"K3CloudDataTypeParser_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cloudDataKey), (Throwable)e);
        }
        if (null == type) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff1a%1$s \u4e3a\uff1a%2$s", (String)"K3CloudDataTypeParser_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cloudDataKey, type));
        }
        if (type.startsWith("MultiREF")) {
            return new K3CloudMultiREFSetter(ctx, data, dataTypeMap);
        }
        if (f7TypeSet.contains(type)) {
            return new K3CloudF7Setter(ctx, dataTypeMap);
        }
        if (type.equalsIgnoreCase("ENTRIES")) {
            return new K3CloudEntriesSetter(ctx, dataTypeMap, judgeFields, isInsert);
        }
        if (type.equalsIgnoreCase("SubHeadEntity")) {
            return new K3CloudSubHeadEntitySetter(ctx, dataTypeMap, judgeFields, isInsert);
        }
        if (type.equalsIgnoreCase("ENUM")) {
            return new K3CloudEnumSetter();
        }
        if (type.equalsIgnoreCase("string")) {
            return new K3CloudStringSetter();
        }
        if (type.equalsIgnoreCase("ml_string_k3c")) {
            return new K3CloudMLStringSetter();
        }
        if (type.equalsIgnoreCase("integer")) {
            return new K3CloudIntegerSetter();
        }
        if (type.equalsIgnoreCase("boolean")) {
            return new K3CloudBooleanSetter();
        }
        if (type.equalsIgnoreCase("float")) {
            return new K3CloudFloatSetter();
        }
        if (type.equalsIgnoreCase("double")) {
            return new K3CloudDoubleSetter();
        }
        if (type.equalsIgnoreCase("datetime")) {
            return new K3CloudDateTimeSetter();
        }
        if (type.equalsIgnoreCase("decimal")) {
            return new K3CloudDecimalSetter();
        }
        if (type.equalsIgnoreCase("long")) {
            return new K3CloudLongSetter();
        }
        if (type.equalsIgnoreCase("date")) {
            return new K3CloudDateSetter();
        }
        return new K3CloudBaseSetter(ctx, dataTypeMap);
    }

    static {
        f7TypeSet.add("REF");
        f7TypeSet.add("BILLTYPE");
        f7TypeSet.add("UNIT");
        f7TypeSet.add("LOT");
    }
}

