/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ldap.functions.LdapUtil;
import kd.isc.iscb.util.except.IscBizException;

public class LdapConnectionWrapper
extends ConnectionWrapper {
    public LdapConnectionWrapper(ConnectionFactory factory, DynamicObject cfg) {
        super(factory, cfg);
    }

    private DirContext initContext() {
        DynamicObject cfg = this.getConfig();
        String url = "ldap://" + cfg.getString("server_ip") + ":" + cfg.getString("server_port");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", cfg.getString("user"));
        env.put("java.naming.security.credentials", cfg.getString("newpwd"));
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            return ctx;
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    public void test() {
        try {
            DirContext ctx = this.initContext();
            ctx.close();
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> search(String dn, String filter, int searchScope) throws NamingException {
        try (DirContext ctx = this.initContext();){
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(searchScope);
            filter = LdapUtil.encodeFilter(filter);
            NamingEnumeration<SearchResult> enumeration = ctx.search(dn, filter, searchControls);
            ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(500);
            while (enumeration.hasMore()) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                SearchResult searchResult = enumeration.next();
                Attributes attributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> allAttributes = attributes.getAll();
                while (allAttributes.hasMore()) {
                    Attribute attr = allAttributes.next();
                    map.put(attr.getID(), attr.get());
                    map.put("name", searchResult.getName());
                    map.put("fullName", searchResult.getNameInNamespace());
                }
                res.add(map);
            }
            ArrayList<Map<String, Object>> arrayList = res;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> list(String dn) throws NamingException {
        try (DirContext ctx = this.initContext();){
            NamingEnumeration<NameClassPair> list = ctx.list(dn);
            ArrayList<String> res = new ArrayList<String>(32);
            while (list.hasMore()) {
                res.add(list.next().getName());
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> lookup(String dn) throws NamingException {
        try (DirContext ctx = this.initContext();){
            DirContext dirContext = (DirContext)ctx.lookup(dn);
            Attributes attributes = dirContext.getAttributes("");
            NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            while (attrEnum.hasMore()) {
                Attribute attr = attrEnum.next();
                map.put(attr.getID(), attr.get());
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
    }
}

