/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.olap;

import java.util.LinkedList;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapConnectionStringBuilder;
import kd.isc.iscb.platform.core.connector.olap.OlapConnectionProxy;
import kd.isc.iscb.platform.core.connector.olap.OlapConstant;
import kd.isc.iscb.platform.core.connector.olap.OlapContext;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.misc.Pair;

public class OlapConnectionPool
implements OlapConstant {
    private String cubeName;
    private DynamicObject cfg;
    private LinkedList<Pair<OlapConnection, Long>> notUsedConnections;

    public OlapConnectionPool(DynamicObject cfg, String cubeName) {
        this.cubeName = cubeName;
        this.cfg = cfg;
        this.notUsedConnections = new LinkedList();
    }

    public OlapConnectionProxy getConnection() {
        OlapConnection cn;
        Pair<OlapConnection, Long> pair;
        while ((pair = this.getPooledConnection()) != null) {
            cn = (OlapConnection)pair.getA();
            if (!this.connectionValid(cn)) continue;
            return new OlapConnectionProxy(cn, this);
        }
        cn = this.openConnection();
        return new OlapConnectionProxy(cn, this);
    }

    private boolean connectionValid(OlapConnection cn) {
        boolean valid;
        block2: {
            valid = true;
            try {
                this.testConnection(cn);
            }
            catch (Exception e) {
                valid = false;
                if (cn.isClosed()) break block2;
                cn.close();
            }
        }
        return valid;
    }

    private void testConnection(OlapConnection cn) {
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("path", "");
        propertyBag.set("children", "false");
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getMetadataNames", propertyBag);
        OlapCommand cmd = new OlapCommand(cn, (CommandInfo)functionCommandInfo);
        cmd.executeFunction();
    }

    private OlapConnection openConnection() {
        OlapContext olapContext = new OlapContext(this.cfg);
        String remoteURL = olapContext.getRemoteURL();
        OlapConnectionStringBuilder cnStr = new OlapConnectionStringBuilder();
        cnStr.setProvider(olapContext.getProvider());
        cnStr.setDataSource(remoteURL);
        if (this.cubeName != null) {
            cnStr.setInitialCatalog(this.cubeName);
        }
        OlapConnection cn = new OlapConnection(cnStr.toString());
        cn.setUserName(olapContext.getUser());
        cn.setPassword(olapContext.getPwd());
        cn.Open();
        return cn;
    }

    private synchronized Pair<OlapConnection, Long> getPooledConnection() {
        if (this.notUsedConnections.isEmpty()) {
            return null;
        }
        return this.notUsedConnections.removeFirst();
    }

    public Task getCloseCnTask() {
        return new CloseTimeoutCnTask();
    }

    public synchronized void recycle(OlapConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u56de\u6536\u7684\u8fde\u63a5\u4e3a\u7a7a", (String)"OlapConnectionPool_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        Pair pair = new Pair((Object)connection, (Object)System.currentTimeMillis());
        this.notUsedConnections.addLast((Pair<OlapConnection, Long>)pair);
    }

    public class CloseTimeoutCnTask
    implements Task {
        private String id = UUID.randomUUID().toString();

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void run() {
            try {
                OlapConnection cn;
                while ((cn = this.takeTimeoutConnection()) != null) {
                    if (cn.isClosed()) continue;
                    cn.close();
                }
            }
            finally {
                ScheduleManager.submit((Task)this, 30);
            }
        }

        private synchronized OlapConnection takeTimeoutConnection() {
            if (OlapConnectionPool.this.notUsedConnections.isEmpty()) {
                return null;
            }
            Pair p = (Pair)OlapConnectionPool.this.notUsedConnections.getFirst();
            if (System.currentTimeMillis() - (Long)p.getValue() > 60000L) {
                return (OlapConnection)((Pair)OlapConnectionPool.this.notUsedConnections.removeFirst()).getKey();
            }
            return null;
        }
    }
}

