/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.self.Attachment;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class AttachmentField
implements Attachment {
    private static final String ENTITY_BOS_ATTACHMENT = "bos_attachment";
    private String entity;
    private String field;

    public AttachmentField(String entity, String field) {
        this.entity = entity;
        this.field = field;
    }

    @Override
    public String getName() {
        return "FIELD";
    }

    @Override
    public void bind(DynamicObject bill, List<Object> attachIdList) {
        DynamicObjectCollection original = bill.getDynamicObjectCollection(this.field);
        HashMap<String, Object> collection = new HashMap<String, Object>(original.size());
        for (DynamicObject o : original) {
            DynamicObject bd = o.getDynamicObject("fbasedataid");
            if (bd == null) continue;
            collection.put(o.getString("fbasedataid_id"), bd.get("uid"));
        }
        for (Object pk : attachIdList) {
            if (CommonUtil.isEmpty(pk)) {
                throw new IscBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u9644\u4ef6ID\u4e3anull", (String)"AttachmentField_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            if (!QueryServiceHelper.exists((String)"bd_attachment", (Object)pk)) {
                if (QueryServiceHelper.exists((String)"isc_attachment_temp", (Object)pk)) {
                    DynamicObject temp = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"isc_attachment_temp");
                    this.saveAttachmentDetail(D.l((Object)pk), temp.getString("name"), temp.getString("type"), temp.getInt("bytes"), temp.getString("url"), temp.getString("desc"), D.t((Object)temp.get("usr_def_create_time")), D.s((Object)temp.get("usr_def_creator")));
                } else if (QueryServiceHelper.exists((String)ENTITY_BOS_ATTACHMENT, (Object)pk)) {
                    DynamicObject bos = BusinessDataServiceHelper.loadSingle((Object)pk, (String)ENTITY_BOS_ATTACHMENT);
                    this.saveAttachmentDetail(D.l((Object)pk), bos.getString("fattachmentname"), bos.getString("fextname"), bos.getInt("fattachmentsize"), bos.getString("ffileid"), bos.getString("fdescription"), D.t((Object)bos.get("fcreatetime")), this.getCreatorId(bos));
                } else {
                    throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u7684\u9644\u4ef6ID:%s", (String)"AttachmentField_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), pk));
                }
            }
            collection.remove(D.s((Object)pk));
        }
        HashMap<String, String> remain = new HashMap<String, String>(collection.size());
        for (Object value : collection.values()) {
            remain.put("uid", D.s(value));
            AttachmentFieldServiceHelper.removeAttachments((String)this.entity, (String)original.getDynamicObjectType().getAlias(), remain);
        }
    }

    private String getCreatorId(DynamicObject bos) {
        DynamicObject fcreatemen = bos.getDynamicObject("fcreatemen");
        if (fcreatemen != null) {
            return D.s((Object)fcreatemen.get("id"));
        }
        return null;
    }

    private void saveAttachmentDetail(long attachId, String fileName, String fileType, long size, String url, String desc, Timestamp userDefinedCreateTime, String userDefinedCreator) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        attachment.set("id", (Object)attachId);
        attachment.set("name", (Object)fileName);
        attachment.set("status", (Object)"B");
        attachment.set("size", (Object)size);
        attachment.set("url", (Object)url);
        attachment.set("type", (Object)fileType);
        attachment.set("uid", (Object)("rc-upload-" + System.currentTimeMillis() + "-" + random.nextInt(100)));
        attachment.set("creator", (Object)(userDefinedCreator != null ? userDefinedCreator : RequestContext.get().getUserId()));
        attachment.set("createtime", (Object)(userDefinedCreateTime != null ? userDefinedCreateTime : D.t((Object)new Date())));
        attachment.set("tempfile", (Object)"1");
        attachment.set("number", (Object)UUID.randomUUID().toString());
        attachment.set("description", (Object)desc);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
    }
}

