/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.self.Attachment;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;

public class AttachmentPanel
implements Attachment {
    private static final String ENTITY_BOS_ATTACHMENT = "bos_attachment";
    private String entity;
    private String key;

    public AttachmentPanel(String entity, String key) {
        if (key == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9644\u4ef6\u7684\u6807\u8bc6key\uff0c\u65e0\u6cd5\u786e\u5b9a\u9644\u4ef6\u5c06\u5173\u8054\u5230\u5355\u636e!", (String)"AttachmentPanel_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.entity = entity;
        this.key = key;
    }

    @Override
    public String getName() {
        return "PANEL";
    }

    @Override
    public void bind(DynamicObject bill, List<Object> attachIdList) {
        String billId = D.s((Object)bill.getPkValue());
        List<Map<String, Object>> original = AttachmentUtil.getAttachmentPanelList(this.entity, billId, this.key);
        Map<String, Object> remain = original.stream().collect(Collectors.toMap(k -> D.s(k.get("srcAttachId")), v -> v.get("number")));
        for (Object id : attachIdList) {
            long pkId = D.l((Object)id);
            if (pkId == 0L) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u9644\u4ef6ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ed9\u9644\u4ef6\u9762\u677f%s\u8d4b\u503c!", (String)"AttachmentPanel_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.key));
            }
            if (QueryServiceHelper.exists((String)ENTITY_BOS_ATTACHMENT, (Object)pkId)) {
                this.updateAttachment(pkId, billId, remain);
            } else if (QueryServiceHelper.exists((String)"isc_attachment_temp", (Object)pkId)) {
                DynamicObject temp = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"isc_attachment_temp");
                this.saveAttachmentDetail(billId, pkId, temp.getString("name"), temp.getString("type"), temp.getInt("bytes"), temp.getString("url"), temp.getString("desc"), D.t((Object)temp.get("usr_def_create_time")), D.s((Object)temp.get("usr_def_creator")));
            } else if (QueryServiceHelper.exists((String)"bd_attachment", (Object)pkId)) {
                DynamicObject bd = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bd_attachment");
                this.saveAttachmentDetail(billId, pkId, bd.getString("name"), bd.getString("type"), bd.getInt("size"), bd.getString("url"), bd.getString("description"), D.t((Object)bd.get("createtime")), this.getCreatorId(bd));
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u7684\u9644\u4ef6ID:%s", (String)"AttachmentPanel_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), pkId));
            }
            remain.remove(D.s((Object)pkId));
        }
        AttachmentUtil.deletePanelAttachments(this.entity, billId, remain);
    }

    private String getCreatorId(DynamicObject bd) {
        DynamicObject creator = bd.getDynamicObject("creator");
        if (creator != null) {
            return D.s((Object)creator.get("id"));
        }
        return null;
    }

    private void saveAttachmentDetail(String billId, long attachId, String fileName, String fileType, long size, String url, String desc, Timestamp userDefinedCreateTime, String userDefinedCreator) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BOS_ATTACHMENT);
        attachment.set("id", (Object)attachId);
        attachment.set("finterid", (Object)billId);
        attachment.set("fbilltype", (Object)this.entity);
        attachment.set("fattachmentpanel", (Object)this.key);
        attachment.set("fattachmentname", (Object)fileName);
        attachment.set("faliasfilename", (Object)fileName);
        attachment.set("fextname", (Object)fileType);
        attachment.set("fattachmentsize", (Object)size);
        attachment.set("ffileid", (Object)url);
        attachment.set("fnumber", (Object)("rc-upload-" + System.currentTimeMillis() + "-" + random.nextInt(100)));
        attachment.set("fcreatemen", (Object)(userDefinedCreator != null ? userDefinedCreator : RequestContext.get().getUserId()));
        attachment.set("fcreatetime", (Object)(userDefinedCreateTime != null ? userDefinedCreateTime : D.t((Object)new Date())));
        attachment.set("fmodifymen", (Object)RequestContext.get().getUserId());
        attachment.set("fmodifytime", (Object)D.t((Object)new Date()));
        attachment.set("fdescription", (Object)desc);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
    }

    private void updateAttachment(long attachId, Object billId, Map<String, Object> collection) {
        DynamicObject attachment = BusinessDataServiceHelper.loadSingle((Object)attachId, (String)ENTITY_BOS_ATTACHMENT);
        if (!(D.s((Object)billId).equals(D.s((Object)attachment.get("finterid"))) && this.entity.equals(attachment.getString("fbilltype")) && this.key.equals(attachment.getString("fattachmentpanel")))) {
            String s = attachId + "," + billId + "," + this.entity + "," + this.key;
            long id = Math.abs(Hash.mur64((byte[])s.getBytes(D.UTF_8)));
            if (!QueryServiceHelper.exists((String)ENTITY_BOS_ATTACHMENT, (Object)id)) {
                String fileName = D.s((Object)attachment.get("fattachmentname"));
                String fileType = D.s((Object)attachment.get("fextname"));
                long size = D.l((Object)attachment.get("fattachmentsize"));
                String url = D.s((Object)attachment.get("ffileid"));
                String desc = D.s((Object)attachment.get("fdescription"));
                DynamicObject fcreatemen = attachment.getDynamicObject("fcreatemen");
                String creatorId = fcreatemen != null ? D.s((Object)fcreatemen.get("id")) : null;
                this.saveAttachmentDetail(D.s((Object)billId), id, fileName, fileType, size, url, desc, D.t((Object)attachment.get("fcreatetime")), creatorId);
            }
            collection.remove(D.s((Object)id));
        }
    }
}

