/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.self.RetrieveData;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;

public class BatchExecutor {
    private BatchExecutor() {
    }

    public static boolean matchesBatchMode(String entity, List<Map<String, Object>> batch, Map<String, List<String>> judgeFields, String pk) {
        if (!D.x((Object)SystemPropertyUtils.getProptyByTenant((String)"ISC_BATCH_QUERY_CLASSIFY", (String)RequestContext.get().getTenantId()))) {
            return false;
        }
        List<String> fields = judgeFields.get("$");
        if (fields == null || fields.size() > 1) {
            return false;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        if (!BatchExecutor.isSimpleField(entityType, fields.get(0))) {
            return false;
        }
        return BatchExecutor.isFormattedBatchData(batch, entityType, pk);
    }

    private static boolean isSimpleField(MainEntityType entityType, String field) {
        DynamicProperty p = entityType.getProperty(field);
        return p instanceof PKFieldProp || p instanceof IntegerProp || p instanceof TextProp;
    }

    private static boolean isFormattedBatchData(List<Map<String, Object>> batch, MainEntityType entityType, String pk) {
        int i = 0;
        int j = 0;
        DynamicProperty pkField = entityType.getProperty(pk);
        boolean isLong = !(pkField instanceof VarcharProp);
        for (Map<String, Object> map : batch) {
            Object o = map.get(pk);
            if (BatchExecutor.isEmpty(o, isLong)) {
                ++i;
            } else {
                ++j;
            }
            if (i < 1 || j < 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(Object value, boolean isLong) {
        return isLong ? D.l((Object)value) == 0L : D.s((Object)value) == null;
    }

    public static void classifyBatchData(String entity, List<Map<String, Object>> batch, Map<String, List<String>> judgeFields, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList) {
        String pk;
        if (batch.size() > 1000) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6279\u91cf\u8bbe\u7f6e\u8fc7\u5927\uff0c\u4e0d\u80fd\u8d85\u8fc71000\uff0c\u8bf7\u8c03\u6574\u76ee\u6807\u5355\u5206\u6279\u5927\u5c0f\u3002", (String)"BatchExecutor_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        LinkedHashMap<String, Map<String, Object>> pkMapData = new LinkedHashMap<String, Map<String, Object>>(batch.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        List<Object> ids = BatchExecutor.collectIds(entityType, batch, pk = entityType.getPrimaryKey().getName(), pkMapData);
        if (!ids.isEmpty()) {
            BatchExecutor.collectUpdateListById(entity, pk, ids, pkMapData, updateList);
        }
        if (pkMapData.isEmpty()) {
            return;
        }
        List<String> fields = judgeFields.get("$");
        if (fields == null || fields.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7684\u5019\u9009\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728!", (String)"BatchExecutor_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        BatchExecutor.collectByJudgeField(insertList, updateList, pkMapData, entityType, pk, fields);
    }

    private static List<Object> collectIds(MainEntityType entityType, List<Map<String, Object>> batch, String pk, Map<String, Map<String, Object>> pkMap) {
        ArrayList<Object> ids = new ArrayList<Object>();
        for (Map<String, Object> data : batch) {
            Object pkValue = null;
            try {
                pkValue = RetrieveData.cast((EntityType)entityType, pk, data.get(pk));
            }
            catch (Exception e) {
                data.put("#warn", String.format(ResManager.loadKDString((String)"id:%s\uff0c\u7c7b\u578b\u975e\u6cd5\uff0c\u5c06\u901a\u8fc7\u5019\u9009\u952e\u627e\u76ee\u6807\u5355ID\u3002", (String)"BatchExecutor_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), data.remove(pk)));
            }
            if (pkValue != null) {
                Map<String, Object> old = pkMap.put(pkValue.toString(), data);
                Assert.isNull(old, (String)String.format(ResManager.loadKDString((String)"\u6279\u6b21\u6570\u636e\u4e3b\u952e\u5b58\u5728\u91cd\u590d\u503c\uff0c\u91cd\u590d\u7684pk\u662f%s", (String)"BatchExecutor_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), pkValue));
                ids.add(pkValue);
                continue;
            }
            pkMap.put(UUID.randomUUID().toString(), data);
        }
        return ids;
    }

    private static void collectUpdateListById(String entity, String pk, List<Object> ids, Map<String, Map<String, Object>> pkMapData, List<Map<String, Object>> updateList) {
        QFilter filter = new QFilter("id", "in", ids);
        List values = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])new QFilter[]{filter}, null, (int)-1);
        for (Object v : values) {
            Map<String, Object> data = pkMapData.remove(v.toString());
            if (data == null) continue;
            data.put(pk, v);
            updateList.add(data);
        }
    }

    private static void collectByJudgeField(List<Map<String, Object>> insertList, List<Map<String, Object>> updateList, Map<String, Map<String, Object>> pkMapData, MainEntityType entityType, String pk, List<String> fields) {
        String field = fields.get(0);
        if (field.equals(pk)) {
            insertList.addAll(pkMapData.values());
            return;
        }
        LinkedHashMap<String, Map<String, Object>> fieldDataMap = new LinkedHashMap<String, Map<String, Object>>(pkMapData.size());
        List<Object> values = BatchExecutor.collectJudgeFieldValueList(pkMapData, entityType, field, fieldDataMap);
        QFilter filter = new QFilter(field, "in", values);
        BatchExecutor.collectUpdateListByJudgeField(updateList, pkMapData, entityType, field, filter, fieldDataMap, pk);
        insertList.addAll(fieldDataMap.values());
    }

    private static List<Object> collectJudgeFieldValueList(Map<String, Map<String, Object>> pkMapData, MainEntityType entityType, String field, Map<String, Map<String, Object>> fieldDataMap) {
        ArrayList<Object> values = new ArrayList<Object>(pkMapData.size());
        for (Map<String, Object> data : pkMapData.values()) {
            Object o = data.get(field);
            if (o == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5\u672a\u8d4b\u503c\uff1a[%1$s], \u6570\u636e\uff1a%2$s", (String)"BatchExecutor_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field, Json.toString(data)));
            }
            Object value = RetrieveData.cast((EntityType)entityType, field, o);
            Map<String, Object> old = fieldDataMap.put(value.toString(), data);
            if (old != null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5019\u9009\u952e%1$s\u5728\u76ee\u6807\u6570\u636e\u4e2d\u53d1\u73b0\u91cd\u590d\u503c\uff0c\u91cd\u590d\u7684\u6570\u636e\u5206\u522b\u662f\uff1a%2$s\u548c%3$s", (String)"BatchExecutor_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field, Json.toString(old), Json.toString(data)));
            }
            values.add(value);
        }
        return values;
    }

    private static void collectUpdateListByJudgeField(List<Map<String, Object>> updateList, Map<String, Map<String, Object>> pkMapData, MainEntityType entityType, String field, QFilter filter, Map<String, Map<String, Object>> fieldDataMap, String pk) {
        DynamicObject[] dataList = BusinessDataServiceHelper.load((String)entityType.getName(), (String)(pk + "," + field), (QFilter[])new QFilter[]{filter}, null, (int)(pkMapData.size() + 1));
        HashSet<String> set = new HashSet<String>(dataList.length);
        for (DynamicObject obj : dataList) {
            Object v = obj.get(field);
            String sv = v.toString();
            if (!set.add(sv)) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5%1$s\u5b58\u5728\u91cd\u590d\u503c\uff1a%2$s, \u8bf7\u8c03\u6574\u5019\u9009\u952e\u786e\u4fdd\u6570\u636e\u552f\u4e00.", (String)"BatchExecutor_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field, v));
            }
            Map<String, Object> data = fieldDataMap.remove(sv);
            if (data == null) continue;
            data.put(pk, obj.getPkValue());
            updateList.add(data);
        }
    }
}

