/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.trace.TraceTask;

public class BotpServiceInvoker
implements NativeFunction {
    public Object call(ScriptContext ctx, final Object[] args) {
        if (args.length > 4 || args.length < 3) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"IERP_BOTP\u51fd\u6570\u5e94\u4e3a3\u4e2a\u62164\u4e2a\u53c2\u6570\uff1a\u6e90\u5355\u5b9e\u4f53\u7f16\u7801\uff08String\uff09\u3001\u76ee\u6807\u5b9e\u4f53\u7f16\u7801\uff08String\uff09, \u6e90\u5355\u636eID\uff08Object\uff09, \u53c2\u6570\uff08\u53ef\u9009\uff0cMap\uff09\u3002", (String)"BotpServiceInvoker_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        final String srcEntityNumber = D.s((Object)args[0]);
        final String tarEntityNumber = D.s((Object)args[1]);
        final Object billIds = args[2];
        String number = srcEntityNumber + "->" + tarEntityNumber + "|" + billIds;
        return TraceStack.run(TraceType.IERP_BOTP, number, 0L, new TraceTask(){

            public Object invoke() {
                return BotpServiceInvoker.this.innerCall(args, srcEntityNumber, tarEntityNumber, billIds);
            }
        });
    }

    private Object innerCall(Object[] args, String srcEntityNumber, String tarEntityNumber, Object billIds) {
        Map params = Collections.emptyMap();
        if (args.length > 3) {
            if (args[3] instanceof Map) {
                params = (Map)args[3];
            } else {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u7b2c4\u4e2a\u53c2\u6570\u53c2\u6570\u5e94\u8be5\u662fMap\u683c\u5f0f", (String)"BotpServiceInvoker_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
        }
        PushArgs pushArgs = this.getPushArgs(srcEntityNumber, tarEntityNumber, params);
        List<ListSelectedRow> selectedRows = this.getSelectedRows(billIds, params);
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = this.pushAndSave(params, pushArgs);
        this.validResult(pushResult);
        Set targetBillIds = pushResult.getTargetBillIds();
        if (targetBillIds.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u83b7\u53d6\u76ee\u6807\u5355%s\u7684ID", (String)"BotpServiceInvoker_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tarEntityNumber));
        }
        if (targetBillIds.size() > 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u76ee\u6807\u5355\u636e%1$s\u751f\u6210\u4e86\u591a\u6761, ID%2$s\uff0c\u6682\u4e0d\u652f\u6301\u6279\u91cf\u4e0b\u63a8\uff0c\u8bf7\u5c3d\u5feb\u8c03\u6574\u8f93\u5165\u53c2\u6570\u3002", (String)"BotpServiceInvoker_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tarEntityNumber, billIds));
        }
        return targetBillIds.iterator().next();
    }

    private ConvertOperationResult pushAndSave(Map<String, Object> params, PushArgs pushArgs) {
        String proxyUser = D.s((Object)params.get("proxy_user"));
        if (proxyUser == null) {
            return ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        }
        return this.invokeWithProxyUser(pushArgs, proxyUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConvertOperationResult invokeWithProxyUser(PushArgs pushArgs, String proxyUser) {
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            new_rc = ContextUtil.restoreAndGetContext(current, proxyUser);
            ConvertOperationResult convertOperationResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            return convertOperationResult;
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    private PushArgs getPushArgs(String srcEntityNumber, String tarEntityNumber, Map<String, Object> params) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityNumber);
        pushArgs.setTargetEntityNumber(tarEntityNumber);
        if (params.isEmpty()) {
            return pushArgs;
        }
        boolean hasRight = D.x((Object)params.get("hasRight"));
        String appId = this.getStringValue(params.get("appId"));
        long defOrgId = D.l((Object)params.get("defOrgId"));
        String ruleId = this.getStringValue(params.get("ruleId"));
        pushArgs.setHasRight(hasRight);
        pushArgs.setAppId(appId);
        pushArgs.setDefOrgId(Long.valueOf(defOrgId));
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    private String getStringValue(Object value) {
        return value == null ? "" : D.s((Object)value);
    }

    private List<ListSelectedRow> getSelectedRows(Object billId, Map<String, Object> params) {
        if (billId instanceof List) {
            return this.getMulti((List)billId);
        }
        ListSelectedRow row = this.getOne(billId, params);
        return Collections.singletonList(row);
    }

    private List<ListSelectedRow> getMulti(List<?> list) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(list.size());
        for (Object pk : list) {
            ListSelectedRow row = new ListSelectedRow(pk);
            selectedRows.add(row);
        }
        return selectedRows;
    }

    private ListSelectedRow getOne(Object billId, Map<String, Object> params) {
        ListSelectedRow row = new ListSelectedRow(billId);
        String entryEntity = D.s((Object)params.get("entryEntity"));
        if (entryEntity != null) {
            row.setEntryEntityKey(entryEntity);
            row.setEntryPrimaryKeyValue(params.get("entryId"));
        }
        return row;
    }

    private void validResult(ConvertOperationResult pushResult) {
        StringBuilder sb = new StringBuilder();
        if (!pushResult.isSuccess()) {
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                sb.append("\r\n");
                sb.append(String.format(ResManager.loadKDString((String)"\u5355\u636eID(%1$s)\u7f16\u7801(%2$s)\uff0c\u539f\u56e0:%3$s", (String)"BotpServiceInvoker_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), billReport.getBillId(), billReport.getBillNo(), billReport.getFailMessage()));
            }
        }
        if (sb.length() > 0) {
            String message = pushResult.getMessage();
            sb.insert(0, message == null ? "" : message).insert(0, ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a ", (String)"BotpServiceInvoker_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            throw new KDBizException(sb.toString());
        }
    }

    public String name() {
        return "IERP_BOTP";
    }
}

