/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;

public class CacheManager {
    private static final String KEY_PREFIX = "ISC_EVENT_";

    private static LocalMemoryCache getCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1296000);
        info.setMaxMemSize(300);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), "iscb_event_cache", info);
    }

    public static void removeEventCache(RequestContext rc) {
        LocalMemoryCache cache = CacheManager.getCache();
        cache.clear();
    }

    public static void initEventCache(RequestContext rc) {
        LocalMemoryCache cache = CacheManager.getCache();
        String key = KEY_PREFIX + rc.getAccountId();
        cache.put(key, (Object)Boolean.TRUE);
    }

    public static boolean isInitialized(RequestContext rc) {
        String key = KEY_PREFIX + rc.getAccountId();
        LocalMemoryCache cache = CacheManager.getCache();
        return Boolean.TRUE.equals(cache.get(key));
    }
}

