/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.BatchExecutor;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.connector.self.RetrieveData;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.platform.core.util.PropSetterFactory;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class DoBizAction {
    private static final String FIELD_NUMBER = "number";
    private static final String RESPONSE = "$response";
    private static Log logger = LogFactory.getLog(DoBizAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response execute(String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        List<String> actionList = DoBizAction.adjustActions(entity, actions);
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            new_rc = ContextUtil.restoreAndGetContext(current, proxy_user);
            String firstAction = actionList.get(0);
            if (firstAction.equals(TableAction._DELETE.name()) || firstAction.equals("delete")) {
                Response response = DoBizAction.deleteAction(entity, data, judgeFields, targetActionParams);
                return response;
            }
            Response response = DoBizAction.bizAction(entity, data, judgeFields, actionList, targetActionParams);
            return response;
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Response> batchExecute(String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        List<String> actionList = DoBizAction.adjustActions(entity, actions);
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            new_rc = ContextUtil.restoreAndGetContext(current, proxy_user);
            String firstAction = actionList.get(0);
            if (firstAction.equals(TableAction._DELETE.name()) || firstAction.equals("delete")) {
                List<Response> list = DoBizAction.batchDeleteAction(entity, batch, pk, judgeFields, targetActionParams);
                return list;
            }
            List<Response> list = DoBizAction.batchBizAction(entity, batch, pk, judgeFields, actionList, targetActionParams);
            return list;
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    private static List<String> adjustActions(String entity, List<String> actions) {
        if (CollectionUtils.isEmpty(actions)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u672a\u6307\u5b9a\u64cd\u4f5c!", (String)"DoBizAction_44", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        ArrayList<String> actionList = new ArrayList<String>(actions);
        String firstAction = (String)actionList.get(0);
        if (firstAction.equals(TableAction._SAVE.name())) {
            actionList.set(0, "save");
        }
        return actionList;
    }

    private static Response deleteAction(String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, Map<String, Object> targetActionParams) {
        Object id = DoBizAction.queryPrimaryKey(entity, data, judgeFields);
        if (id == null) {
            data.put("$reason", ResManager.loadKDString((String)"\u5f85\u5220\u9664\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u4e0d\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_52", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            return new Response(null, SaveDataType.NOP, null);
        }
        ExecutionData.delete(entity, id, targetActionParams);
        logger.info(String.format("\u6210\u529f\u5220\u9664\u5b9e\u4f53%s\u76841\u6761\u6570\u636e\uff0cID=%s", entity, id));
        return new Response(D.s((Object)id), SaveDataType.DELETE, null);
    }

    private static List<Response> batchDeleteAction(String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, Map<String, Object> targetActionParams) {
        if (CollectionUtils.isEmpty(batch)) {
            return Collections.emptyList();
        }
        ArrayList<Object> ids = new ArrayList<Object>(batch.size());
        ArrayList<Map<String, Object>> deleteList = new ArrayList<Map<String, Object>>(batch.size());
        for (Map<String, Object> data : batch) {
            Object id = DoBizAction.queryPrimaryKey(entity, data, judgeFields);
            if (id == null) {
                data.put("$reason", ResManager.loadKDString((String)"\u5f85\u5220\u9664\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u4e0d\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_52", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                Response res = new Response(null, SaveDataType.NOP, Collections.emptyMap());
                data.put(RESPONSE, res);
                continue;
            }
            ids.add(id);
            deleteList.add(data);
        }
        List<Response> result = ExecutionData.batchDelete(entity, ids, targetActionParams);
        for (int i = 0; i < deleteList.size(); ++i) {
            Map map = (Map)deleteList.get(i);
            map.put(RESPONSE, result.get(i));
        }
        return DoBizAction.buildResponse(batch);
    }

    private static Response bizAction(String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams) {
        Object id = DoBizAction.queryPrimaryKey(entity, data, judgeFields);
        if (id == null) {
            if (actions.contains(TableAction._UPDATE.name())) {
                data.put("$reason", ResManager.loadKDString((String)"\u5f85\u4fee\u6539\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u4e0d\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_50", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                return new Response(null, SaveDataType.NOP, null);
            }
            return DoBizAction.insert(entity, data, judgeFields, actions, targetActionParams);
        }
        if (actions.contains(TableAction._INSERT.name())) {
            data.put("$reason", ResManager.loadKDString((String)"\u5f85\u63d2\u5165\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u5df2\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_51", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            return new Response(D.s((Object)id), SaveDataType.NOP, null);
        }
        return DoBizAction.update(entity, data, id, judgeFields, actions, targetActionParams);
    }

    private static List<Response> batchBizAction(String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams) {
        if (CollectionUtils.isEmpty(batch)) {
            return Collections.emptyList();
        }
        if (actions.size() != 1) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6279\u91cf\u6267\u884c\u4e0d\u652f\u6301\u591a\u4e2a\u64cd\u4f5c!", (String)"DoBizAction_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
        DoBizAction.classify(entity, batch, pk, judgeFields, insertList, updateList);
        String action = actions.get(0);
        boolean mergeExceptionToData = DoBizAction.isMergeExceptionToData(targetActionParams, action);
        DoBizAction.batchInsert(entity, insertList, pk, judgeFields, action, targetActionParams, mergeExceptionToData);
        DoBizAction.batchUpdate(entity, updateList, pk, judgeFields, action, targetActionParams, mergeExceptionToData);
        return DoBizAction.buildResponse(batch);
    }

    private static List<Response> buildResponse(List<Map<String, Object>> batch) {
        ArrayList<Response> responses = new ArrayList<Response>(batch.size());
        for (Map<String, Object> map : batch) {
            responses.add((Response)map.remove(RESPONSE));
        }
        return responses;
    }

    private static boolean isMergeExceptionToData(Map<String, Object> targetActionParams, String action) {
        boolean mergeExceptionToData = false;
        if (targetActionParams == null) {
            return mergeExceptionToData;
        }
        Map param = (Map)targetActionParams.get(action);
        if (param != null) {
            mergeExceptionToData = D.x(param.remove("$mergeExceptionToData"));
        }
        return mergeExceptionToData;
    }

    private static void classify(String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList) {
        if (BatchExecutor.matchesBatchMode(entity, batch, judgeFields, pk)) {
            BatchExecutor.classifyBatchData(entity, batch, judgeFields, insertList, updateList);
        } else {
            DoBizAction.classifyRowByRow(entity, batch, pk, judgeFields, insertList, updateList);
        }
    }

    private static void classifyRowByRow(String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList) {
        for (Map<String, Object> data : batch) {
            Object id = DoBizAction.queryPrimaryKey(entity, data, judgeFields);
            if (id == null) {
                insertList.add(data);
                continue;
            }
            data.put(pk, id);
            updateList.add(data);
        }
    }

    private static Response insert(String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams) {
        HashMap<String, DynamicObject> entries = new HashMap<String, DynamicObject>();
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entity);
        DoBizAction.setDefaultCreatorAndCreatedTime(data, obj);
        DoBizAction.setDynamicObjectValues(obj, data, judgeFields, entries);
        Object id = DoBizAction.doActions(entity, obj, actions, targetActionParams);
        AttachmentUtil.bindingAttachment(entity, data, id);
        return new Response(D.s((Object)id), SaveDataType.INSERT, DoBizAction.toEntryMapping(entries));
    }

    private static void setDefaultCreatorAndCreatedTime(Map<String, Object> data, DynamicObject obj) {
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        if (!data.containsKey("creator") && !data.containsKey("creator_id") && properties.get((Object)"creator") instanceof CreaterProp) {
            data.put("creator", RequestContext.get().getCurrUserId());
        }
        if (!data.containsKey("createtime") && properties.get((Object)"createtime") instanceof CreateDateProp) {
            data.put("createtime", new Timestamp(System.currentTimeMillis()));
        }
    }

    private static void batchInsert(String entity, List<Map<String, Object>> insertList, String pk, Map<String, List<String>> judgeFields, String action, Map<String, Object> targetActionParams, boolean mergeExceptionToData) {
        if (CollectionUtils.isEmpty(insertList)) {
            return;
        }
        DoBizAction.assignPKValues(entity, pk, insertList);
        ArrayList<Map<String, Object>> batchInsertList = new ArrayList<Map<String, Object>>();
        if (action.equals(TableAction._UPDATE.name())) {
            List<Response> responses = DoBizAction.ignoreResponses(insertList, action);
            DoBizAction.bindResponse(insertList, responses);
        } else {
            LinkedList<DynamicObject> objects = new LinkedList<DynamicObject>();
            for (Map<String, Object> data : insertList) {
                HashMap<String, DynamicObject> entries = new HashMap<String, DynamicObject>();
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entity);
                try {
                    DoBizAction.setDefaultCreatorAndCreatedTime(data, obj);
                    DoBizAction.setDynamicObjectValues(obj, data, judgeFields, entries);
                    batchInsertList.add(data);
                    objects.add(obj);
                }
                catch (Throwable e) {
                    if (mergeExceptionToData) {
                        data.put(RESPONSE, new Response(D.s((Object)data.get(pk)), StringUtil.getCascadeMessage((Throwable)e)));
                        continue;
                    }
                    throw e;
                }
            }
            List<Response> responses = ExecutionData.batchExecute(entity, objects, SaveDataType.INSERT, action, targetActionParams);
            DoBizAction.bindResponse(batchInsertList, responses);
        }
    }

    private static void assignPKValues(String entity, String pk, List<Map<String, Object>> insertList) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicProperty property = entityType.getProperty(pk);
        boolean isLong = !(property instanceof VarcharProp);
        for (Map<String, Object> data : insertList) {
            if (!DoBizAction.isPrimaryKeyEmpty(data, pk, isLong)) continue;
            data.put(pk, DoBizAction.getNewId(isLong));
        }
    }

    private static boolean isPrimaryKeyEmpty(Map<String, Object> data, String pk, boolean isLong) {
        Object value = data.get(pk);
        if (isLong) {
            return D.l((Object)value) == 0L;
        }
        return D.s((Object)value) == null;
    }

    private static Object getNewId(boolean isLong) {
        return isLong ? Long.valueOf(DB.genGlobalLongId()) : DB.genStringId((String)"");
    }

    private static List<Response> ignoreResponses(List<Map<String, Object>> batch, String action) {
        String mes = action.equals(TableAction._UPDATE.name()) ? ResManager.loadKDString((String)"\u5f85\u4fee\u6539\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u4e0d\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_50", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f85\u63d2\u5165\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u5df2\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"K3CloudBizAction_51", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        ArrayList<Response> responses = new ArrayList<Response>(batch.size());
        for (Map<String, Object> data : batch) {
            data.put("$reason", mes);
            responses.add(new Response(D.s((Object)data.get("id")), SaveDataType.NOP, Collections.emptyMap()));
        }
        return responses;
    }

    private static Map<String, String> toEntryMapping(Map<String, DynamicObject> entries) {
        if (entries.size() == 0) {
            return null;
        }
        HashMap<String, String> mapping = new HashMap<String, String>(entries.size());
        for (Map.Entry<String, DynamicObject> e : entries.entrySet()) {
            mapping.put(e.getKey(), D.s((Object)e.getValue().getPkValue()));
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response update(String entity, Map<String, Object> data, Object id, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams) {
        HashMap<String, DynamicObject> entries = new HashMap<String, DynamicObject>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)entityType);
        Object ID = data.remove("id");
        try {
            DoBizAction.setDynamicObjectValues(obj, data, judgeFields, entries);
        }
        finally {
            data.put("id", ID);
        }
        DoBizAction.doActions(entity, obj, actions, targetActionParams);
        AttachmentUtil.bindingAttachment(entity, data, id);
        return new Response(D.s((Object)id), SaveDataType.UPDATE, DoBizAction.toEntryMapping(entries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void batchUpdate(String entity, List<Map<String, Object>> updateList, String pk, Map<String, List<String>> judgeFields, String action, Map<String, Object> targetActionParams, boolean mergeExceptionToData) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        ArrayList<Map<String, Object>> batchUpdateList = new ArrayList<Map<String, Object>>();
        if (action.equals(TableAction._INSERT.name())) {
            List<Response> responses = DoBizAction.ignoreResponses(updateList, action);
            DoBizAction.bindResponse(updateList, responses);
        } else {
            LinkedList<DynamicObject> objects = new LinkedList<DynamicObject>();
            Map<String, DynamicObject> originObjectMap = DoBizAction.getOriginObjectMap(updateList, pk, entity);
            for (Map<String, Object> data : updateList) {
                HashMap<String, DynamicObject> entries = new HashMap<String, DynamicObject>();
                Object ID = data.remove(pk);
                DynamicObject obj = originObjectMap.get(D.s((Object)ID));
                try {
                    DoBizAction.setDynamicObjectValues(obj, data, judgeFields, entries);
                    batchUpdateList.add(data);
                    objects.add(obj);
                }
                catch (Throwable e) {
                    if (mergeExceptionToData) {
                        data.put(RESPONSE, new Response(D.s((Object)ID), StringUtil.getCascadeMessage((Throwable)e)));
                        continue;
                    }
                    throw e;
                }
                finally {
                    data.put(pk, ID);
                }
            }
            List<Response> responses = ExecutionData.batchExecute(entity, objects, SaveDataType.UPDATE, action, targetActionParams);
            DoBizAction.bindResponse(batchUpdateList, responses);
        }
    }

    private static Map<String, DynamicObject> getOriginObjectMap(List<Map<String, Object>> updateList, String pk, String entity) {
        ArrayList<Object> pkList = new ArrayList<Object>(updateList.size());
        for (Map<String, Object> map : updateList) {
            pkList.add(map.get(pk));
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObject[] originObjects = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)entityType);
        HashMap<String, DynamicObject> originObjectMap = new HashMap<String, DynamicObject>(originObjects.length);
        for (DynamicObject originObject : originObjects) {
            originObjectMap.put(D.s((Object)originObject.getPkValue()), originObject);
        }
        return originObjectMap;
    }

    private static void bindResponse(List<Map<String, Object>> batch, List<Response> responses) {
        for (int i = 0; i < batch.size(); ++i) {
            Map<String, Object> map = batch.get(i);
            map.put(RESPONSE, responses.get(i));
        }
    }

    private static Object doActions(String entity, DynamicObject object, List<String> actions, Map<String, Object> targetActionParams) {
        Object id = null;
        for (int i = 0; i < actions.size(); ++i) {
            String action = actions.get(i);
            id = ExecutionData.execute(entity, object, action, targetActionParams);
            if (id == null || i >= actions.size() - 1) continue;
            object = BusinessDataServiceHelper.loadSingle((Object)id, (String)entity);
        }
        return id;
    }

    public static Object queryPrimaryKey(String entity, Map<String, Object> data, Map<String, List<String>> judgeFields) {
        QFilter filter;
        Object id;
        Object pkValue;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        String pk = entityType.getPrimaryKey().getName();
        try {
            pkValue = RetrieveData.cast((EntityType)entityType, pk, data.get(pk));
        }
        catch (Exception e) {
            data.put("#warn", String.format(ResManager.loadKDString((String)"id:%s\uff0c\u7c7b\u578b\u975e\u6cd5\uff0c\u5c06\u901a\u8fc7\u5019\u9009\u952e\u627e\u76ee\u6807\u5355ID\u3002", (String)"DoBizAction_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]), data.remove(pk)));
            pkValue = null;
        }
        if (pkValue != null && (id = DoBizAction.innerGetPk(entity, new QFilter[]{filter = new QFilter(pk, "=", pkValue)}, Collections.singletonList(pk), data)) != null) {
            return id;
        }
        if (!judgeFields.containsKey("$")) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7684\u5019\u9009\u952ekey\u4e0d\u5b58\u5728!", (String)"DoBizAction_31", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        List<String> fields = judgeFields.get("$");
        if (fields == null || fields.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7684\u5019\u9009\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728!", (String)"DoBizAction_32", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity));
        }
        QFilter[] filters = new QFilter[fields.size()];
        int i = 0;
        for (String field : fields) {
            QFilter filter2 = DoBizAction.getJudgeQFilter((EntityType)entityType, field, data);
            filters[i++] = filter2;
        }
        return DoBizAction.innerGetPk(entity, filters, fields, data);
    }

    private static Object innerGetPk(String entity, QFilter[] filters, List<String> fields, Map<String, Object> data) {
        String number;
        HashSet<String> requires = new HashSet<String>();
        requires.add("id");
        requires.addAll(fields);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entity, (String)StringUtil.join(requires), (QFilter[])filters);
        if (fields.size() == 1 && fields.contains(FIELD_NUMBER) && (number = D.s((Object)data.get(FIELD_NUMBER))) != null) {
            return DoBizAction.findIdByNumber(entity, (List<DynamicObject>)ids, number);
        }
        if (ids.isEmpty()) {
            return null;
        }
        if (ids.size() == 1) {
            return ((DynamicObject)ids.get(0)).get("id");
        }
        return DoBizAction.handleMultiIds(entity, fields, (List<DynamicObject>)ids);
    }

    private static Object handleMultiIds(String entity, List<String> fields, List<DynamicObject> ids) {
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(ids);
        if (set.size() > 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u6839\u636e\u5019\u9009\u952e%2$s\u67e5\u8be2\u5230\u591a\u6761\u8bb0\u5f55!", (String)"DoBizAction_33", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, String.join((CharSequence)",", fields)));
        }
        return ids.get(0).get("id");
    }

    private static Object findIdByNumber(String entity, List<DynamicObject> ids, String number) {
        Object id = null;
        for (DynamicObject obj : ids) {
            if (!number.equals(D.s((Object)obj.get(FIELD_NUMBER)))) continue;
            if (id == null) {
                id = obj.get("id");
                continue;
            }
            if (id.equals(obj.get("id"))) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u5b9e\u4f53%1$s\u5b58\u5728\u591a\u6761\u7f16\u7801\u4e3a\uff08%2$s\uff09\u7684\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u5019\u9009\u952e\u6216\u5bf9\u91cd\u590d\u6570\u636e\u8fdb\u884c\u4fee\u590d\uff0c\u4ee5\u786e\u4fdd\u6e90\u548c\u76ee\u6807\u80fd\u552f\u4e00\u5339\u914d\u3002", (String)"DoBizAction_34", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, number));
        }
        return id;
    }

    private static QFilter getJudgeQFilter(EntityType entityType, String field, Map<String, Object> data) {
        Object o = data.get(field);
        if (o == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5\u672a\u8d4b\u503c\uff1a[%s]", (String)"DoBizAction_35", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field));
        }
        Object value = RetrieveData.castSingleValue(entityType, field, o);
        return new QFilter(field, "=", value);
    }

    private static void setDynamicObjectValues(DynamicObject obj, Map<String, Object> map, Map<String, List<String>> judgeFields, Map<String, DynamicObject> entries) {
        String propName;
        String source_oid;
        DynamicObjectType entity = obj.getDynamicObjectType();
        if (!(entity instanceof MainEntityType) && (source_oid = D.s((Object)map.remove("$id"))) != null) {
            entries.put(source_oid, obj);
        }
        DataEntityPropertyCollection properties = entity.getProperties();
        ArrayList<IDataEntityProperty> afterHandleSetter = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty property : properties) {
            propName = property.getName();
            if (!map.containsKey(propName) || property instanceof DynamicLocaleProperty) continue;
            if (property instanceof FlexProp) {
                afterHandleSetter.add(property);
                continue;
            }
            if (property instanceof EntryProp) {
                DoBizAction.updateEntry(obj, (EntryProp)property, map.get(propName), judgeFields, entries);
                continue;
            }
            DoBizAction.setterSetValue(obj, map, property, propName);
        }
        for (IDataEntityProperty property : afterHandleSetter) {
            propName = property.getName();
            if (!map.containsKey(propName)) continue;
            DoBizAction.setterSetValue(obj, map, property, propName);
        }
    }

    private static void setterSetValue(DynamicObject obj, Map<String, Object> map, IDataEntityProperty property, String propName) {
        Object val = map.get(propName);
        Setter setter = PropSetterFactory.createSetter(property);
        try {
            setter.setObjValue(obj, propName, val, map);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%1$s\uff09\u8d4b\u503c\uff08%2$s\uff09\u51fa\u9519\uff0c\u539f\u56e0\uff1a%3$s", (String)"DoBizAction_36", (String)"isc-iscb-platform-core", (Object[])new Object[0]), propName, val, e.getMessage()), (Throwable)e);
        }
    }

    private static void updateEntry(DynamicObject obj, EntryProp property, Object data, Map<String, List<String>> judgeFields, Map<String, DynamicObject> entries) {
        String entryFullName = DoBizAction.getEntryFullName(property);
        if (judgeFields == null || !judgeFields.containsKey(entryFullName)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\uff08%s\uff09\u672a\u8bbe\u7f6e\u5019\u9009\u952e!", (String)"DoBizAction_37", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entryFullName));
        }
        DynamicObjectCollection collection = obj.getDynamicObjectCollection((IDataEntityProperty)property);
        EntityType type = (EntityType)property.getItemType();
        type.setDBRouteKey(obj.getDataEntityType().getDBRouteKey());
        if (data instanceof Map) {
            DoBizAction.filterEntry((DynamicObjectType)type, property, collection, Collections.singletonList((Map)data), judgeFields, entries);
        } else if (data instanceof List) {
            DoBizAction.filterEntry((DynamicObjectType)type, property, collection, (List)data, judgeFields, entries);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\uff08%1$s\uff09\u7684\u8d4b\u503c\u4e0d\u662f\u5217\u8868\uff08List\uff09 : %2$s", (String)"DoBizAction_38", (String)"isc-iscb-platform-core", (Object[])new Object[0]), property, data));
        }
        obj.set((IDataEntityProperty)property, (Object)collection);
    }

    private static String getEntryFullName(EntryProp prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(prop.getName());
        IDataEntityType type = prop.getItemType();
        while (type.getParent() instanceof EntryType) {
            sb.insert(0, ".").insert(0, prop.getParent().getName());
            type = type.getParent();
        }
        return sb.toString();
    }

    private static String calcKeys(DynamicObject o, List<String> judgeFields) {
        StringBuilder sb = new StringBuilder();
        for (String key : judgeFields) {
            Object value = o.get(key);
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getPkValue();
            } else {
                if (value instanceof DynamicObjectCollection) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5206\u5f55\u5b57\u6bb5(%s)\u662f\u591a\u9009\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5019\u9009\u952e\u3002", (String)"DoBizAction_39", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
                }
                if (value instanceof OrmLocaleValue) {
                    value = ((OrmLocaleValue)value).getLocaleValue();
                }
            }
            if (value == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5206\u5f55\u5019\u9009\u952e\u5b57\u6bb5(%s)\u672a\u8d4b\u503c\u6216\u503c\u4e3anull\uff0c\u8bf7\u68c0\u67e5\u82cd\u7a79\u7cfb\u7edf\u4e2d\u8be5\u5355\u636e\u7684\u5019\u9009\u952e\u5b57\u6bb5\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a\u3002", (String)"DoBizAction_40", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
            }
            sb.append(value).append('\n');
        }
        return sb.toString();
    }

    public static String calcMapKeys(Map<String, Object> tar, List<String> judgeFields, DynamicObjectType type) {
        StringBuilder sb = new StringBuilder();
        for (String key : judgeFields) {
            Object value = tar.get(key);
            if (value == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5(%s)\u672a\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u548c\u6e90\u8868\u6570\u636e\u3002", (String)"DoBizAction_41", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
            }
            if (value instanceof Map) {
                value = DoBizAction.getMapValue(type, key, value);
            }
            sb.append(value).append('\n');
        }
        return sb.toString();
    }

    private static Object getMapValue(DynamicObjectType type, String key, Object value) {
        String localeKey;
        DynamicProperty property = type.getProperty(key);
        if (property instanceof MuliLangTextProp && (value = ((Map)value).get(localeKey = DoBizAction.getLocaleKey())) == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5(%1$s)\u4e3a\u591a\u8bed\u8a00\uff0c\u5bf9\u5e94\u7684%2$s\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"DoBizAction_42", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key, localeKey));
        }
        return value;
    }

    private static String getLocaleKey() {
        if (Lang.get() == Lang.zh_CN) {
            return "zh_CN";
        }
        if (Lang.get() == Lang.zh_TW) {
            return "zh_TW";
        }
        if (Lang.get() == Lang.en_US) {
            return "en_US";
        }
        return "zh_CN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterEntry(DynamicObjectType type, EntryProp property, DynamicObjectCollection collection, List<Map<String, Object>> dataList, Map<String, List<String>> judgeFields, Map<String, DynamicObject> entries) {
        String keys;
        HashMap<String, DynamicObject> mapping = new HashMap<String, DynamicObject>();
        List<String> fields = judgeFields.get(DoBizAction.getEntryFullName(property));
        for (DynamicObject o : collection) {
            keys = DoBizAction.calcKeys(o, fields);
            DynamicObject object = mapping.put(keys, o);
            if (object == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5206\u5f55\u5019\u9009\u952e%1$s\u627e\u5230\u91cd\u590d\u503c%2$s\uff0c\u8bf7\u4fee\u6539\u5019\u9009\u952e!", (String)"DoBizAction_43", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.join(fields), StringUtil.join((Object[])keys.split("\n"))));
        }
        for (Map<String, Object> data : dataList) {
            keys = DoBizAction.calcMapKeys(data, fields, type);
            DynamicObject original = (DynamicObject)mapping.remove(keys);
            if (original == null) {
                DynamicObject newObject = new DynamicObject(type);
                newObject.set("id", data.get("id"));
                DoBizAction.setDynamicObjectValues(newObject, data, judgeFields, entries);
                collection.add((Object)newObject);
                continue;
            }
            Object id = data.remove("id");
            try {
                DoBizAction.setDynamicObjectValues(original, data, judgeFields, entries);
            }
            finally {
                data.put("id", id);
            }
        }
        for (DynamicObject r : mapping.values()) {
            collection.remove((Object)r);
        }
    }
}

