/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.EnumInfo;
import kd.isc.iscb.platform.core.connector.self.FlexInfo;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.PropSetterFactory;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Pair;

public class EntityInfo {
    private static final String ACTION_TYPE_UPDATE = "update";
    private static final String PROP_TYPE = "type";
    private static final String PROP_NAME = "name";
    private static final String PROP_LABEL = "label";
    private static final String PROP_INDEX = "index";
    private static final String FLEX_PROPERTIES = "FLEX_PROPERTY";
    private static final Map<String, String> actionTypes = new HashMap<String, String>();
    private static Log logger = LogFactory.getLog(EntityInfo.class);

    public static Map<String, Object> get(String name) {
        try {
            EntityType entityType = EntityInfo.loadEntity(name);
            HashMap<String, Object> entityMap = new HashMap<String, Object>();
            EntityInfo.setBasics(name, entityType, entityMap);
            entityMap.put("properties", EntityInfo.getProperties((IDataEntityType)entityType));
            List<Map<String, Object>> actionList = EntityInfo.getOperations(entityType);
            entityMap.put("actions", actionList);
            entityMap.put("events", EntityInfo.getEventsByActions(actionList));
            return entityMap;
        }
        catch (Throwable e) {
            return EntityInfo.handlerError(name, e);
        }
    }

    public static List<Map<String, Object>> getEntityInfoList(String name) {
        List<Pair<String, MetaType>> relatedMetas = EntityInfo.getRelatedMetas(name);
        ArrayList<Map<String, Object>> metaInfoList = new ArrayList<Map<String, Object>>(relatedMetas.size());
        for (Pair<String, MetaType> meta : relatedMetas) {
            if (meta.getB() == MetaType.ENTITY) {
                metaInfoList.add(EntityInfo.get((String)meta.getA()));
                continue;
            }
            if (meta.getB() == MetaType.ENUM) {
                metaInfoList.add(EnumInfo.get((String)meta.getA()));
                continue;
            }
            if (meta.getB() != MetaType.STRUCT || !FLEX_PROPERTIES.equals(meta.getA())) continue;
            metaInfoList.add(FlexInfo.get((String)meta.getA()));
        }
        return metaInfoList;
    }

    public static List<Pair<String, MetaType>> getRelatedMetas(String name) {
        ArrayList<Pair<String, MetaType>> entityList = new ArrayList<Pair<String, MetaType>>();
        HashSet<String> fullNames = new HashSet<String>();
        int i = name.indexOf(46);
        if (i < 0) {
            MainEntityType main = EntityMetadataCache.getDataEntityType((String)name);
            for (EntityType entityType : main.getAllEntities().values()) {
                String full_name = entityType == main ? main.getName() : main.getName() + "." + entityType.getName();
                entityList.add((Pair<String, MetaType>)new Pair((Object)full_name, (Object)MetaType.ENTITY));
                fullNames.add(full_name);
                EntityInfo.addRelateEnumAndBaseData(entityList, entityType, main, fullNames);
                EntityInfo.addRelateFlex(entityList, entityType, fullNames);
            }
            return entityList;
        }
        entityList.add(new Pair((Object)name, (Object)MetaType.ENTITY));
        fullNames.add(name);
        MainEntityType main = EntityMetadataCache.getDataEntityType((String)name.substring(0, i));
        String subName = name.substring(i + 1);
        EntityType entityType = (EntityType)main.getAllEntities().get(subName);
        if (entityType == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u4e0d\u5b58\u5728\u5c5e\u6027%2$s, \u8bf7\u4fee\u6539\u540e\u518d\u64cd\u4f5c\u3002", (String)"EntityInfo_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), main.getName(), subName));
        }
        EntityInfo.addRelateEnumAndBaseData(entityList, entityType, main, fullNames);
        EntityInfo.addRelateFlex(entityList, entityType, fullNames);
        return entityList;
    }

    private static void addRelateFlex(List<Pair<String, MetaType>> entityList, EntityType entityType, Set<String> fullNames) {
        for (IDataEntityProperty p : entityType.getProperties()) {
            if (!(p instanceof FlexProp) || !fullNames.add(FLEX_PROPERTIES)) continue;
            entityList.add((Pair<String, MetaType>)new Pair((Object)FLEX_PROPERTIES, (Object)MetaType.STRUCT));
        }
    }

    private static void addRelateEnumAndBaseData(List<Pair<String, MetaType>> entityList, EntityType entityType, MainEntityType main, Set<String> fullNames) {
        for (IDataEntityProperty p : entityType.getProperties()) {
            String name;
            if (p instanceof ComboProp) {
                name = entityType == main ? main.getName() + "." + p.getName() : main.getName() + "." + entityType.getName() + "." + p.getName();
                if (!fullNames.add(name)) continue;
                entityList.add((Pair<String, MetaType>)new Pair((Object)name, (Object)MetaType.ENUM));
                continue;
            }
            if (!(p instanceof BasedataProp) || p instanceof FlexProp || !fullNames.add(name = ((BasedataProp)p).getBaseEntityId())) continue;
            entityList.add((Pair<String, MetaType>)new Pair((Object)name, (Object)MetaType.ENTITY));
        }
    }

    private static List<Map<String, Object>> getEventsByActions(List<Map<String, Object>> actionList) {
        ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>(actionList.size());
        for (Map<String, Object> action : actionList) {
            if (action.get(PROP_NAME).equals(TableAction._INSERT.name()) || action.get(PROP_NAME).equals(TableAction._UPDATE.name())) continue;
            events.add(action);
        }
        return events;
    }

    static EntityType loadEntity(String name) {
        int i = name.indexOf(46);
        if (i < 0) {
            return EntityMetadataCache.getDataEntityType((String)name);
        }
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)name.substring(0, i));
        String subname = name.substring(i + 1);
        return (EntityType)entity.getAllEntities().get(subname);
    }

    private static void setBasics(String name, EntityType entityType, Map<String, Object> entityMap) {
        String tableName = entityType.getAlias();
        String dbRouteKey = D.s((Object)entityType.getDBRouteKey());
        if (dbRouteKey != null) {
            tableName = tableName + "@" + dbRouteKey;
        }
        entityMap.put("table_name", tableName.toUpperCase());
        entityMap.put("full_name", name);
        entityMap.put(PROP_NAME, name.contains(".") ? Hash.mur32((Object[])new Object[]{name}) : name);
        entityMap.put(PROP_TYPE, "ENTITY");
        String title = EntityInfo.getTitle(entityType);
        entityMap.put("title", title);
    }

    static String getTitle(EntityType entityType) {
        EntityType parent = entityType;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        String title = parent == entityType ? entityType.getDisplayName().toString() : parent.getDisplayName() + "." + entityType.getDisplayName();
        return title;
    }

    private static Map<String, Object> handlerError(String name, Throwable e) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        entityMap.put("full_name", name);
        entityMap.put(PROP_NAME, name);
        entityMap.put(PROP_TYPE, "ENTITY");
        entityMap.put("error_stack", e);
        return entityMap;
    }

    private static List<Map<String, Object>> getProperties(IDataEntityType entityType) {
        DataEntityPropertyCollection entityPropertyCollection = entityType.getProperties();
        String parentEntityName = entityType.getName();
        IDataEntityType parent = entityType;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent != entityType) {
            parentEntityName = parent.getName() + "." + parentEntityName;
        }
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>();
        for (IDataEntityProperty prop : entityPropertyCollection) {
            String name = prop.getName();
            if (EntityInfo.isBaseDataId(name, entityPropertyCollection) || "multilanguagetext".equals(prop.getName()) || !(prop instanceof EntryProp) && D.s((Object)prop.getAlias()) == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put(PROP_INDEX, prop.getOrdinal() + 1);
            map.put(PROP_NAME, prop.getName());
            map.put("is_primary_key", Boolean.FALSE);
            map.put("is_nullable", Boolean.TRUE);
            map.put("data_schema", "");
            map.put("remark", "");
            map.put(PROP_LABEL, prop.getDisplayName() == null ? "" : prop.getDisplayName().getLocaleValue());
            Setter setter = PropSetterFactory.createSetter(prop);
            setter.setSchema(map, parentEntityName, prop.getName());
            properties.add(map);
        }
        List<Map<String, Object>> panels = EntityInfo.getAttachmentPanel(entityType);
        properties.addAll(panels);
        return properties;
    }

    private static boolean isBaseDataId(String name, DataEntityPropertyCollection collection) {
        if (name.endsWith("_id")) {
            String substring = name.substring(0, name.length() - 3);
            IDataEntityProperty property = (IDataEntityProperty)collection.get((Object)substring);
            return property instanceof BasedataProp || property instanceof RefBillProp;
        }
        return false;
    }

    private static List<Map<String, Object>> getAttachmentPanel(IDataEntityType entityType) {
        if (!(entityType instanceof MainEntityType)) {
            return Collections.emptyList();
        }
        String entity = entityType.getName();
        List<String> keys = AttachmentUtil.getAttachmentPanelKeys(entity);
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> panels = new ArrayList<Map<String, Object>>(keys.size());
        for (String key : keys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(PROP_INDEX, 100);
            map.put(PROP_NAME, key);
            map.put("is_primary_key", Boolean.FALSE);
            map.put("is_nullable", Boolean.TRUE);
            map.put("data_schema", "bos_attachment");
            map.put("remark", "");
            map.put(PROP_LABEL, ResManager.loadKDString((String)"\u9644\u4ef6\u9762\u677f", (String)"EntityInfo_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            map.put("data_type", "ENTRIES");
            panels.add(map);
        }
        return panels;
    }

    static List<Map<String, Object>> getOperations(EntityType entityType) {
        if (!(entityType instanceof MainEntityType)) {
            return Collections.emptyList();
        }
        String locale = D.s((Object)RequestContext.get().getLang());
        ArrayList<Map<String, Object>> actionList = new ArrayList<Map<String, Object>>();
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityType.getName());
        for (Map op : ops) {
            String type = actionTypes.get(D.s(op.get(PROP_TYPE)));
            if (type == null) continue;
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put(PROP_INDEX, actionList.size() + 1);
            tempMap.put(PROP_NAME, String.valueOf(op.get("key")));
            tempMap.put(PROP_TYPE, type);
            Map name = (Map)op.get(PROP_NAME);
            tempMap.put(PROP_LABEL, EntityInfo.getLocaleValue(name, locale));
            actionList.add(tempMap);
            if (!String.valueOf(op.get("key")).equals("save")) continue;
            EntityInfo.addVirtualActions(actionList);
            tempMap.put(PROP_LABEL, String.format(ResManager.loadKDString((String)"%s(\u65b0\u589e+\u4fee\u6539)", (String)"EntityInfo_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), EntityInfo.getLocaleValue(name, locale)));
        }
        return actionList;
    }

    private static String getLocaleValue(Map<?, ?> name, String locale) {
        String value = D.s(name.get(locale));
        if (value != null) {
            return value;
        }
        return D.s(name.get("zh_CN"));
    }

    private static void addVirtualActions(List<Map<String, Object>> actionList) {
        HashMap<String, Object> insertAction = new HashMap<String, Object>();
        insertAction.put(PROP_INDEX, actionList.size() + 1);
        insertAction.put(PROP_NAME, TableAction._INSERT.name());
        insertAction.put(PROP_TYPE, TableAction._INSERT.name());
        insertAction.put(PROP_LABEL, ResManager.loadKDString((String)"\u65b0\u589e", (String)"EntityInfo_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        actionList.add(insertAction);
        HashMap<String, Object> updateAction = new HashMap<String, Object>();
        updateAction.put(PROP_INDEX, actionList.size() + 1);
        updateAction.put(PROP_NAME, TableAction._UPDATE.name());
        updateAction.put(PROP_TYPE, TableAction._UPDATE.name());
        updateAction.put(PROP_LABEL, ResManager.loadKDString((String)"\u4fee\u6539", (String)"EntityInfo_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        actionList.add(updateAction);
    }

    static {
        actionTypes.put("save", "save");
        actionTypes.put("submit", ACTION_TYPE_UPDATE);
        actionTypes.put("unsubmit", ACTION_TYPE_UPDATE);
        actionTypes.put("audit", ACTION_TYPE_UPDATE);
        actionTypes.put("unaudit", ACTION_TYPE_UPDATE);
        actionTypes.put("delete", "delete");
        actionTypes.put("enable", ACTION_TYPE_UPDATE);
        actionTypes.put("disable", ACTION_TYPE_UPDATE);
        actionTypes.put("invalid", ACTION_TYPE_UPDATE);
        actionTypes.put("valid", ACTION_TYPE_UPDATE);
        actionTypes.put("donothing", ACTION_TYPE_UPDATE);
        actionTypes.put("scmcgenlotnum", ACTION_TYPE_UPDATE);
        actionTypes.put("scmcgensnnum", ACTION_TYPE_UPDATE);
        actionTypes.put("runscript", ACTION_TYPE_UPDATE);
        actionTypes.put("assign", ACTION_TYPE_UPDATE);
        actionTypes.put("unassign", ACTION_TYPE_UPDATE);
        actionTypes.put("statusconvert", ACTION_TYPE_UPDATE);
        actionTypes.put("parametersave", ACTION_TYPE_UPDATE);
        actionTypes.put("reset", ACTION_TYPE_UPDATE);
        actionTypes.put("cooperation", ACTION_TYPE_UPDATE);
        actionTypes.put("tracevoucher", ACTION_TYPE_UPDATE);
        actionTypes.put("generatevoucher", ACTION_TYPE_UPDATE);
        actionTypes.put("deletevoucher", ACTION_TYPE_UPDATE);
        actionTypes.put("closeinit", ACTION_TYPE_UPDATE);
        actionTypes.put("anticloseinit", ACTION_TYPE_UPDATE);
        actionTypes.put("closeperiod", ACTION_TYPE_UPDATE);
        actionTypes.put("anticloseperiod", ACTION_TYPE_UPDATE);
        actionTypes.put("fi_archive", ACTION_TYPE_UPDATE);
        actionTypes.put("refi_archive", ACTION_TYPE_UPDATE);
        actionTypes.put("assigntask", ACTION_TYPE_UPDATE);
        actionTypes.put("generatefincard", ACTION_TYPE_UPDATE);
        actionTypes.put("deletefincard", ACTION_TYPE_UPDATE);
        actionTypes.put("reciprocal_writeoff", ACTION_TYPE_UPDATE);
        actionTypes.put("checkstatus", ACTION_TYPE_UPDATE);
        actionTypes.put("dataupgrade", ACTION_TYPE_UPDATE);
        actionTypes.put("datacollect", ACTION_TYPE_UPDATE);
        actionTypes.put(TableAction._INSERT.name(), "insert");
        actionTypes.put(TableAction._UPDATE.name(), ACTION_TYPE_UPDATE);
        actionTypes.put("pushandsave", ACTION_TYPE_UPDATE);
        try {
            Set ops = OperationTypeCache.loadAll().getOpTypes().stream().map(OperationType::getId).collect(Collectors.toSet());
            for (String op : ops) {
                if (actionTypes.containsKey(op) || !OperationTypeCache.isEntityOperation((String)op)) continue;
                actionTypes.put(op, ACTION_TYPE_UPDATE);
            }
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u901a\u7528\u64cd\u4f5c\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }
}

