/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.self.CacheManager;
import kd.isc.iscb.platform.core.connector.self.EventRegister;
import kd.isc.iscb.util.bean.BatchTriggerInfo;
import kd.isc.iscb.util.bean.EachTriggerInfo;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.InitResult;
import kd.isc.iscb.util.connector.InitStatus;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class EventUtil {
    public static final String SELF = "{self}";

    public static void attachEvents(Connection cn, String iscHub, EventBindingUtil.TriggerType triggerType, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        RequestContext rc = RequestContext.get();
        String[] newEvents = EventUtil.convertEvents(events);
        EventBindingUtil.saveEvents((Connection)cn, (String)iscHub, (String)entity, (EventBindingUtil.TriggerType)triggerType, (long)triggerId, (String[])newEvents, requires);
        EventBindingCache.init((String)rc.getAccountId(), (Connection)cn);
        EventRegister.register(entity, newEvents);
        CacheManager.removeEventCache(rc);
    }

    public static void detachEvents(Connection cn, String iscHub, EventBindingUtil.TriggerType triggerType, long triggerId, String entity) {
        RequestContext rc = RequestContext.get();
        EventBindingUtil.deleteEvents((Connection)cn, (String)iscHub, (String)entity, (EventBindingUtil.TriggerType)triggerType, (long)triggerId);
        EventBindingCache.init((String)rc.getAccountId(), (Connection)cn);
        EventRegister.unRegister(cn, entity);
        CacheManager.removeEventCache(rc);
    }

    public static String[] convertEvents(String[] events) {
        HashSet<String> set = new HashSet<String>();
        for (String e : events) {
            String evt = D.s((Object)e);
            if ("_UPDATE".equals(evt) || "_INSERT".equals(evt)) {
                set.add("save");
                continue;
            }
            if (evt == null) continue;
            set.add(evt);
        }
        return set.toArray(new String[0]);
    }

    public static void checkTriggerContent(InitResult result, BatchTriggerInfo batchTrigger, List<EachTriggerInfo> triggers, List<Map<String, Object>> bindTriggers) {
        for (int i = 0; i < triggers.size(); ++i) {
            EachTriggerInfo eachTriggerInfo = triggers.get(i);
            Map<String, Object> record = bindTriggers.get(i);
            if (!D.s((Object)record.get("fisc_hub")).equals(batchTrigger.getIscHub())) {
                EventUtil.markIscHubDismatched(result);
            } else if (eachTriggerInfo.getTriggerId() != D.l((Object)record.get("ftrigger_id"))) {
                EventUtil.markTriggerOrderDismatched(result);
            } else if (!eachTriggerInfo.getEvents().equals(record.get("fevents"))) {
                EventUtil.markTriggerEventsDismatched(result, eachTriggerInfo, record);
            } else {
                EventUtil.markTriggerDataRequiresDismatched(result, eachTriggerInfo, record);
            }
            if (result.getStatus() != InitStatus.NEED_NOT_INIT) break;
        }
    }

    private static void markTriggerDataRequiresDismatched(InitResult result, EachTriggerInfo eachTriggerInfo, Map<String, Object> record) {
        String triggersMd5;
        String bindTriggersMd5 = Hash.md5((String)((String)record.get("frequired_fields")));
        if (!bindTriggersMd5.equals(triggersMd5 = Hash.md5((String)eachTriggerInfo.getRequires()))) {
            result.setStatus(InitStatus.NEED_INIT);
            result.setErrorStack(String.format(ResManager.loadKDString((String)"id\u4e3a%1$s\u7684\u4e8b\u4ef6\u542f\u52a8\u65b9\u6848\u7684\u6e90\u5b57\u6bb5\u4e0d\u4e00\u81f4,\u7ed1\u5b9a\u8868\u4e2d\u7684\u4e3a%2$s,\u82cd\u7a79\u7684\u4e3a%3$s,\u9700\u521d\u59cb\u5316", (String)"EventUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), eachTriggerInfo.getTriggerId(), record.get("frequired_fields"), eachTriggerInfo.getRequires()));
        }
    }

    private static void markTriggerEventsDismatched(InitResult result, EachTriggerInfo eachTriggerInfo, Map<String, Object> record) {
        String dbEvts = D.s((Object)record.get("fevents")).replace(" ", "");
        if (!eachTriggerInfo.getEvents().replace(" ", "").equals(dbEvts)) {
            result.setStatus(InitStatus.NEED_INIT);
            result.setErrorStack(String.format(ResManager.loadKDString((String)"id\u4e3a%1$s\u7684\u4e8b\u4ef6\u542f\u52a8\u65b9\u6848\u4e24\u8fb9\u76d1\u542c\u7684\u4e8b\u4ef6\u4e0d\u4e00\u81f4\uff0c\u9700\u521d\u59cb\u5316", (String)"EventUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), eachTriggerInfo.getTriggerId()));
        }
    }

    private static void markTriggerOrderDismatched(InitResult result) {
        result.setStatus(InitStatus.NEED_INIT);
        result.setErrorStack(ResManager.loadKDString((String)"\u4e24\u8fb9\u4e8b\u4ef6\u89e6\u53d1id\u6392\u5e8f\u540e\u4e0d\u4e00\u81f4\uff0c\u9700\u521d\u59cb\u5316", (String)"EventUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private static void markIscHubDismatched(InitResult result) {
        result.setStatus(InitStatus.NEED_INIT);
        result.setErrorStack(ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u5c5e\u4e8e\u8be5\u82cd\u7a79\u7684\u4e8b\u4ef6\u7ed1\u5b9a\u6570\u636e\uff0c\u9700\u521d\u59cb\u5316", (String)"EventUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public static void markTriggerCountNotEqual(InitResult result) {
        result.setStatus(InitStatus.NEED_INIT);
        result.setErrorStack(ResManager.loadKDString((String)"\u82e5\u5df2\u7ed1\u5b9a\u65b9\u6848\u7684\u6570\u91cf\u8ddf\u5df2\u6709\u65b9\u6848\u7684\u6570\u91cf\u4e0d\u76f8\u7b49\uff0c\u9700\u8981\u521d\u59cb\u5316", (String)"EventUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public static void eventRegister(BatchTriggerInfo batchTrigger, RequestContext rc) {
        List triggers = batchTrigger.getTriggers();
        for (EachTriggerInfo triggerInfo : triggers) {
            String entity = triggerInfo.getEntity();
            String[] s = triggerInfo.getEvents().replace(" ", "").split(",");
            String[] newEvents = EventUtil.convertEvents(s);
            EventRegister.register(entity, newEvents);
        }
        CacheManager.removeEventCache(rc);
    }

    public static void saveTriggerInfo(BatchTriggerInfo batchTrigger, Connection cn) {
        List triggers = batchTrigger.getTriggers();
        for (EachTriggerInfo triggerInfo : triggers) {
            EventBindingUtil.saveEvents((Connection)cn, (String)batchTrigger.getIscHub(), (String)triggerInfo.getEntity(), (EventBindingUtil.TriggerType)(triggerInfo.getTriggerType() != null ? triggerInfo.getTriggerType() : EventBindingUtil.TriggerType.DataCopyTrigger), (long)triggerInfo.getTriggerId(), (String[])triggerInfo.getEvents().replace(" ", "").split(","), (Map)((Map)Json.toObject((String)triggerInfo.getRequires())));
        }
    }
}

