/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.isc.iscb.platform.core.connector.WorkflowInfo;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public final class ExecuteWfUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WorkflowInfo> initiateWorkflow(String entity, String operation, List<String> idList, String proxyUser, Map<String, Object> extendInfo) {
        Map bizProcessStatus = WorkflowServiceHelper.getBizProcessStatus((String[])idList.toArray(new String[0]));
        RequestContext current = RequestContext.get();
        try {
            ContextUtil.restoreAndGetContext(current, proxyUser);
            for (String id : idList) {
                List statuses = (List)bizProcessStatus.get(id);
                if (statuses != null && statuses.size() > 0) continue;
                WorkflowServiceHelper.tryTriggerProcess((String)id, (String)operation, (String)entity, extendInfo);
            }
        }
        finally {
            RequestContextCreator.restoreForMQ((RequestContext)current);
        }
        return null;
    }

    public static List<WorkflowInfo> getStatusByIds(List<String> idList) {
        ArrayList<WorkflowInfo> list = new ArrayList<WorkflowInfo>(idList.size());
        for (String id : idList) {
            Map row = WorkflowServiceHelper.getProcessInstancePropertiesByBusinesskey((String)id);
            if (row == null) continue;
            WorkflowInfo info = new WorkflowInfo(D.s(row.get("processInstanceId")), D.s(row.get("name")), WorkflowInfo.State.valueOf(ExecuteWfUtil.getWfState(D.s(row.get("suspensionState")))), D.s(row.get("businessKey")), D.t(row.get("createDate")), null, D.s(row.get("procdefid")));
            list.add(info);
        }
        return list;
    }

    private static String getWfState(String state) {
        if (state == null) {
            return "Completed";
        }
        String value = null;
        switch (state) {
            case "1": {
                value = "Running";
                break;
            }
            case "2": {
                value = "Suspended";
                break;
            }
            case "3": {
                value = "Completed";
            }
        }
        return value;
    }

    public static List<WorkflowInfo> getWorkflowState(List<String> workflowInstanceIdList) {
        Connection conn = TX.getConnection((String)"wfs", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select fprocinstid processInstanceId,fbusinesskey businessKey,fprocdefid procdefid,fsuspensionstate suspensionState,fcreatedate createDate,fmodifydate,fname name  from t_wf_execution where fprocinstid in ";
            List<WorkflowInfo> list = ExecuteWfUtil.getWorkflowInfos(workflowInstanceIdList, conn, sql);
            if (list.isEmpty()) {
                sql = "SELECT fprocinstid processInstanceId,fbusinesskey businessKey,fprocdefid procdefid,fcreatedate createDate,fmodifydate,fname name,fendtime FROM t_wf_hiprocinst  where fprocinstid in ";
                list.addAll(ExecuteWfUtil.getWorkflowInfos(workflowInstanceIdList, conn, sql));
            }
            List<WorkflowInfo> list2 = list;
            return list2;
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)conn);
        }
    }

    private static List<WorkflowInfo> getWorkflowInfos(List<String> workflowInstanceIdList, Connection conn, String sql) {
        ArrayList<Object> values = new ArrayList<Object>(workflowInstanceIdList.size());
        ArrayList<Integer> types = new ArrayList<Integer>(workflowInstanceIdList.size());
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append(sql);
        ExecuteWfUtil.setFilter(workflowInstanceIdList, values, types, sqlStr);
        return ExecuteWfUtil.getWorkflowInfos(conn, values, types, sqlStr);
    }

    private static List<WorkflowInfo> getWorkflowInfos(Connection conn, List<Object> values, List<Integer> types, StringBuilder sqlStr) {
        List dataRows = DbUtil.executeList((Connection)conn, (String)sqlStr.toString(), values, types);
        ArrayList<WorkflowInfo> list = new ArrayList<WorkflowInfo>(dataRows.size());
        for (DataRow row : dataRows) {
            WorkflowInfo info = new WorkflowInfo(D.s((Object)row.get((Object)"processinstanceid")), D.s((Object)row.get((Object)"name")), WorkflowInfo.State.valueOf(ExecuteWfUtil.getWfState(D.s((Object)row.get((Object)"suspensionstate")))), D.s((Object)row.get((Object)"businesskey")), D.t((Object)row.get((Object)"createdate")), null, D.s((Object)row.get((Object)"procdefid")));
            list.add(info);
        }
        return list;
    }

    private static void setFilter(List<String> workflowInstanceIdList, List<Object> values, List<Integer> types, StringBuilder sqlStr) {
        sqlStr.append(" (");
        for (int i = 0; i < workflowInstanceIdList.size(); ++i) {
            if (i > 0) {
                sqlStr.append(',');
            }
            sqlStr.append('?');
            types.add(-5);
            values.add(D.l((Object)workflowInstanceIdList.get(i)));
        }
        sqlStr.append(')');
    }
}

