/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.isc.iscb.platform.core.connector.self.PushDataTask;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.trace.TraceTask;

public class PushDataConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(PushDataConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try (final Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);){
            Map args = (Map)body;
            final String eventId = D.s(args.get("id"));
            final String iscHub = D.s(args.get("isc_hub"));
            final String triggerId = D.s(args.get("trigger_id"));
            final String triggerType = D.s(args.get("trigger_type"));
            final String data = D.s(args.get("data"));
            TraceStack.trace(Caller.Event, new TraceTask(){

                public void run() {
                    PushDataTask.push(cn, data, iscHub, triggerType, triggerId, eventId);
                }
            });
            acker.ack(messageId);
        }
        catch (Exception e) {
            acker.discard(messageId);
            logger.warn("failed to push data, discard this message, content: " + Json.toString((Object)body, (boolean)true), (Throwable)e);
        }
    }
}

