/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.CacheManager;
import kd.isc.iscb.platform.core.connector.self.DynamicObjectReader;
import kd.isc.iscb.platform.core.connector.self.IscBizListener;
import kd.isc.iscb.platform.core.connector.self.PushDataJobHandler;
import kd.isc.iscb.platform.core.connector.self.RegisterOpActionQueueX;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class RegisterOpActionQueue {
    private static Log logger = LogFactory.getLog(RegisterOpActionQueue.class);

    private static boolean useBatchPusher() {
        String batch = System.getProperty(RequestContext.get().getTenantId() + "_ISC_BATCH_PUSHER_ENABLED");
        return "true".equals(batch);
    }

    public static void execute(String entityKey, String operationKey, DynamicObject[] objects) {
        String pkIds = "";
        try {
            List triggers;
            pkIds = RegisterOpActionQueue.getPkIds(objects);
            String info = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\uff1a%1$s\uff0c\u64cd\u4f5c\uff1a %2$s, ID[%3$s]", (String)"RegisterOpActionQueue_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityKey, operationKey, pkIds);
            RequestContext rc = RequestContext.get();
            if (!CacheManager.isInitialized(rc)) {
                IscBizListener.init();
            }
            if ((triggers = EventBindingCache.find((String)rc.getAccountId(), (String)entityKey, (String)operationKey)) == null || triggers.size() == 0) {
                logger.info("isc_event_log: \u6ca1\u6709\u5339\u914d\u7684\u4e8b\u4ef6\u89e6\u53d1\u65b9\u6848\uff0c\u6570\u636e\u5c06\u88ab\u5ffd\u7565\u3002" + info);
                return;
            }
            if (RegisterOpActionQueue.useBatchPusher()) {
                RegisterOpActionQueueX.saveBillData(entityKey, operationKey, objects, triggers);
            } else {
                RegisterOpActionQueue.saveBillData(entityKey, operationKey, objects, triggers);
            }
            if (!PushDataJobHandler.isMQType()) {
                PushDataJobHandler.dataArrived();
            }
            logger.info("isc_event_log: \u4e8b\u4ef6\u63a8\u9001\u5b8c\u6210\u3002" + info);
        }
        catch (Exception e) {
            logger.warn("isc_event_log: \u5355\u636e" + entityKey + "\u4e8b\u4ef6\u63a8\u9001\u5f02\u5e38\uff0cID[" + pkIds + "]\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
            throw D.e((Throwable)e);
        }
    }

    private static String getPkIds(DynamicObject[] objects) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(objects[i].getPkValue());
            if (i < 100) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    private static void saveBillData(String entityKey, String operationKey, DynamicObject[] objects, List<EventBindingCache.EventArgs> triggers) throws Exception {
        for (DynamicObject bo : objects) {
            for (EventBindingCache.EventArgs args : triggers) {
                bo = RegisterOpActionQueue.saveBillData(bo, entityKey, operationKey, args);
            }
        }
    }

    private static DynamicObject saveBillData(DynamicObject bo, String entityKey, String operationKey, EventBindingCache.EventArgs args) throws Exception {
        String data = null;
        String error = null;
        Object pkValue = bo.getPkValue();
        try {
            String entity = bo.getDynamicObjectType().getName();
            Map requires = args.getRequiredFields();
            Map<Object, Object> src = Collections.emptyMap();
            if (!operationKey.toUpperCase(Locale.ENGLISH).startsWith("DELETE")) {
                if (!CollectionUtils.isEmpty(requires)) {
                    src = DynamicObjectReader.read(entity, pkValue, (Map<String, Object>)requires);
                    if (src.isEmpty()) {
                        logger.warn("\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u5230\u7684\u5355\u636e\u4e3anull\uff0c\u5c06\u4fdd\u7559\u539f\u6709\u5355\u636e\u3002\u5355\u636e\u4fe1\u606f\u662f\uff1a" + entity + "\uff0c" + pkValue + "");
                    }
                } else {
                    bo = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
                }
            }
            if (src.isEmpty()) {
                src = DynamicObjectUtil.object2Map(bo, requires);
            }
            if (!CollectionUtils.isEmpty(requires) && requires.containsKey("$supports_file_copy")) {
                List<Map<String, Object>> attachmentList = AttachmentUtil.getAttachmentList(entity, pkValue);
                src.put("$file_list", attachmentList);
            }
            src.put("#EVENT", operationKey);
            RequestContext ctx = RequestContext.get();
            src.put("#UESR_ID", ctx.getCurrUserId());
            src.put("#USER_ID", ctx.getCurrUserId());
            src.put("#USER_NAME", ctx.getUserName());
            data = Json.toString(src);
        }
        catch (Throwable e) {
            error = StringUtil.toString((Throwable)e);
        }
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);){
            String id = EventBindingUtil.saveEventArgs((Connection)cn, (String)entityKey, (String)operationKey, (String)pkValue.toString(), (String)args.getIscHub(), (String)args.getTriggerType(), (String)args.getTriggerId(), data, (String)error);
            cn.commit();
            RegisterOpActionQueue.pushData(args, data, id);
        }
        return bo;
    }

    static void pushData(EventBindingCache.EventArgs args, String data, String id) {
        if (PushDataJobHandler.isMQType()) {
            PushDataJobHandler.pushMQ(id, args, data);
        }
    }
}

