/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.AbstractOutputStream;

public class SelfAttachmentOutputStream
extends AbstractOutputStream {
    private File tempFile;
    private OutputStream out;
    private Map<String, Object> attachInfo;
    private long attachId;

    SelfAttachmentOutputStream(File file, Map<String, Object> attachInfo) throws FileNotFoundException {
        this.out = new BufferedOutputStream(new FileOutputStream(file), 524288);
        this.attachId = IDService.get().genLongId();
        this.tempFile = file;
        this.attachInfo = attachInfo;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.out.close();
            try (FileInputStream input = new FileInputStream(this.tempFile);){
                AttachmentUtil.saveTempToFileServer(input, this.attachId, this.attachInfo, this.tempFile.getName(), this.tempFile.length());
            }
        }
        finally {
            FileUtil.delete(this.tempFile.getAbsolutePath());
        }
    }

    public String getAttachmentId() {
        return D.s((Object)this.attachId);
    }

    public void markError() {
    }
}

