/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;

public class TableInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> get(String fullname) {
        int i = fullname.indexOf(64);
        String table_name = i < 0 ? fullname : fullname.substring(0, i);
        String dbKey = i < 0 ? "ISCB" : fullname.substring(i + 1);
        Connection cn = TX.getConnection((String)dbKey, (boolean)true, (String[])new String[0]);
        try {
            Map<String, Object> map = TableInfo.getTableInfo(cn, table_name, fullname);
            return map;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private static Map<String, Object> getTableInfo(Connection cn, String table_name, String fullname) {
        HashMap<String, Object> tableInfo = new HashMap<String, Object>();
        tableInfo.put("name", fullname);
        tableInfo.put("table_name", fullname);
        tableInfo.put("type", "TABLE");
        tableInfo.put("full_name", fullname);
        tableInfo.put("title", table_name);
        Table table = new Table(cn, table_name, ' ');
        tableInfo.put("remark", table.getRemark());
        tableInfo.put("properties", TableInfo.getProperties(table));
        tableInfo.put("events", Collections.emptyList());
        tableInfo.put("actions", Collections.emptyList());
        return tableInfo;
    }

    private static Object getProperties(Table table) {
        ArrayList properties = new ArrayList(table.getFieldCount());
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Column c = table.getField(i);
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("name", c.getName());
            String label = c.getRealName();
            item.put("label", label);
            item.put("data_type", c.getDataType().toString());
            item.put("is_primary_key", c.isPrimaryKey());
            item.put("is_nullable", c.isNullable());
            item.put("remark", c.getRemark());
            properties.add(item);
        }
        return properties;
    }

    public static void initTableMapping() {
    }
}

