/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.self.serviceEvent;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.AccountEvent;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.OldAccountEvent;
import kd.isc.iscb.platform.core.connector.self.serviceEvent.ServiceEvent;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ServiceEventFactory {
    private static final Log logger = LogFactory.getLog(ServiceEventFactory.class);

    public static ServiceEvent create(String fullName) {
        String evtNumber = fullName.substring(fullName.lastIndexOf(47) + 1);
        if (fullName.startsWith("account_event://")) {
            return ServiceEventFactory.getServiceEvent(evtNumber);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5168\u540d\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u4e0d\u652f\u6301\u540c\u6b65\u5168\u540d\u4e3a%s\u7684\u52a0\u8f7d\u670d\u52a1", (String)"ServiceEventFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fullName));
    }

    private static ServiceEvent getServiceEvent(String evtNumber) {
        boolean isNewDataModel = false;
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"ExtDataModelService", (String)"isNewDataModel", (Object[])new Object[]{evtNumber});
            isNewDataModel = D.x((Object)result);
        }
        catch (Throwable t) {
            logger.warn("\u8c03\u7528\u5fae\u670d\u52a1\u5224\u65ad\u662f\u5426\u662f\u65b0\u6a21\u578b\u51fa\u73b0\u5f02\u5e38\uff0c\u73b0\u5728\u67e5\u8be2\u96c6\u6210\u4e91\u5e94\u7528\u53c2\u6570\uff08isc_app_params\uff09\u5224\u65ad\u4f1a\u8ba1\u4e8b\u4ef6\u5916\u90e8\u6a21\u578b\u7248\u672c\u3002fi.ai.ExtDataModelService.isNewDataModel\uff0c\u5f02\u5e38\u7684\u539f\u56e0\u662f\uff1a", t);
            Object syncAieventModel = AppParameterServiceHelper.getParameterFromCache("sync_aievent_model");
            if ("new_aievent".equals(syncAieventModel)) {
                return new AccountEvent(evtNumber);
            }
            return new OldAccountEvent(evtNumber);
        }
        if (isNewDataModel) {
            return new AccountEvent(evtNumber);
        }
        return new OldAccountEvent(evtNumber);
    }
}

