/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.sunftp;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ftp.FtpConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ftp.util.IscFtpException;
import kd.isc.iscb.platform.core.connector.ftp.util.PathInfo;
import kd.isc.iscb.platform.core.connector.sunftp.FtpUtil;
import kd.isc.iscb.util.misc.StringUtil;
import sun.net.ftp.FtpDirEntry;

public class FtpCommand {
    public static List<Map<String, Object>> list(FtpConnectionWrapper cn, String dirPath, FtpDirEntry.Type type) {
        FtpCommand.checkCn(cn);
        return FtpUtil.getFtpFileMap(cn, dirPath, type);
    }

    public static Object get(FtpConnectionWrapper cn, PathInfo pathInfo, String fileName, long restartOffset) {
        FtpCommand.checkCn(cn);
        FtpCommand.checkFileName(fileName);
        return cn.get(pathInfo, fileName, restartOffset);
    }

    public static boolean put(FtpConnectionWrapper cn, String dirPath, String fileName, Object fileContent, boolean isUpdate) {
        FtpCommand.checkCn(cn);
        FtpCommand.checkFileName(fileName);
        return FtpCommand.putFile(cn, dirPath, fileName, fileContent, isUpdate);
    }

    public static boolean delete(FtpConnectionWrapper cn, String dirPath, String fileName) {
        FtpCommand.checkCn(cn);
        FtpCommand.checkFileName(fileName);
        return cn.delete(PathInfo.getDirPath(dirPath) + fileName);
    }

    public static boolean rmdir(FtpConnectionWrapper cn, String dirPath) {
        FtpCommand.checkCn(cn);
        return cn.rmdir(dirPath);
    }

    public static boolean mkdir(FtpConnectionWrapper cn, String dirPath) {
        FtpCommand.checkCn(cn);
        return cn.mkdir(dirPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean putFile(FtpConnectionWrapper cn, String dirPath, String fileName, Object fileContent, boolean isUpdate) {
        if (fileContent instanceof InputStream) {
            return cn.put(dirPath, fileName, (InputStream)fileContent, isUpdate);
        }
        try (InputStream in = FtpUtil.getFileStream(fileContent);){
            boolean bl = cn.put(dirPath, fileName, in, isUpdate);
            return bl;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    private static void checkCn(FtpConnectionWrapper cn) {
        if (cn == null) {
            throw new IscFtpException(ResManager.loadKDString((String)"FTP\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpCommand_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private static void checkFileName(String fileName) {
        if (StringUtil.isEmpty((String)fileName)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpCommand_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }
}

