/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.sunftp;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ftp.util.FtpMode;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import sun.net.ftp.FtpClient;

public class FtpConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private final Charset charset;
    private final FtpMode mode;
    private int connectionTimeout = -1;
    private final FtpClient.TransferType transferType;

    public FtpConfig(DynamicObject cfg) {
        this.host = D.s((Object)cfg.get("server_ip"));
        this.port = D.i((Object)cfg.get("server_port"));
        this.user = D.s((Object)cfg.get("user"));
        this.password = D.s((Object)cfg.get("newpwd"));
        this.charset = FtpConfig.getCharset(cfg);
        String modeStr = D.s((Object)cfg.get("attr9"));
        FtpMode mode = FtpMode.Active;
        if (!StringUtil.isEmpty((String)modeStr)) {
            mode = FtpMode.valueOf(modeStr);
        }
        this.mode = mode;
        FtpClient.TransferType transferType = FtpClient.TransferType.BINARY;
        String transferTypeStr = D.s((Object)cfg.get("attr7"));
        if (!StringUtil.isEmpty((String)transferTypeStr)) {
            transferType = FtpClient.TransferType.valueOf(transferTypeStr);
        }
        this.transferType = transferType;
        this.connectionTimeout = 15000;
    }

    public static Charset getCharset(DynamicObject cfg) {
        String charsetStr = D.s((Object)cfg.get("charset"));
        Charset charset = StandardCharsets.UTF_8;
        if (!StringUtil.isEmpty((String)charsetStr)) {
            charset = Charset.forName(charsetStr);
        }
        return charset;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            return StandardCharsets.UTF_8;
        }
        return this.charset;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public FtpClient.TransferType getTransferType() {
        return this.transferType;
    }

    public FtpMode getMode() {
        return this.mode;
    }
}

