/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.webapi;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ExtensibleConnectionFactory;
import kd.isc.iscb.platform.core.connector.webapi.HttpConnectionWrapper;
import kd.isc.iscb.platform.core.connector.webapi.ReloginFunction;
import kd.isc.iscb.platform.core.connector.webapi.SessionCache;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.CompositeContext;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.context.MapContext;
import kd.isc.iscb.util.script.core.Identifier;

public class WebApiConnectionFactory
implements ExtensibleConnectionFactory {
    private Script loginScript;
    private Script invokeScript;
    private Script testScript;
    private Script refreshScript;
    private Map<String, Object> extensions;

    @Override
    public void bindScript(String loginScript, String refreshScript, String invokeScript, String testScript, String script_extension) {
        this.loginScript = Script.compile((String)loginScript);
        this.invokeScript = Script.compile((String)invokeScript);
        this.testScript = Script.compile((String)testScript);
        this.refreshScript = Script.compile((String)refreshScript);
        this.initExtensions(script_extension);
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Script getLoginScript() {
        return this.loginScript;
    }

    protected Script getInvokeScript() {
        return this.invokeScript;
    }

    protected Script getTestScript() {
        return this.testScript;
    }

    private void initExtensions(String script_extension) {
        if (script_extension == null) {
            this.extensions = Collections.emptyMap();
        } else {
            LinkedHashMap<String, Identifier> extensions = new LinkedHashMap<String, Identifier>();
            for (String c : script_extension.split(";")) {
                String cls = D.s((Object)c);
                if (cls == null) continue;
                Identifier obj = (Identifier)ReflectionUtil.newInstance((String)cls);
                extensions.put(obj.name(), obj);
            }
            this.extensions = Collections.unmodifiableMap(extensions);
        }
    }

    @Override
    public void test(ConnectionWrapper cn) {
        DynamicObject cfg = cn.getConfig();
        WebApiConnectionFactory.checkWebApiTestScript(cfg, this.getClass());
        Object session = SessionCache.getLoginInfo(cfg, this.loginScript, this.extensions);
        Map<String, Object> ctx = SessionCache.createContext(cfg, session, this.extensions);
        ctx.put("Relogin", new ReloginFunction(cn));
        this.testScript.eval(ctx);
    }

    public static void checkWebApiTestScript(DynamicObject cfg, Class<?> c) {
        String type = cfg.getString("database_type");
        DynamicObject connType = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_connection_type", (String)"factory_class, test_script_tag", (QFilter[])QFilterUtil.builder().put("number", "=", type).build());
        if (c.getCanonicalName().equals(connType.getString("factory_class")) && StringUtil.isEmpty((String)connType.getString("test_script_tag"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d4b\u8bd5\u811a\u672c\u4e3a\u7a7a", (String)"WebApiConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    public Script getRefreshScript() {
        return this.refreshScript;
    }

    @Override
    public Object callService(ConnectionWrapper cn, String service, Map<String, Object> params, String proxyUser) {
        try {
            DynamicObject cfg = cn.getConfig();
            Object session = SessionCache.getLoginInfo(cfg, this.loginScript, this.extensions);
            Map<String, Object> ctx = this.newContext(cfg, service, params, proxyUser, session);
            ctx.put("Relogin", new ReloginFunction(cn));
            return this.invokeScript.eval(ctx);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, cn);
            throw e;
        }
    }

    public Map<String, Object> generateCtx(DynamicObject cfg) {
        Object session = SessionCache.getLoginInfo(cfg, this.loginScript, this.extensions);
        return SessionCache.createContext(cfg, session, this.extensions);
    }

    private Map<String, Object> newContext(DynamicObject cfg, String service, Map<String, Object> params, String proxyUser, Object session) {
        Map<String, Object> ctx = SessionCache.createContext(cfg, session, this.extensions);
        if ("dynamic_url_enabled".equals(cfg.get("attr9"))) {
            service = this.transform(service, ctx, params);
        }
        ctx.put("$service", service);
        ctx.put("$params", params);
        ctx.put("$proxy_user", proxyUser);
        return ctx;
    }

    private String transform(String service, Map<String, Object> ctx, Map<String, Object> params) {
        int i = service.indexOf("#{");
        int j = service.indexOf(125);
        if (i <= 0 || i >= j) {
            return service;
        }
        CompositeContext sctx = new CompositeContext(new Context[]{new MapContext(params), new MapContext(ctx)});
        Format fm = Format.parse((String)service, new HashMap(1));
        return fm.translate((Context)sctx);
    }

    @Override
    public ConnectionWrapper create(DynamicObject cfg) {
        return new HttpConnectionWrapper(this, cfg);
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        return Collections.emptyMap();
    }

    @Override
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u83b7\u53d6\u5b9e\u4f53\u5143\u6570\u636e", (String)"WebApiConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u83b7\u53d6\u679a\u4e3e\u5143\u6570\u636e", (String)"WebApiConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u83b7\u53d6API\u5143\u6570\u636e", (String)"WebApiConnectionFactory_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u5b9e\u4f53\u67e5\u8be2", (String)"WebApiConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u5b9e\u4f53\u64cd\u4f5c", (String)"WebApiConnectionFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u6570\u636e\u8868\u67e5\u8be2", (String)"WebApiConnectionFactory_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u8c03\u7528\u6570\u636e\u5904\u7406\u7c7b", (String)"WebApiConnectionFactory_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u89e3\u9664\u4e8b\u4ef6\u7ed1\u5b9a", (String)"WebApiConnectionFactory_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u4e8b\u4ef6\u7ed1\u5b9a", (String)"WebApiConnectionFactory_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void deploy(ConnectionWrapper cn, String ierpServerURL, String adminPassword, PermissionMode mode) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u90e8\u7f72", (String)"WebApiConnectionFactory_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void pushPermission(ConnectionWrapper cn, Map<Object, Object> permission, String adminPassword) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"WebAPI\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u6388\u6743\u63a8\u9001", (String)"WebApiConnectionFactory_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public boolean supportsRemoteDeploy() {
        return false;
    }

    @Override
    public boolean supportsEvent() {
        return false;
    }

    @Override
    public void rePushEventData(ConnectionWrapper cn, List<Object> ids) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        return false;
    }

    static {
        Functions.init();
    }
}

