/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.consume.res;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ResConsumeItem {
    private final String entityType;
    private final String entityNummber;
    private final String res_remark;
    private AtomicLong totalTimeSpan;
    private AtomicInteger invokeTimes;

    public ResConsumeItem(String entityType, String entityNummber, String res_remark) {
        this.entityType = entityType;
        this.entityNummber = entityNummber;
        this.res_remark = res_remark;
        this.totalTimeSpan = new AtomicLong(0L);
        this.invokeTimes = new AtomicInteger(0);
    }

    public synchronized void recordOnce(long start) {
        this.invokeTimes.addAndGet(1);
        this.totalTimeSpan.addAndGet(System.currentTimeMillis() - start);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityNummber() {
        return this.entityNummber;
    }

    public String getResRemark() {
        return this.res_remark;
    }

    public long getTotalTimeSpan() {
        return this.totalTimeSpan.getAndSet(0L);
    }

    public long getInvokeTimes() {
        return this.invokeTimes.getAndSet(0);
    }
}

