/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content;

import java.sql.Connection;
import java.util.Collections;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.MatchItemBatchWriter;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.platform.core.content.job.ContentSearchJob;
import kd.isc.iscb.platform.core.content.searcher.ApiCallerEventSearcher;
import kd.isc.iscb.platform.core.content.searcher.ApiCallerMQSearcher;
import kd.isc.iscb.platform.core.content.searcher.ApiCallerTimerSearcher;
import kd.isc.iscb.platform.core.content.searcher.CustomFunctionSearcher;
import kd.isc.iscb.platform.core.content.searcher.DataCompSearcher;
import kd.isc.iscb.platform.core.content.searcher.DataCopySearcher;
import kd.isc.iscb.platform.core.content.searcher.DataCopyTriggerSearcher;
import kd.isc.iscb.platform.core.content.searcher.DataFlowResourceSearcher;
import kd.isc.iscb.platform.core.content.searcher.ExportFileSearcher;
import kd.isc.iscb.platform.core.content.searcher.ExportFileTriggerSearcher;
import kd.isc.iscb.platform.core.content.searcher.ExternalApiSearcher;
import kd.isc.iscb.platform.core.content.searcher.ImportFileSearcher;
import kd.isc.iscb.platform.core.content.searcher.MQBillDataPubSearcher;
import kd.isc.iscb.platform.core.content.searcher.MQBillDataSubSearcher;
import kd.isc.iscb.platform.core.content.searcher.MQPublisherSearcher;
import kd.isc.iscb.platform.core.content.searcher.MQSubscriberSearcher;
import kd.isc.iscb.platform.core.content.searcher.MetaSchemaSearcher;
import kd.isc.iscb.platform.core.content.searcher.ScriptApiSearcher;
import kd.isc.iscb.platform.core.content.searcher.ServiceFlowSearcher;
import kd.isc.iscb.platform.core.content.searcher.ValueConversionRuleSearcher;
import kd.isc.iscb.platform.core.content.searcher.WebApiSearcher;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.io.ObjectReader;

public enum ResourceType {
    isc_data_copy{

        @Override
        public ContentSearcher searcher() {
            return new DataCopySearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848", (String)"ResourceType_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_service_flow{

        @Override
        public ContentSearcher searcher() {
            return new ServiceFlowSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b", (String)"ResourceType_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_value_conver_rule{

        @Override
        public ContentSearcher searcher() {
            return new ValueConversionRuleSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219", (String)"ResourceType_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_data_copy_trigger{

        @Override
        public ContentSearcher searcher() {
            return new DataCopyTriggerSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848", (String)"ResourceType_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_metadata_schema{

        @Override
        public ContentSearcher searcher() {
            return new MetaSchemaSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61", (String)"ResourceType_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    iscx_resource{

        @Override
        public ContentSearcher searcher() {
            return new DataFlowResourceSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6570\u636e\u6d41\u8d44\u6e90", (String)"ResourceType_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_apic_script{

        @Override
        public ContentSearcher searcher() {
            return new ScriptApiSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49API", (String)"ResourceType_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_apic_for_external_api{

        @Override
        public ContentSearcher searcher() {
            return new ExternalApiSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edfAPI", (String)"ResourceType_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_apic_webapi{

        @Override
        public ContentSearcher searcher() {
            return new WebApiSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"WebAPI\u767b\u8bb0", (String)"ResourceType_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_custom_function{

        @Override
        public ContentSearcher searcher() {
            return new CustomFunctionSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u51fd\u6570", (String)"ResourceType_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_call_api_by_timer{

        @Override
        public ContentSearcher searcher() {
            return new ApiCallerTimerSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"API\u4efb\u52a1\uff08\u5b9a\u65f6\uff09", (String)"ResourceType_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_call_api_by_evt{

        @Override
        public ContentSearcher searcher() {
            return new ApiCallerEventSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"API\u4efb\u52a1\uff08\u4e8b\u4ef6\u89e6\u53d1\uff09", (String)"ResourceType_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_call_api_by_mq{

        @Override
        public ContentSearcher searcher() {
            return new ApiCallerMQSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"API\u4efb\u52a1\uff08MQ\uff09", (String)"ResourceType_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_mq_publisher{

        @Override
        public ContentSearcher searcher() {
            return new MQPublisherSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u5e03\u4e3b\u9898", (String)"ResourceType_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_mq_subscriber{

        @Override
        public ContentSearcher searcher() {
            return new MQSubscriberSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6d88\u606f\u8ba2\u9605\u4e3b\u9898", (String)"ResourceType_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_mq_bill_data_pub{

        @Override
        public ContentSearcher searcher() {
            return new MQBillDataPubSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u5355\u636e\u6d88\u606f\u53d1\u5e03", (String)"ResourceType_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_mq_bill_data_sub{

        @Override
        public ContentSearcher searcher() {
            return new MQBillDataSubSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u5355\u636e\u6d88\u606f\u8ba2\u9605", (String)"ResourceType_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_data_comp{

        @Override
        public ContentSearcher searcher() {
            return new DataCompSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u65b9\u6848", (String)"ResourceType_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_export_file{

        @Override
        public ContentSearcher searcher() {
            return new ExportFileSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u65b9\u6848", (String)"ResourceType_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_export_file_trigger{

        @Override
        public ContentSearcher searcher() {
            return new ExportFileTriggerSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4efb\u52a1", (String)"ResourceType_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }
    ,
    isc_import_file{

        @Override
        public ContentSearcher searcher() {
            return new ImportFileSearcher(this);
        }

        @Override
        public String getTitle() {
            return ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u65b9\u6848", (String)"ResourceType_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    };


    public void search(ContentSearchJob job) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            this.findMatchItems(cn, job);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            long l = DbUtil.executeCount((Connection)cn, (String)this.searcher().getQuerySql(), Collections.emptyList(), Collections.emptyList());
            return l;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findMatchItems(Connection cn, ContentSearchJob job) {
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)this.searcher().getQuerySql(), Collections.emptyList(), Collections.emptyList());
        try {
            this.innerFindMatchItems((ObjectReader<DataRow>)reader, job);
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    private void innerFindMatchItems(ObjectReader<DataRow> reader, ContentSearchJob job) {
        MatchItemBatchWriter writer = new MatchItemBatchWriter(2);
        DataRow data = (DataRow)reader.read();
        while (data != null) {
            SignalManager.checkCancelSignal();
            job.incCheckedCount();
            SearchItem item = this.searcher().convert(data, job.getKeyword());
            if (item.isMatched()) {
                writer.write(item);
                job.incMatchedCount();
            }
            data = (DataRow)reader.read();
        }
        writer.flush();
    }

    public abstract ContentSearcher searcher();

    public abstract String getTitle();
}

