/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.job;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.platform.core.content.job.ContentSearchJobFactory;
import kd.isc.iscb.platform.core.content.job.SubStepMonitor;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class ContentSearchJob
implements Job {
    public static final JobFactory FACTORY = new ContentSearchJobFactory();
    private long jobOwnerId;
    private String pageId;
    private String title;
    private String metaType;
    private String keyword;
    private String user;
    private List<ResourceType> resourceTypes;
    private volatile Map<String, SubStepMonitor> typeToMonitorMap;
    private volatile Phase phase;
    private volatile ResourceType checkingType;
    private AtomicLong total = new AtomicLong(0L);
    private AtomicLong checked = new AtomicLong(0L);
    private AtomicLong matched = new AtomicLong(0L);
    protected AtomicLong omitted = new AtomicLong(0L);

    public ContentSearchJob(long jobOwnerId, String title, String pageId, String metaType, String keyword) {
        this.jobOwnerId = jobOwnerId;
        this.pageId = pageId;
        this.title = title;
        this.metaType = D.s((Object)metaType);
        this.keyword = keyword;
        this.user = RequestContext.get().getUserName();
        this.resourceTypes = this.getResourceTypes();
        this.typeToMonitorMap = new ConcurrentHashMap<String, SubStepMonitor>(this.resourceTypes.size());
    }

    public ContentSearchJob(Map<?, ?> params, String title) {
        this.pageId = D.s(params.get("pageId"));
        this.keyword = D.s(params.get("keyword"));
        this.metaType = D.s(params.get("metaType"));
        this.jobOwnerId = D.l(params.get("jobOwnerId"));
        this.title = title;
        this.user = D.s(params.get("user"));
        this.resourceTypes = this.getResourceTypes();
        this.typeToMonitorMap = new ConcurrentHashMap<String, SubStepMonitor>(this.resourceTypes.size());
    }

    @Override
    public String getParam() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("pageId", this.pageId);
        params.put("metaType", this.metaType);
        params.put("keyword", this.keyword);
        params.put("jobOwnerId", this.jobOwnerId);
        params.put("user", this.user);
        return Json.toString(params);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    public String getKeyword() {
        return this.keyword;
    }

    private List<ResourceType> getResourceTypes() {
        if (this.metaType == null) {
            return Arrays.asList(ResourceType.values());
        }
        return Collections.singletonList(ResourceType.valueOf(this.metaType));
    }

    @Override
    public long getOwnerId() {
        return this.jobOwnerId;
    }

    @Override
    public void run() {
        this.deleteHistory();
        this.calcTotal();
        this.doSearch();
        this.markComplete();
    }

    private void markComplete() {
        this.setPhase(Phase.COMPLETE);
    }

    private void deleteHistory() {
        this.setPhase(Phase.DELETE_HISTORY);
        SearchUtil.clearMatchResultTable();
    }

    private void doSearch() {
        for (ResourceType type : this.resourceTypes) {
            SignalManager.checkCancelSignal();
            this.setPhase(Phase.SEARACH_EACH_TYPE);
            this.checkingType = type;
            type.search(this);
        }
    }

    private void calcTotal() {
        this.setPhase(Phase.CALC_TOTAL);
        for (ResourceType type : this.resourceTypes) {
            SubStepMonitor monitor = new SubStepMonitor(type);
            this.total.addAndGet(monitor.getTotal());
            this.typeToMonitorMap.put(type.name(), monitor);
        }
    }

    private void setPhase(Phase phase) {
        this.phase = phase;
    }

    public void incCheckedCount() {
        this.checked.incrementAndGet();
        this.getSubStepMonitor().incCheckedCount();
    }

    private SubStepMonitor getSubStepMonitor() {
        return this.typeToMonitorMap.get(this.checkingType.name());
    }

    public void incMatchedCount() {
        this.matched.incrementAndGet();
    }

    @Override
    public String getJobSummary() {
        return this.phase.generateSummary(this);
    }

    @Override
    public String refreshProgress() {
        return this.phase.generateSummary(this);
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        long totalCount = this.phase == Phase.COMPLETE ? this.checked.get() : this.total.get();
        return new Job.Progress(totalCount, this.checked.get(), this.phase.generateSummary(this));
    }

    private String getMainSummary() {
        String format = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u4f7f\u7528\u5173\u952e\u8bcd\u3010%2$s\u3011\u68c0\u7d22\u8d44\u6e90\uff0c%3$s/%4$s\uff0c \u5339\u914d\uff1a%5$s", (String)"ContentSearchJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.user, this.keyword, this.checked.get(), this.total, this.matched.get());
        return format + "\r\n";
    }

    private static enum Phase {
        DELETE_HISTORY{

            @Override
            String generateSummary(ContentSearchJob job) {
                return this.getDeleteHistoryDesc();
            }

            private String getDeleteHistoryDesc() {
                return ResManager.loadKDString((String)"\u6b63\u5728\u6e05\u7406\u5386\u53f2\u5185\u5bb9\u68c0\u7d22\u7ed3\u679c...", (String)"ContentSearchJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
        }
        ,
        CALC_TOTAL{

            @Override
            String generateSummary(ContentSearchJob job) {
                return this.getCalcTotalDesc();
            }

            private String getCalcTotalDesc() {
                return ResManager.loadKDString((String)"\u6b63\u5728\u8ba1\u7b97\u96c6\u6210\u8d44\u6e90\u603b\u6570...", (String)"ContentSearchJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
        }
        ,
        SEARACH_EACH_TYPE{

            @Override
            String generateSummary(ContentSearchJob job) {
                return job.getMainSummary() + job.getSubStepMonitor().getStepProgress();
            }
        }
        ,
        COMPLETE{

            @Override
            String generateSummary(ContentSearchJob job) {
                String s = ResManager.loadKDString((String)"\u5185\u5bb9\u68c0\u7d22\u5b8c\u6210", (String)"ContentSearchJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                return job.getMainSummary() + s;
            }
        };


        abstract String generateSummary(ContentSearchJob var1);
    }
}

