/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;

public class WebApiSearcher
implements ContentSearcher {
    private static final String URL_DEFAULT_VALUE = "select furl_param_value from t_iscb_web_url_params where fid = ?";
    private static final String HEAD_DEFAULT_VALUE = "select freq_h_param_value from t_iscb_web_req_header where fid = ?";
    private static final String BODY_DEFAULT_VALUE = "select freq_b_param_value from t_iscb_web_req_body where fid = ?";
    private Map<String, String> fieldMap;
    private ResourceType resourceType;

    public WebApiSearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(16);
        this.fieldMap.put("finvoke_script_tag", ResManager.loadKDString((String)"\u8bf7\u6c42\u811a\u672c", (String)"WebApiSearcher_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("furl_param_value", ResManager.loadKDString((String)"url\u53c2\u6570\u9ed8\u8ba4\u503c", (String)"WebApiSearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("freq_h_param_value", ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u53c2\u6570\u9ed8\u8ba4\u503c", (String)"WebApiSearcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("freq_b_param_value", ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u53c2\u6570\u9ed8\u8ba4\u503c", (String)"WebApiSearcher_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow data, String keyword) {
        long fid = D.l((Object)data.get((Object)"fid"));
        SearchItem searchItem = new SearchItem(this.resourceType, fid, keyword);
        this.searchUrlDefault(searchItem);
        this.searchHeadDefault(searchItem);
        this.searchBodyDefault(searchItem);
        searchItem.addLocation(data, "finvoke_script_tag");
        return searchItem;
    }

    private void searchBodyDefault(SearchItem searchItem) {
        List<DataRow> list = SearchUtil.query(BODY_DEFAULT_VALUE, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, "freq_b_param_value")) break;
        }
    }

    private void searchHeadDefault(SearchItem searchItem) {
        List<DataRow> list = SearchUtil.query(HEAD_DEFAULT_VALUE, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, "freq_h_param_value")) break;
        }
    }

    private void searchUrlDefault(SearchItem searchItem) {
        List<DataRow> list = SearchUtil.query(URL_DEFAULT_VALUE, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, "furl_param_value")) break;
        }
    }

    @Override
    public String getQuerySql() {
        return "select fid,fnumber,finvoke_script_tag from t_iscb_apic_webapi";
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }
}

