/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp;

import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.datacomp.DataCompInput;
import kd.isc.iscb.platform.core.datacomp.factory.StrategyFactory;
import kd.isc.iscb.platform.core.datacomp.param.DataCompParam;
import kd.isc.iscb.platform.core.datacomp.param.DataCompSchema;
import kd.isc.iscb.platform.core.datacomp.strategy.CompStrategy;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.task.TaskWorker;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;

public class DataCompRunner {
    private CompStrategy compStrategy;
    private DataCompParam param;
    private DataCompInput compInput;
    private volatile boolean running = true;
    private static final int MIN_BATCH = 50;
    private volatile Throwable lastError;
    private volatile TaskCancelException cancelSignal;
    private int subTaskCount = 0;
    private static final TaskWorker SUB_TASK_QUEUE = new TaskWorker("ISC_SUB_TASK_WORKER_CONTRAST", 32);

    DataCompRunner(DynamicObject execution) {
        DynamicObject comp = DataCompSchema.get(execution.getLong("data_comp_id"));
        DynamicObject schema = DataCopySchema.get(comp.getLong("data_copy_id"));
        this.param = new DataCompParam(execution, schema);
        this.compInput = new DataCompInput(this.param);
        this.compStrategy = this.getStrategy();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        String executionId = this.param.getExecutionId();
        try {
            SignalManager.registerBackTask(executionId);
            this.param.getDataCopyParam().getCounter().setStartTime(System.currentTimeMillis());
            this.compStrategy.init(this.compInput);
            this.startSubTasks();
            this.doMainTask();
            this.throwLastError();
        }
        finally {
            this.running = false;
            this.dispose();
            SignalManager.unregisterTask(executionId);
        }
    }

    private void doMainTask() {
        try {
            this.doComp();
        }
        catch (Throwable e) {
            this.lastError = e;
            if (e instanceof TaskCancelException) {
                this.cancelSignal = (TaskCancelException)e;
            }
        }
        finally {
            this.waitForSubTasks();
        }
    }

    private void doComp() {
        this.compStrategy.execute(this);
    }

    private void startSubTasks() {
        int count = this.param.getCounter().getTotal_count();
        if (count >= 0 && count <= 50) {
            return;
        }
        int max = 10;
        if (count > 0) {
            max = Math.min(max, (count + 50 - 1) / 50);
        }
        for (int i = 0; i < max; ++i) {
            SUB_TASK_QUEUE.submit(new SubTask());
        }
    }

    private void throwLastError() {
        Throwable e = this.lastError;
        if (e == null) {
            return;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw D.e((Throwable)e);
    }

    public DataCompParam getParam() {
        return this.param;
    }

    public void checkCancelSignal() {
        TaskCancelException e = this.cancelSignal;
        if (e != null) {
            throw e;
        }
        try {
            SignalManager.checkCancelSignal();
        }
        catch (TaskCancelException err) {
            this.cancelSignal = err;
            throw this.cancelSignal;
        }
    }

    private synchronized void incSubTaskCount() {
        ++this.subTaskCount;
        this.param.getDataCopyParam().getCounter().incThreadCount();
    }

    private synchronized void decSubTaskCount() {
        --this.subTaskCount;
        this.notifyAll();
    }

    private synchronized void waitForSubTasks() {
        while (this.subTaskCount > 0) {
            try {
                this.wait(1000L);
                try {
                    if (this.cancelSignal != null) continue;
                    SignalManager.checkCancelSignal();
                }
                catch (TaskCancelException err) {
                    this.cancelSignal = err;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void dispose() {
        this.compStrategy.dispose();
        this.compInput.dispose();
    }

    private CompStrategy getStrategy() {
        return StrategyFactory.getService(this.param.getStrategy());
    }

    private final class SubTask
    implements LightTask {
        private String id = UUID.randomUUID().toString();

        private SubTask() {
        }

        @Override
        public void run() {
            DataCompRunner.this.incSubTaskCount();
            try {
                DataCompRunner.this.doComp();
            }
            catch (Throwable e) {
                DataCompRunner.this.lastError = e;
            }
            finally {
                DataCompRunner.this.decSubTaskCount();
            }
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

