/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.datacomp.DataCompRunner;
import kd.isc.iscb.platform.core.datacomp.param.Counter;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;

public class DataCompTaskState
implements DaemonTask {
    protected static final int INTERVAL = 2;
    private DataCompRunner runner;
    private static Log logger = LogFactory.getLog(DataCompTaskState.class);

    DataCompTaskState(DataCompRunner runner) {
        this.runner = runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setStarting(long executionId, String state) {
        boolean bl;
        Connection cn = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = "UPDATE T_ISC_DATA_COMP_EXE SET fstart_time=?,  fend_time=null, fstate='R', fsource_count=-1, ftar_no_exist_count=-1,ftar_no_syn_count=-1, ftar_no_same_count=-1  WHERE fid= ? and fstate = ? ";
            List<Object> values = Arrays.asList(now, executionId, state);
            List<Integer> types = Arrays.asList(93, -5, 12);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            int i = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            bl = i == 1;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setWaiting(long executionId, String state) {
        boolean bl;
        Connection cn = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = "UPDATE T_ISC_DATA_COMP_EXE SET fmodifytime=?,  fend_time=null, fstate='W', fsource_count=0, ftar_no_exist_count=0,ftar_no_syn_count=0, ftar_no_same_count=0,  fexecute_count = fexecute_count + 1  WHERE fid= ? and fstate = ? ";
            List<Object> values = Arrays.asList(now, executionId, state);
            List<Integer> types = Arrays.asList(93, -5, 12);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setFailed(long executionId) {
        Connection cn = null;
        try {
            String sql = "UPDATE T_ISC_DATA_COMP_EXE SET fmodifytime=?,fstate='F' WHERE fid=" + executionId;
            List<Timestamp> values = Collections.singletonList(new Timestamp(System.currentTimeMillis()));
            List<Integer> types = Collections.singletonList(93);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            boolean bl = true;
            DbUtil.close((Connection)cn, (boolean)true);
            return bl;
        }
        catch (Exception e) {
            logger.warn("\u4fdd\u5b58\u5931\u8d25\u72b6\u6001\u5931\u8d25\uff1a", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtil.close(cn, (boolean)true);
        }
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void run() {
        if (this.runner.isRunning()) {
            this.refreshModifiedTime();
            ScheduleManager.submit((Task)this, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModifiedTime() {
        Counter c = this.runner.getParam().getCounter();
        if (c == null) {
            return;
        }
        Connection cn = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Timestamp endTime = DataCompTaskState.forcastEndTime(c);
            String sql = "UPDATE T_ISC_DATA_COMP_EXE SET fmodifytime=?,  fend_time=?, fsource_count=?, ftar_no_exist_count=?,ftar_no_syn_count=?, ftar_no_same_count=?  WHERE fstate = 'R' and  fid = " + this.runner.getParam().getExecutionId();
            List<Object> values = Arrays.asList(now, endTime, c.getTotal_count(), c.getNot_exist_count(), c.getNot_update_count(), c.getNot_same_count());
            List<Integer> types = Arrays.asList(93, 93, 4, 4, 4, 4);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        catch (Throwable e) {
            try {
                logger.warn(e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DbUtil.close(cn, (boolean)true);
            }
        }
        DbUtil.close((Connection)cn, (boolean)true);
    }

    private static Timestamp forcastEndTime(Counter counter) {
        long start = counter.getStartTime();
        long elapsed = System.currentTimeMillis() - counter.getStartTime();
        long total = counter.getTotal_count();
        long count = (long)counter.getFailed_count() + (long)counter.getSuccess_count();
        if (elapsed > 10000L && count > 0L) {
            return new Timestamp(start + elapsed * total / count);
        }
        return null;
    }
}

