/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.datacomp.DataCompRunner;
import kd.isc.iscb.platform.core.datacomp.DataCompTask;
import kd.isc.iscb.platform.core.datacomp.DataCompTaskState;
import kd.isc.iscb.platform.core.datacomp.factory.DataCompFactory;
import kd.isc.iscb.platform.core.datacomp.param.Counter;
import kd.isc.iscb.platform.core.datacomp.util.IProgressRefresher;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompThread
implements Job {
    private DynamicObject execution;
    private long executionId;
    private DataCompRunner runner;
    private String state = "C";
    private String number = "";
    private String title;
    public static final DataCompFactory FACTORY = new DataCompFactory();
    private String param;
    private static Log logger = LogFactory.getLog(DataCompThread.class);

    public DataCompThread(long taskId, IProgressRefresher refresher) {
        this.executionId = taskId;
        this.param = String.valueOf(this.executionId);
    }

    public String getId() {
        return String.valueOf(this.executionId);
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public DataCompThread(long executionId, String title) {
        this.executionId = executionId;
        this.param = String.valueOf(executionId);
        this.title = title;
    }

    public DataCompThread(long executionId) {
        this(executionId, ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4", (String)"DataCompThread_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public String refreshProgress() {
        Counter counter = this.getCounter();
        if (counter != null) {
            int successCount = counter.getSuccess_count();
            int failedCount = counter.getFailed_count();
            int notExistCount = counter.getNot_exist_count();
            int completed_count = successCount + failedCount + notExistCount;
            int total_count = counter.getTotal_count();
            int count = 0;
            if (this.runner.getParam().isFlag()) {
                count = completed_count / 2;
                if (completed_count == total_count) {
                    total_count += counter.getSyn_total_count();
                    count = completed_count + counter.getSyn_err_count() + counter.getSyn_suc_count();
                }
            }
            return count + "/" + total_count;
        }
        return "";
    }

    private Counter getCounter() {
        if (this.runner == null) {
            return null;
        }
        return this.runner.getParam().getCounter();
    }

    @Override
    public String getJobSummary() {
        Counter counter = this.getCounter();
        if (counter == null) {
            return "";
        }
        int srcTotal = counter.getTotal_count();
        int noExist = counter.getNot_exist_count();
        int noUpdate = counter.getNot_update_count();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u884c\u6570\uff1a%1$s; \u76ee\u6807\u5355\u7f3a\u5931\u884c\u6570\uff1a%2$s; \u76ee\u6807\u5355\u672a\u66f4\u65b0\u884c\u6570\uff1a%3$s\r\n", (String)"DataCompThread_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), srcTotal, noExist, noUpdate));
        if (this.runner.getParam().isFlag()) {
            int syn_total_count = counter.getSyn_total_count();
            int syn_suc_count = counter.getSyn_suc_count();
            int syn_err_count = counter.getSyn_err_count();
            sb.append(String.format(ResManager.loadKDString((String)"\u8865\u507f\u884c\u6570\uff1a%1$s; \u8865\u507f\u6210\u529f\u884c\u6570\uff1a%2$s; \u8865\u507f\u5931\u8d25\u884c\u6570\uff1a%3$s", (String)"DataCompThread_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), syn_total_count, syn_suc_count, syn_err_count));
        }
        return sb.toString();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        Counter counter = this.getCounter();
        if (counter == null) {
            return new Job.Progress(10000L, 0L, ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u8fdb\u884c\u4e2d...", (String)"DataCompThread_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        int successCount = counter.getSuccess_count();
        int failedCount = counter.getFailed_count();
        int notExistCount = counter.getNot_exist_count();
        int completed_count = successCount + failedCount + notExistCount;
        int total_count = counter.getTotal_count();
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u8fdb\u884c\u4e2d...", (String)"DataCompThread_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        int count = completed_count;
        if (this.runner.getParam().isFlag()) {
            count = completed_count / 2;
            if (completed_count == total_count) {
                desc = ResManager.loadKDString((String)"\u6570\u636e\u8865\u507f\u8fdb\u884c\u4e2d...", (String)"DataCompThread_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                total_count += counter.getSyn_total_count();
                count = completed_count + counter.getSyn_err_count() + counter.getSyn_suc_count();
            }
        }
        return new Job.Progress(total_count == 0 ? 10000L : (long)total_count, count, desc);
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4_%s", (String)"DataCompThread_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param);
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        try (DLock lock = DLock.create((String)("/isc/iscb/data_comp/" + this.executionId)).fastMode();){
            if (lock.tryLock()) {
                this.doDataComp();
            } else {
                this.delay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParsed(long id, String state, String remark) {
        String sql = "UPDATE t_isc_job_inst SET fstate=?, fremark=? WHERE fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(state, StringUtil.trim((String)remark, (int)255), id), Arrays.asList(12, 12, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void doDataComp() {
        try {
            this.init();
            this.doJob();
            this.setParsed(this.executionId, "COMPLETE", ResManager.loadKDString((String)"\u5bf9\u6bd4\u5b8c\u6210\u3002\u3002\u3002", (String)"DataCompThread_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            if (e instanceof TaskCancelException) {
                this.setParsed(this.executionId, "TERMINATED", ResManager.loadKDString((String)"\u5bf9\u6bd4\u64a4\u9500\u3002\u3002\u3002", (String)"DataCompThread_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            } else {
                this.setParsed(this.executionId, "FAILED", ResManager.loadKDString((String)"\u5bf9\u6bd4\u5931\u8d25\u3002\u3002\u3002", (String)"DataCompThread_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                this.handleUnexpectedError(e);
            }
            throw e;
        }
    }

    private void doJob() {
        if (DataCompTaskState.setStarting(this.executionId, this.state)) {
            this.execute();
        }
    }

    private void delay() {
        try {
            if (this.setWaiting()) {
                this.reschedule();
            }
        }
        catch (Throwable e) {
            this.handleUnexpectedError(e);
        }
    }

    private void handleUnexpectedError(Throwable e) {
        logger.warn("data_comp_exection_unexpected_failure. id=" + this.executionId + ", number=" + this.number, e);
        if (!DataCompTaskState.setFailed(this.executionId)) {
            DataCompThread.asyncTrySetFailed(this.executionId, this.execution, e);
        }
    }

    private void execute() {
        ScheduleManager.submit((Task)new DataCompTaskState(this.runner), 2);
        try {
            this.runner.run();
            DataCompTask.setSuccess(this.runner.getParam());
        }
        catch (Throwable error) {
            this.errorHandle(this.execution, this.runner, error);
            throw error;
        }
    }

    private void init() {
        if (this.runner == null) {
            this.execution = BusinessDataServiceHelper.loadSingle((Object)this.executionId, (String)"isc_data_comp_exe");
            this.number = this.execution.getString("number");
            this.runner = new DataCompRunner(this.execution);
        }
    }

    private void errorHandle(DynamicObject execution, DataCompRunner runner, Throwable error) {
        DataCompTask.saveErrorLog(runner.getParam(), error, null, null, null, null);
        DataCompTask.setFailed(runner.getParam(), error, true);
    }

    private static void asyncTrySetFailed(final long executionId, DynamicObject execution, Throwable error) {
        ScheduleManager.submit((Task)new LightTask(){
            private String id = UUID.randomUUID().toString();

            @Override
            public void run() {
                DataCompTaskState.setFailed(executionId);
            }

            @Override
            public String getId() {
                return this.id;
            }
        }, 3);
    }

    private void reschedule() {
        long scheduledTime = System.currentTimeMillis() + 15000L;
        JobEngine.submit(this, new Timestamp(scheduledTime));
    }

    private boolean setWaiting() {
        if (DataCompTaskState.setWaiting(this.executionId, this.state)) {
            this.state = "W";
            return true;
        }
        return false;
    }

    public String toString() {
        return D.s((Object)(this.execution == null ? Long.valueOf(this.executionId) : this.execution.get("number")));
    }
}

