/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp.param;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.datacomp.param.Counter;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.data.ValueRange;

public class DataCompParam {
    private static final String FILTER_VALUE_VAR = "filter_value_var";
    private static final String FILTER_VALUE_FIXED = "filter_value_fixed";
    private static final String FILTER_LINK = "filter_link";
    private static final String FILTER_RIGHT_BRACKET = "filter_right_bracket";
    private static final String FILTER_VALUE = "filter_value";
    private static final String FILTER_LEFT_BRACKET = "filter_left_bracket";
    private static final String FILTER_COMPARE = "filter_compare";
    private static final String FILTER_COLUMN = "filter_column";
    private DataCopyParam dataCopyParam;
    private DynamicObject execution;
    private Counter counter = new Counter();
    private Pair<String, String> tarTsField;
    private Pair<String, String> srcTsField;
    private String tsExpr;
    private DynamicObject compensateSchema;
    private boolean flag;
    private List<String> srcList;
    private List<String> tarList;

    private DataCompParam(DynamicObject schema) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("datacomp", "1");
        this.dataCopyParam = new DataCopyParam(schema, map);
    }

    public DataCompParam(DynamicObject execution, DynamicObject schema) {
        this(schema);
        this.execution = execution;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public DataCopyParam getDataCopyParam() {
        return this.dataCopyParam;
    }

    private Map<String, Object> getFilterParams() {
        DynamicObjectCollection filterEntry = this.execution.getDynamicObjectCollection("params_entryentity");
        HashMap<String, Object> params = new HashMap<String, Object>(filterEntry.size());
        for (DynamicObject object : filterEntry) {
            params.put(object.getString("param_name"), object.get("param_value"));
        }
        return params;
    }

    public List<Map<String, Object>> prepareFilter() {
        DynamicObject comp;
        DynamicObjectCollection filter_entries;
        Map<String, Object> params = this.getFilterParams();
        List<Map<String, Object>> filter = this.prepareFilter(params, filter_entries = (DynamicObjectCollection)(comp = BusinessDataServiceHelper.loadSingle((Object)this.execution.getLong("data_comp_id"), (String)"isc_data_comp")).get("data_scope"));
        return filter.isEmpty() ? Collections.emptyList() : filter;
    }

    private List<Map<String, Object>> prepareFilter(Map<String, Object> params, DynamicObjectCollection filter_entries) {
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>();
        for (DynamicObject obj : filter_entries) {
            Object filter_column = obj.get(FILTER_COLUMN);
            Object compare = obj.get(FILTER_COMPARE);
            Object value = this.parseFilterValue(params, obj);
            this.checkFilterValue(filter_column, compare, value);
            if (value instanceof ValueRange) {
                this.handleValueRange(filter, obj, filter_column, (ValueRange)value);
                continue;
            }
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(FILTER_LEFT_BRACKET, obj.get(FILTER_LEFT_BRACKET));
            item.put(FILTER_COLUMN, filter_column);
            item.put(FILTER_COMPARE, compare);
            item.put(FILTER_VALUE, value);
            item.put(FILTER_RIGHT_BRACKET, obj.get(FILTER_RIGHT_BRACKET));
            item.put(FILTER_LINK, obj.get(FILTER_LINK));
            filter.add(item);
        }
        return filter;
    }

    private Object parseFilterValue(Map<String, Object> params, DynamicObject obj) {
        Object value = obj.get(FILTER_VALUE_FIXED);
        value = this.getFilterValue(params, obj, value);
        value = ExprEvaluator.calc(value, this.dataCopyParam, null, null);
        return value;
    }

    private Object getFilterValue(Map<String, Object> params, DynamicObject obj, Object value) {
        if (D.s((Object)value) != null) {
            return value;
        }
        String filter_value_var = obj.getString(FILTER_VALUE_VAR);
        return params.get(filter_value_var);
    }

    private void checkFilterValue(Object filter_column, Object compare, Object value) {
        if (value == null && !"IS_NULL".equals(compare) && !"IS_NOT_NULL".equals(compare)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5(%s)\u6ca1\u6709\u8bbe\u7f6e\u6bd4\u8f83\u503c\uff01", (String)"DataCompParam_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter_column));
        }
    }

    private void handleValueRange(List<Map<String, Object>> filter, DynamicObject obj, Object filter_column, ValueRange<?> value) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        String leftBracket = D.s((Object)obj.get(FILTER_LEFT_BRACKET));
        String rightBracket = D.s((Object)obj.get(FILTER_RIGHT_BRACKET));
        item.put(FILTER_LEFT_BRACKET, leftBracket == null ? "(" : "(" + leftBracket);
        item.put(FILTER_COLUMN, filter_column);
        item.put(FILTER_COMPARE, ">=");
        item.put(FILTER_VALUE, value.getLBound());
        item.put(FILTER_LINK, "AND");
        filter.add(item);
        item = new HashMap();
        item.put(FILTER_COLUMN, filter_column);
        item.put(FILTER_COMPARE, "<=");
        item.put(FILTER_VALUE, value.getUBound());
        item.put(FILTER_RIGHT_BRACKET, rightBracket == null ? ")" : rightBracket + ")");
        item.put(FILTER_LINK, obj.get(FILTER_LINK));
        filter.add(item);
    }

    public String getExecutionId() {
        return this.execution.getString("id");
    }

    public String getStrategy() {
        return this.execution.getString("strategy");
    }

    private void getCompExpr() {
        DynamicObject comp = BusinessDataServiceHelper.loadSingle((Object)this.execution.getLong("data_comp_id"), (String)"isc_data_comp");
        String src_ts_field = comp.getString("src_ts_field");
        String tar_ts_field = comp.getString("tar_ts_field");
        this.tarTsField = this.getCompField(tar_ts_field);
        this.tsExpr = comp.getString("ts_expr");
        this.srcTsField = this.getCompField(src_ts_field);
    }

    private void initSynParam() {
        DynamicObject comp = BusinessDataServiceHelper.loadSingle((Object)this.execution.getLong("data_comp_id"), (String)"isc_data_comp");
        this.compensateSchema = comp.getDynamicObject("trigger");
        this.flag = comp.getBoolean("auto_compensate");
    }

    private Pair<String, String> getCompField(String tar_ts_field) {
        int index1 = tar_ts_field.indexOf(40);
        String tarField = tar_ts_field.substring(0, index1);
        String tarType = tar_ts_field.substring(index1, tar_ts_field.indexOf(41));
        return new Pair((Object)tarField, (Object)tarType);
    }

    public DynamicObject getCompensateSchema() {
        if (this.compensateSchema == null) {
            this.initSynParam();
        }
        return this.compensateSchema;
    }

    public boolean isFlag() {
        if (this.compensateSchema == null) {
            this.initSynParam();
        }
        return this.flag;
    }

    public Pair<String, String> getSrcTsField() {
        if (this.srcTsField == null) {
            this.getCompExpr();
        }
        return this.srcTsField;
    }

    public Pair<String, String> getTarTsField() {
        if (this.tarTsField == null) {
            this.getCompExpr();
        }
        return this.tarTsField;
    }

    public String getTsExpress() {
        if (this.tsExpr == null) {
            this.getCompExpr();
        }
        return this.tsExpr;
    }

    public List<String> getSourceJudgeFields() {
        return this.getDataCopyParam().getSourceJudgeFields();
    }

    public List<String> getJudgeFields() {
        return this.getDataCopyParam().getJudgeFields();
    }

    public List<String> getSrcFieldsForUpdate() {
        if (this.srcList == null) {
            this.srcList = new ArrayList<String>();
            this.srcList.addAll(this.getSourceJudgeFields());
            this.srcList.add((String)this.getSrcTsField().getA());
        }
        return this.srcList;
    }

    public List<String> getTarFieldsForUpdate() {
        if (this.tarList == null) {
            this.tarList = new ArrayList<String>();
            this.tarList.addAll(this.getJudgeFields());
            this.tarList.add((String)this.getTarTsField().getA());
        }
        return this.tarList;
    }
}

