/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp.strategy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.datacomp.DataCompInput;
import kd.isc.iscb.platform.core.datacomp.DataCompRunner;
import kd.isc.iscb.platform.core.datacomp.param.Counter;
import kd.isc.iscb.platform.core.datacomp.strategy.CompStrategy;
import kd.isc.iscb.platform.core.datacomp.util.CompUtil;
import kd.isc.iscb.platform.core.datacomp.util.ResultType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;

public class CheckExistStrategy
implements CompStrategy {
    private ObjectReader<Map<String, Object>> srcReader = null;
    private DataCompInput input;
    private static final int BATCH_SIZE = 500;

    @Override
    public void init(DataCompInput input) {
        this.input = input;
        this.srcReader = input.getSrcReader(input.getParam().prepareFilter(), input.getParam().getSourceJudgeFields());
        this.getCounter().setTotal_count(this.srcReader.getTotalCount());
    }

    @Override
    public void execute(DataCompRunner runner) {
        LinkedList<Pair<Map<String, Object>, Map<String, Object>>> buffer = new LinkedList<Pair<Map<String, Object>, Map<String, Object>>>();
        List<String> tarCandidateKey = this.input.getParam().getJudgeFields();
        int size = tarCandidateKey.size();
        Map<String, Object> src = this.readSource();
        while (src != null) {
            try {
                runner.checkCancelSignal();
                this.executeComp(buffer, tarCandidateKey, size, src);
            }
            catch (Throwable e) {
                CompUtil.saveCompLog(this.input, src, null, null, ResultType.exist, e);
                throw D.e((Throwable)e);
            }
            src = this.readSource();
        }
        if (!buffer.isEmpty()) {
            this.batchDataComp(buffer, tarCandidateKey);
        }
    }

    private void executeComp(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, List<String> tarCandidateKey, int size, Map<String, Object> src) throws TaskCancelException {
        if (CompUtil.isIgnored(src)) {
            return;
        }
        Map<String, Object> tmpTar = this.input.getMapping().translateJudgeFieldsOnly(src);
        if (size == 1) {
            buffer.add((Pair<Map<String, Object>, Map<String, Object>>)new Pair(src, tmpTar));
            if (buffer.size() == 500) {
                this.batchDataComp(buffer, tarCandidateKey);
            }
        } else if (size > 1) {
            this.singleDataComp(src, tmpTar, tarCandidateKey);
        }
    }

    private void singleDataComp(Map<String, Object> src, Map<String, Object> tmpTar, List<String> tarCandidateKey) {
        ObjectReader<Map<String, Object>> tarReader = null;
        int count = 0;
        try {
            List<Map<String, Object>> filter = CompUtil.assignTarCandidateKey(tmpTar, tarCandidateKey);
            tarReader = this.input.getTarReader(filter, tarCandidateKey);
            count = tarReader.getTotalCount();
            if (count < 1) {
                this.getCounter().incNotExistCount(1);
                CompUtil.saveCompLog(this.input, src, null, tmpTar, ResultType.exist, null);
            }
            this.getCounter().incSuccessCount(count);
        }
        catch (Throwable e) {
            this.getCounter().incFailedCount(count);
            CompUtil.saveCompLog(this.input, src, null, tmpTar, ResultType.exist, e);
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close(tarReader);
        }
    }

    private void batchDataComp(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, List<String> tarCandidateKey) {
        ObjectReader<Map<String, Object>> tarReader = null;
        int count = 0;
        try {
            String tarCandidateKey1 = tarCandidateKey.get(0);
            List<Map<String, Object>> filterMap = CompUtil.batchFilter(buffer, tarCandidateKey1);
            tarReader = this.input.getTarReader(filterMap, tarCandidateKey);
            count = tarReader.getTotalCount();
            if (count != buffer.size()) {
                this.compData(buffer, tarReader, tarCandidateKey1);
            } else {
                buffer.clear();
            }
            this.getCounter().incSuccessCount(count);
        }
        catch (Throwable e) {
            this.getCounter().incFailedCount(count);
            CompUtil.saveCompLogs(this.input, buffer, null, ResultType.exist, e);
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close(tarReader);
        }
    }

    private void compData(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, ObjectReader<Map<String, Object>> tarReader, String tarCandidateKey) {
        Object key;
        Iterator<Pair<Map<String, Object>, Map<String, Object>>> it = buffer.iterator();
        HashMap<String, Object> srcMap = new HashMap<String, Object>(buffer.size());
        HashMap<Object, Map<String, Object>> expMap = new HashMap<Object, Map<String, Object>>(buffer.size());
        while (it.hasNext()) {
            Pair<Map<String, Object>, Map<String, Object>> pair = it.next();
            Map tmpTar = (Map)pair.getB();
            key = tmpTar.get(tarCandidateKey);
            if (srcMap.containsKey(key)) {
                IscBizException err = new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\uff08%s\uff09\u5728\u6e90\u5355\u4e2d\u53ef\u80fd\u5b58\u5728\u91cd\u590d\u6570\u636e\u884c\u3002", (String)"CheckExistStrategy_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
                err.setStackTrace(new StackTraceElement[0]);
                CompUtil.saveCompLog(this.input, (Map)pair.getA(), null, null, null, err);
                this.getCounter().incDuplicateCount(1);
            } else {
                if (!this.isSupportedKeyType(key)) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u7684\u5019\u9009\u952e\uff08%1$s\uff09\u7684\u6570\u636e\u7c7b\u578b(%2$s)\u5728\u6570\u636e\u5bf9\u6bd4\u4e2d\u4e0d\u652f\u6301\u3002", (String)"CheckExistStrategy_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key, key.getClass().getName()));
                }
                srcMap.put(D.s((Object)key), pair.getA());
                expMap.put(D.s((Object)key), tmpTar);
            }
            it.remove();
        }
        Map<String, Object> tar = this.input.readTarget(tarReader);
        while (tar != null) {
            key = tar.get(tarCandidateKey);
            srcMap.remove(D.s((Object)key));
            expMap.remove(D.s((Object)key));
            tar = this.input.readTarget(tarReader);
        }
        if (!srcMap.isEmpty()) {
            CompUtil.saveCompLogs(this.input, srcMap, expMap, ResultType.exist, null);
            this.getCounter().incNotExistCount(srcMap.size());
        }
    }

    private boolean isSupportedKeyType(Object key) {
        if (key instanceof String || key instanceof Long || key instanceof BigInteger || key instanceof Integer || key instanceof Short || key instanceof Byte) {
            return true;
        }
        return key instanceof BigDecimal && ((BigDecimal)key).scale() == 0;
    }

    private Counter getCounter() {
        return this.input.getParam().getCounter();
    }

    private Map<String, Object> readSource() {
        return this.input.readSource(this.srcReader);
    }

    @Override
    public void dispose() {
        DbUtil.close(this.srcReader);
    }
}

