/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp.strategy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.datacomp.DataCompInput;
import kd.isc.iscb.platform.core.datacomp.DataCompRunner;
import kd.isc.iscb.platform.core.datacomp.param.Counter;
import kd.isc.iscb.platform.core.datacomp.strategy.CompStrategy;
import kd.isc.iscb.platform.core.datacomp.util.CompUtil;
import kd.isc.iscb.platform.core.datacomp.util.ResultType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Script;

public class CheckUpdateStrategy
implements CompStrategy {
    private ObjectReader<Map<String, Object>> srcReader = null;
    private DataCompInput input;
    private static final int BATCH_SIZE = 500;
    private Script script;
    private List<String> tarList;
    private List<String> tarCandidateKey;

    @Override
    public void init(DataCompInput input) {
        this.input = input;
        this.tarList = input.getParam().getTarFieldsForUpdate();
        this.srcReader = input.getSrcReader(input.getParam().prepareFilter(), input.getParam().getSrcFieldsForUpdate());
        this.getCounter().setTotal_count(this.srcReader.getTotalCount());
        this.script = Script.compile((String)input.getParam().getTsExpress());
        this.tarCandidateKey = input.getParam().getJudgeFields();
    }

    private Counter getCounter() {
        return this.input.getParam().getCounter();
    }

    @Override
    public void execute(DataCompRunner runner) {
        LinkedList<Pair<Map<String, Object>, Map<String, Object>>> buffer = new LinkedList<Pair<Map<String, Object>, Map<String, Object>>>();
        int size = this.tarCandidateKey.size();
        Map<String, Object> src = this.readSource();
        while (src != null) {
            try {
                runner.checkCancelSignal();
                if (!CompUtil.isIgnored(src)) {
                    this.doComp(buffer, size, src);
                }
            }
            catch (Throwable e) {
                CompUtil.saveCompLog(this.input, src, null, null, ResultType.update, e);
                throw D.e((Throwable)e);
            }
            src = this.readSource();
        }
        if (!buffer.isEmpty()) {
            this.batchDataComp(buffer);
        }
    }

    private Map<String, Object> doComp(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, int size, Map<String, Object> src) {
        Map<String, Object> tmpTar = this.input.getMapping().translateByAppointedField(src, this.tarList);
        if (size == 1) {
            buffer.add((Pair<Map<String, Object>, Map<String, Object>>)new Pair(src, tmpTar));
            if (buffer.size() == 500) {
                this.batchDataComp(buffer);
            }
        } else if (size > 1) {
            this.singleDataComp(src, tmpTar);
        }
        return tmpTar;
    }

    private void singleDataComp(Map<String, Object> src, Map<String, Object> tmpTar) {
        ObjectReader<Map<String, Object>> tarReader = null;
        int count = 0;
        try {
            List<Map<String, Object>> filter = CompUtil.assignTarCandidateKey(tmpTar, this.tarCandidateKey);
            tarReader = this.input.getTarReader(filter, this.tarList);
            count = tarReader.getTotalCount();
            if (count < 1) {
                this.getCounter().incNotExistCount(1);
                CompUtil.saveCompLog(this.input, src, null, tmpTar, ResultType.exist, null);
            } else {
                Map<String, Object> target = this.input.readTarget(tarReader);
                this.compUpdate(src, target, tmpTar);
            }
            this.getCounter().incSuccessCount(count);
        }
        catch (Throwable e) {
            this.getCounter().incFailedCount(count);
            CompUtil.saveCompLog(this.input, src, null, tmpTar, ResultType.update, e);
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close(tarReader);
        }
    }

    private void compUpdate(Map<String, Object> src, Map<String, Object> target, Map<String, Object> expTar) {
        block6: {
            Pair<String, String> tarTsField;
            Pair<String, String> srcTsField = this.input.getParam().getSrcTsField();
            if (this.getTsType(srcTsField).contains("date")) {
                String tsFiled = this.getTsFiled(srcTsField);
                Object o = src.get(tsFiled);
                src.put(tsFiled, D.t((Object)o));
            }
            if (this.getTsType(tarTsField = this.input.getParam().getTarTsField()).contains("date")) {
                String tsFiled = this.getTsFiled(tarTsField);
                Object o = target.get(tsFiled);
                target.put(tsFiled, D.t((Object)o));
            }
            LinkedHashMap<String, Map<String, Object>> ctx = new LinkedHashMap<String, Map<String, Object>>(3);
            ctx.put("src", src);
            ctx.put("tar", target);
            try {
                Object eval = this.script.eval(ctx);
                if (eval instanceof Boolean) {
                    if (!D.x((Object)eval)) {
                        CompUtil.saveCompLog(this.input, src, target, expTar, ResultType.update, null);
                        this.getCounter().incNotUpdateCount(1);
                    }
                    break block6;
                }
                throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f", (String)"CheckUpdateStrategy_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            catch (Exception e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6267\u884c\u8fc7\u7a0b\u53d1\u751f\u9519\u8bef,\u8868\u8fbe\u5f0f\u4e3a\uff1a%s", (String)"CheckUpdateStrategy_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.input.getParam().getTsExpress()) + "\n" + String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\uff1a%s", (String)"CheckUpdateStrategy_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ctx), (Throwable)e);
            }
        }
    }

    private String getTsFiled(Pair<String, String> tarTsField) {
        return (String)tarTsField.getA();
    }

    private String getTsType(Pair<String, String> srcTsField) {
        return (String)srcTsField.getB();
    }

    private void batchDataComp(List<Pair<Map<String, Object>, Map<String, Object>>> buffer) {
        ObjectReader<Map<String, Object>> tarReader = null;
        int count = 0;
        try {
            String tarCandidateKey1 = this.tarCandidateKey.get(0);
            List<Map<String, Object>> filterMap = CompUtil.batchFilter(buffer, this.tarCandidateKey.get(0));
            tarReader = this.input.getTarReader(filterMap, this.tarList);
            count = tarReader.getTotalCount();
            this.compData(buffer, tarReader, tarCandidateKey1);
            this.getCounter().incSuccessCount(count);
        }
        catch (Throwable e) {
            this.getCounter().incFailedCount(count);
            CompUtil.saveCompLogs(this.input, buffer, null, ResultType.update, e);
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close(tarReader);
        }
    }

    private void compData(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, ObjectReader<Map<String, Object>> tarReader, String tarCandidateKey) {
        HashMap srcMap = new HashMap(buffer.size());
        HashMap<Object, Map<String, Object>> expMap = new HashMap<Object, Map<String, Object>>(buffer.size());
        Iterator<Pair<Map<String, Object>, Map<String, Object>>> it = buffer.iterator();
        while (it.hasNext()) {
            Pair<Map<String, Object>, Map<String, Object>> pair = it.next();
            Map src = (Map)pair.getA();
            Map tmpTar = (Map)pair.getB();
            Object e = tmpTar.get(tarCandidateKey);
            if (srcMap.containsKey(e)) {
                IscBizException err = new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\uff08%s\uff09\u5728\u6e90\u5355\u4e2d\u53ef\u80fd\u5b58\u5728\u91cd\u590d\u6570\u636e\u884c\u3002", (String)"CheckUpdateStrategy_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e));
                err.setStackTrace(new StackTraceElement[0]);
                CompUtil.saveCompLog(this.input, src, null, null, null, err);
                this.getCounter().incDuplicateCount(1);
            } else {
                srcMap.put(e, src);
                expMap.put(e, tmpTar);
            }
            it.remove();
        }
        Map<String, Object> tar = this.input.readTarget(tarReader);
        while (tar != null) {
            Object key = tar.get(tarCandidateKey);
            Map tempSrc = (Map)srcMap.remove(key);
            Map expectMap = (Map)expMap.remove(key);
            if (tempSrc != null) {
                this.compUpdate(tempSrc, tar, expectMap);
            } else {
                IscBizException e = new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\uff08%s\uff09\u5728\u76ee\u6807\u5355\u4e2d\u53ef\u80fd\u5b58\u5728\u91cd\u590d\u6570\u636e\u884c\u3002", (String)"CheckUpdateStrategy_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
                e.setStackTrace(new StackTraceElement[0]);
                CompUtil.saveCompLog(this.input, null, tar, null, null, e);
            }
            tar = this.input.readTarget(tarReader);
        }
        if (!srcMap.isEmpty()) {
            CompUtil.saveCompLogs(this.input, srcMap, expMap, ResultType.exist, null);
            this.getCounter().incNotExistCount(srcMap.size());
        }
    }

    private Map<String, Object> readSource() {
        return this.input.readSource(this.srcReader);
    }

    @Override
    public void dispose() {
        DbUtil.close(this.srcReader);
    }
}

