/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.datacomp.param.Counter;
import kd.isc.iscb.platform.core.datacomp.param.DataCompSchema;
import kd.isc.iscb.platform.core.datacomp.param.DataCompstConsumer;
import kd.isc.iscb.platform.core.datacomp.param.Repository;
import kd.isc.iscb.platform.core.datacomp.util.CompUtil;
import kd.isc.iscb.platform.core.datacomp.util.IProgressRefresher;
import kd.isc.iscb.platform.core.dc.e.DataCopyAttachment;
import kd.isc.iscb.platform.core.dc.e.DataCopyInput;
import kd.isc.iscb.platform.core.dc.e.DataCopyMapping;
import kd.isc.iscb.platform.core.dc.e.DataCopyOidLookup;
import kd.isc.iscb.platform.core.dc.e.DataCopyOutput;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.MarkedReader;
import kd.isc.iscb.platform.core.dc.meta.DefaultDataCopyProvider;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class CompensateUtil {
    public static void execute(long data_comp_id, Object executionId, IProgressRefresher refresher) {
        DynamicObject comp = DataCompSchema.get(data_comp_id);
        Object trigger = comp.get("trigger");
        Counter counter = new Counter();
        if (trigger != null) {
            DynamicObject execution = (DynamicObject)trigger;
            Object triggerId = execution.getPkValue();
            CompensateUtil.compensateForProgress(executionId, triggerId, refresher, counter);
        } else {
            Object data_copy_id = comp.get("data_copy_id");
            CompensateUtil.compensateForProgress(executionId, data_copy_id, refresher, counter);
        }
    }

    public static void dataCompensate(String executionId, Object id, IProgressRefresher refresher, Counter counter) {
        CompensateUtil.compensateForProgress(executionId, id, refresher, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compensateForProgress(Object executionId, Object id, IProgressRefresher refresher, Counter counter) {
        List<Object> values = Collections.singletonList(D.s((Object)executionId));
        List<Integer> types = Collections.singletonList(12);
        String sql = "select fsource_data,fsource_data_tag from t_isc_data_comp_exe_det where fdata_comp_exe = ? and (fcompensate_state = 'N' or fcompensate_state = 'F')";
        String sql2 = "select count(1) from t_isc_data_comp_exe_det where fdata_comp_exe = ? and (fcompensate_state = 'N' or fcompensate_state = 'F')";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            SignalManager.registerBackTask(executionId.toString());
            int totalCount = (int)DbUtil.executeCount((Connection)cn, (String)sql2, values, types);
            counter.setSyn_total_count(totalCount);
            if (totalCount == 0) {
                if (refresher != null) {
                    refresher.reset();
                }
                return;
            }
            CompensateUtil.doJob(executionId, id, refresher, values, types, sql, cn, counter);
        }
        catch (Exception e) {
            CompensateUtil.saveErrorLog(e, executionId);
            if (e instanceof TaskCancelException) {
                if (refresher != null) {
                    refresher.notifyCancel();
                }
                throw (TaskCancelException)((Object)e);
            }
            refresher.notifyError();
        }
        finally {
            DbUtil.close((Connection)cn);
            SignalManager.unregisterTask(executionId.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doJob(Object executionId, Object id, IProgressRefresher refresher, List<Object> values, List<Integer> types, String sql, Connection cn, Counter counter) {
        DynamicObject schema = DataCopySchema.get(D.l((Object)id));
        String primaryKey = CompensateUtil.getPrimaryKey(schema);
        DataCopyParam param = CompensateUtil.initByParams(primaryKey, null, schema);
        Repository repository = CompensateUtil.getRespository(param);
        repository.setExecutionId(executionId);
        repository.setTotalCount(counter.getSyn_total_count());
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, values, types, (int)500);
        try {
            Map<String, Object> src = CompensateUtil.readSource((ObjectReader<DataRow>)reader);
            while (src != null) {
                CompensateUtil.checkCancelSignal();
                String fsource_data_tag = D.s((Object)src.get("fsource_data_tag"));
                Object fsource_data = StringUtil.isEmpty((String)fsource_data_tag) ? Json.toObject((String)D.s((Object)src.get("fsource_data"))) : Json.toObject((String)fsource_data_tag.replaceAll("[\r\n\t]", ""));
                if (fsource_data instanceof Map) {
                    List<Object> list = Collections.singletonList(D.s(((Map)fsource_data).get(primaryKey)));
                    CompensateUtil.prepareParam(primaryKey, repository, list);
                    int count = CompensateUtil.executeDataCompstForProgress(repository, refresher, counter);
                    CompensateUtil.updateCount(executionId, cn, count);
                }
                src = CompensateUtil.readSource((ObjectReader<DataRow>)reader);
            }
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    private static void prepareParam(String primaryKey, Repository repository, List<Object> list) {
        repository.setCompList(list);
        List<Map<String, Object>> filterItems = CompensateUtil.constructFilterItems(primaryKey, list);
        repository.setFilter(filterItems);
    }

    private static Repository getRespository(DataCopyParam param) {
        Repository repository = new Repository();
        repository.setPrimaryKey(CompensateUtil.getPrimaryKey(param.getSchema()));
        repository.setParam(param);
        DataCompstConsumer consumer = new DataCompstConsumer(param.getTargetSchema(), param);
        repository.setConsumer(consumer);
        return repository;
    }

    private static void updateCount(Object executionId, Connection cn, int count) {
        if (count <= 0) {
            return;
        }
        String sql = "update t_isc_data_comp_exe set fexecute_count = fexecute_count + " + count + " where fid = " + executionId;
        DbUtil.executeUpdate((Connection)cn, (String)sql);
        try {
            if (!cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            CompensateUtil.saveErrorLog(e, executionId);
        }
    }

    private static void checkCancelSignal() {
        SignalManager.checkCancelSignal();
    }

    public static void saveErrorLog(Throwable error, Object data_comp_exe_id) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_comp_exe_det");
        log.set("data_comp_exe", data_comp_exe_id);
        log.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        String message = " ";
        if (error != null) {
            message = String.format(ResManager.loadKDString((String)"\u5931\u8d25! %s", (String)"CompensateUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.toString((Throwable)error));
        }
        log.set("message", (Object)StringUtil.trim((String)message, (int)50));
        log.set("message_tag", (Object)(message.length() > 50 ? message : null));
        OperationServiceHelper.executeOperate((String)"save", (String)"isc_data_comp_exe_det", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)OperateOption.create());
    }

    public static String getPrimaryKey(DynamicObject schema) {
        String pk = null;
        long src_schema_id = schema.getLong("source_schema_id");
        DynamicObject src_schema = MetaDataSchema.get(src_schema_id);
        for (DynamicObject item : src_schema.getDynamicObjectCollection("prop_entryentity")) {
            if (!item.getBoolean("is_primary_key")) continue;
            String field = D.s((Object)item.get("prop_name"));
            if (pk == null || field.equals(pk)) {
                pk = field;
                continue;
            }
            return null;
        }
        return pk;
    }

    public static int executeDataCompst(Object executionId, String primaryKey, List<Object> list, DynamicObject schema) {
        DataCopyParam param = CompensateUtil.initByParams(primaryKey, null, schema);
        Repository repository = CompensateUtil.getRespository(param);
        repository.setExecutionId(executionId);
        repository.setTotalCount(list.size());
        CompensateUtil.prepareParam(primaryKey, repository, list);
        return CompensateUtil.executeDataCompstBySchema(repository, null, new Counter());
    }

    private static int executeDataCompstForProgress(Repository repository, IProgressRefresher refresher, Counter counter) {
        return CompensateUtil.executeDataCompstBySchema(repository, refresher, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeDataCompstBySchema(Repository repository, IProgressRefresher refresher, Counter counter) {
        DefaultDataCopyProvider provider = new DefaultDataCopyProvider(repository.getParam().getSourceSchema(), repository.getParam().getSourceConnection(), repository.getParam().getSourceRequires(), repository.getFilter(), Collections.singletonList(new Pair((Object)repository.getParam().getSourcePrimaryKey(), (Object)"asc")), null, null);
        DataCopyInput input = new DataCopyInput(provider);
        DataCopyOutput output = new DataCopyOutput(repository.getConsumer());
        try {
            int n = CompensateUtil.doDataCopy(input, output, repository, refresher, counter);
            return n;
        }
        finally {
            CompensateUtil.dispose(input, output);
        }
    }

    private static int doDataCopy(DataCopyInput input, DataCopyOutput output, Repository repository, IProgressRefresher refresher, Counter counter) {
        DataCopyMapping mapping = new DataCopyMapping(repository.getParam());
        Object pk = null;
        int errCount = 0;
        int sucCount = 0;
        Map<String, Object> src = input.read();
        while (src != null) {
            try {
                pk = src.get(repository.getPrimaryKey());
                DataCopyAttachment.handleAttachmentFile(repository.getParam(), src);
                Map<String, Object> tar = mapping.translateAll(src);
                DataCopyOidLookup.restoreFromOidMapping(repository.getParam(), src, tar);
                if (!MarkedReader.isIgnored(tar)) {
                    output.write(tar);
                }
                CompensateUtil.updateCompensateState(repository.getExecutionId(), Collections.singletonList(pk), "S", "");
                ++sucCount;
                counter.incSyn_suc_count(1);
            }
            catch (Exception error) {
                ++errCount;
                counter.incSyn_err_count(1);
                String message = StringUtil.toString((Throwable)error);
                CompensateUtil.updateCompensateState(repository.getExecutionId(), Collections.singletonList(pk), "F", message);
            }
            src = input.read();
        }
        if (refresher != null) {
            if (sucCount == 0 && errCount == 0) {
                errCount = repository.getCompList().size();
            }
            refresher.setCount(sucCount, errCount);
            refresher.refresh(sucCount + errCount, repository.getTotalCount());
        }
        return sucCount;
    }

    private static void updateCompensateState(Object pkValue, List pk, String flag, String exception) {
        if (pkValue != null && pk != null) {
            String sql = "update t_isc_data_comp_exe_det set fcompensate_state = ?,fcompensate_log = ? ,fcompensate_log_tag = ? where fdata_comp_exe = ? and fsrc_pk in (?)";
            String s = pk.toString();
            String exception_tag = "";
            if (StringUtil.isEmpty((String)exception)) {
                exception = " ";
            } else {
                exception_tag = exception.length() > 80 ? exception : null;
                exception = StringUtil.trim((String)exception, (int)80);
            }
            List<Object> values = Arrays.asList(flag, exception, exception_tag, pkValue, s.substring(1, s.length() - 1));
            List<Integer> types = Arrays.asList(12, 12, 12, 12, 12);
            try {
                CompensateUtil.executeUpdate(sql, values, types);
            }
            catch (Exception e) {
                CompensateUtil.executeUpdate(sql, values, types);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeUpdate(String sql, List<Object> values, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static DataCopyParam initByParams(String primaryKey, List<Object> list, DynamicObject schema) {
        List<Map<String, Object>> filterItems = CompensateUtil.constructFilterItems(primaryKey, list);
        return new DataCopyParam(schema, filterItems);
    }

    private static Map<String, Object> readSource(ObjectReader<DataRow> srcReader) {
        Map<String, Object> data = (Map<String, Object>)srcReader.read();
        if (data != null) {
            data = CompUtil.dataRow2Map(data);
        }
        return data;
    }

    private static List<Map<String, Object>> constructFilterItems(String primaryKey, List<Object> filterItems) {
        if (filterItems == null) {
            return Collections.singletonList(new HashMap(0));
        }
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("filter_left_bracket", Character.valueOf('('));
        item.put("filter_column", primaryKey);
        item.put("filter_compare", "in");
        StringBuilder sb = new StringBuilder(filterItems.size());
        sb.append('[');
        int i = 1;
        for (Object filterItem : filterItems) {
            sb.append('\'');
            sb.append(filterItem);
            sb.append('\'');
            if (i++ >= filterItems.size()) continue;
            sb.append(',');
        }
        sb.append(']');
        item.put("filter_value", sb.toString());
        item.put("filter_right_bracket", Character.valueOf(')'));
        return Collections.singletonList(item);
    }

    private static void dispose(DataCopyInput input, DataCopyOutput output) {
        output.dispose();
        input.dispose();
    }
}

